package com.xforceplus.ultraman.adapter.elasticsearch.service.adatper;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.xforceplus.ultraman.cdc.adapter.IndexUpsertBeforeCallBack;
import com.xforceplus.ultraman.metadata.cdc.OqsEngineEntity;
import com.xforceplus.ultraman.sdk.infra.utils.JacksonDefaultMapper;
import lombok.extern.slf4j.Slf4j;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Slf4j
public class MultiValueRawExtend implements IndexUpsertBeforeCallBack {

    private final static String RAW = "@raw";

    @Override
    public OqsEngineEntity doBeforeUpsert(OqsEngineEntity oqsEngineEntity) {
        Map<String, Object> attributes = oqsEngineEntity.getAttributes();
        Map<String, Object> mapping = new HashMap<>(attributes);
        attributes.entrySet().forEach(entry -> {
            if (entry.getValue() instanceof List) {
                String key = entry.getKey();
                try {
                    mapping.put(key.concat(RAW), JacksonDefaultMapper.OBJECT_MAPPER.writeValueAsString(entry.getValue()));
                } catch (Throwable e) {
                    log.error("{}", e);
                }
            }
        });

        oqsEngineEntity.setAttributes(mapping);
        return oqsEngineEntity;
    }
}
