package com.xforceplus.ultraman.adapter.elasticsearch.service.adatper;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.xforceplus.metadata.schema.runtime.MetadataEngine;
import com.xforceplus.tech.base.core.context.ContextKeys;
import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.ultraman.adapter.elasticsearch.query.po.BocpElasticConfigPo;
import com.xforceplus.ultraman.adapter.elasticsearch.service.utils.BocpMetabaseCacheUtils;
import com.xforceplus.ultraman.cdc.adapter.CDCBeforeCallback;
import com.xforceplus.ultraman.metadata.cdc.OqsEngineEntity;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.metadata.engine.EntityClassGroup;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.metadata.entity.IRelation;
import com.xforceplus.ultraman.sdk.core.datasource.route.dynamic.DynamicDataSource;
import com.xforceplus.ultraman.sdk.infra.utils.JacksonDefaultMapper;
import com.xforceplus.ultraman.sdk.infra.utils.ThreadFactoryHelper;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import org.apache.commons.lang3.StringUtils;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;

import javax.sql.DataSource;
import java.sql.*;
import java.util.*;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;

import static com.xforceplus.metadata.schema.dsl.Step.BO;
import static com.xforceplus.metadata.schema.rels.MetadataRelationType.TO_ONE;
import static com.xforceplus.metadata.schema.runtime.MetadataEngine.*;

/**
 * get to one related id
 */
public class ToOneRelatedCallback implements CDCBeforeCallback {

    private static final String SQL = "SELECT * from %s where %s in (%s)";

    @Autowired
    private EntityClassEngine engine;

    @Lazy
    @Qualifier("master")
    @Autowired
    private DataSource dataSource;

    @Autowired
    private ContextService contextService;

    private ExecutorService executorService;

    public ToOneRelatedCallback() {
        //int worker, int queue, String namePrefix, boolean daemon
        executorService = ThreadFactoryHelper.buildThreadPool(20, 1000, "ToOneRelated", false);
    }

    public void setEngine(EntityClassEngine engine) {
        this.engine = engine;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setContextService(ContextService contextService) {
        this.contextService = contextService;
    }

    @Override
    public String name() {
        return getClass().getName();
    }

    //TODO
    @Override
    public void mutate(List<OqsEngineEntity> oqsEngineEntities) {
        /**
         * TODO check profile
         */
        Map<Long, List<OqsEngineEntity>> grouped = oqsEngineEntities.stream()
                .collect(Collectors.groupingBy(x -> x.getEntityClassRef().getId()));

        //TODO cache
        grouped.forEach((k, v) -> {

            Map<String, List<OqsEngineEntity>> profiledMapping = oqsEngineEntities.stream()
                    .collect(Collectors.groupingBy(x -> x.getEntityClassRef().getProfile()));
            MetadataEngine meta = engine.meta();
            /**
             * find related bo which has relation to this id
             */

            List<Tuple2<String, String>> toOne = meta.raw(g -> {
                List<Tuple2<String, String>> relatedList = new ArrayList<>();
                GraphTraversal<Vertex, Map<String, Object>> select = g.traversal().V().has(LABEL_INDEX, BO).has(ID_INDEX, k)
                        .inE(TO_ONE.name()).as("TO_ONE").outV().as("RELATED_V").select("TO_ONE", "RELATED_V");
                while (select.hasNext()) {
                    Map<String, Object> next = select.next();
                    Edge edge = (Edge) next.get("TO_ONE");
                    Vertex relatedV = (Vertex) next.get("RELATED_V");
                    String related = edge.value("code");
                    String id = relatedV.value(ID_INDEX);
                    relatedList.add(Tuple.of(related, id));
                }
                return relatedList;
            });

            //TO_ONE to this class
            toOne.forEach(rel -> {
                Optional<IEntityClass> related = engine.load(rel._2, "");
                if (related.isPresent()) {
                    IEntityClass targetRelated = related.get();
                    //find current with related
                    fillRelatedId(rel._1, targetRelated, v, false);
                }
            });


            //do to one self
            //check if need do this with configuration
            Optional<IEntityClass> selfOp = engine.load(Long.toString(k), "");
            if (selfOp.isPresent()) {
                IEntityClass entityClass = selfOp.get();
                //TODO current has no profiled relation
                EntityClassGroup describe = engine.describe(entityClass, "");
                describe.getAllRelations().forEach(rel -> {
                    if (rel.getRelationType().equalsIgnoreCase("TO_ONE")) {
                        Optional<IEntityClass> relatedEntityClass = describe.relatedEntityClass(rel.getName());
                        if (relatedEntityClass.isPresent()) {
                            List<OqsEngineEntity> needForRetrieve = new ArrayList<>();
                            profiledMapping.forEach((p, rest) -> {
                                Map<Long, BocpElasticConfigPo> bocpConfig = BocpMetabaseCacheUtils.getBocpConfig(p);
                                if (bocpConfig != null) {
                                    BocpElasticConfigPo bocpElasticConfigPo = bocpConfig.get(relatedEntityClass.get().id());
                                    if (bocpElasticConfigPo != null && bocpElasticConfigPo.isEnableSegment()) {
                                        needForRetrieve.addAll(rest);
                                    }
                                }
                            });
                            fillRelatedId(rel.getName(), relatedEntityClass.get(), needForRetrieve, true);
                        }
                    }
                });
            }
        });
    }

    //self -> get $related_id
    //!self -> get id
    void fillRelatedId(String related, IEntityClass entityClass, List<OqsEngineEntity> oqsEngineEntities, boolean isSelf) {
        //group by tenant
        Map<String, List<OqsEngineEntity>> tenantGrouped = oqsEngineEntities.stream()
                .collect(Collectors.groupingBy(x -> {
                    Object tenantCode = x.getAttributes().get("tenant_code");
                    if (tenantCode == null) {
                        return "DEFAULT";
                    } else {
                        return tenantCode.toString();
                    }
                }));


        tenantGrouped.forEach((k, v) -> {
            try {
                executorService.submit(() -> {
                    try {

                        Map<Long, List<Long>> idMapping = new HashMap<>();
                        String ids;
                        if (!isSelf) {
                            ids = v.stream().map(OqsEngineEntity::getId).map(Object::toString)
                                    .distinct().collect(Collectors.joining(","));
                        } else {
                            ids = v.stream()
                                    .map(x -> {
                                        Map<String, Object> attributes = x.getAttributes();
                                        Object id = attributes.get(related.concat("_id"));
                                        if (id != null) {
                                            Long idLong = Long.parseLong(id.toString());
                                            idMapping.compute(idLong, (k1, v1) -> {
                                                if (v1 == null) {
                                                    v1 = new ArrayList<>();
                                                }
                                                v1.add(x.getId());
                                                return v1;
                                            });
                                        }
                                        return id;
                                    })
                                    .filter(Objects::nonNull)
                                    .map(Object::toString)
                                    .distinct().collect(Collectors.joining(","));
                        }

                        if (StringUtils.isEmpty(ids)) {
                            return;
                        }

                        /**
                         * idMapping
                         */
                        Map<Long, OqsEngineEntity> hashSearch = v.stream()
                                .collect(Collectors.toMap(OqsEngineEntity::getId, y -> y, (a, b) -> a));

                        if (!"DEFAULT".equals(k)) {
                            contextService.set(ContextKeys.StringKeys.TENANTCODE_KEY, k);
                        }

                        //do search and
                        String relatedID;
                        if (!isSelf) {
                            relatedID = related.concat("_id");
                        } else {
                            //just query with id
                            relatedID = "id";
                        }

                        String sql = String.format(SQL, entityClass.masterWriteTable(true), relatedID, ids);
                        Map<Long, Tuple2<Long, Map<String, Object>>> mapping = new HashMap<>();
                        try (Connection connection = dataSource.getConnection()
                             ; PreparedStatement statement = connection.prepareStatement(sql)) {
                            ResultSet resultSet = statement.executeQuery();
                            ResultSetMetaData metaData = resultSet.getMetaData();
                            int columnCount = metaData.getColumnCount();
                            while (resultSet.next()) {

                                long mainId = resultSet.getLong("id");
                                List<Long> relatedId = new ArrayList<>();
                                if (!isSelf) {
                                    relatedId.add(resultSet.getLong(relatedID));
                                } else {
                                    //get mapping from id
                                    relatedId = idMapping.get(mainId);
                                }
                                String dynamic = resultSet.getString("_sys_dynamic");
                                Map<String, Object> rawBody = new HashMap<>();
                                for (int i = 1; i <= columnCount; i++) {
                                    String columnName = metaData.getColumnName(i);
                                    if (!columnName.equalsIgnoreCase("_sys_dynamic")) {
                                        rawBody.put(columnName, resultSet.getObject(i));
                                    }
                                }

                                try {
                                    Map<String, Object> dynamicValue = JacksonDefaultMapper.OBJECT_MAPPER.readValue(dynamic, Map.class);
                                    rawBody.putAll(dynamicValue);
                                } catch (JsonProcessingException e) {
                                    e.printStackTrace();
                                }
                                //get other value from entityclass
                                relatedId.forEach(rd -> {
                                    mapping.put(rd, Tuple.of(mainId, rawBody));
                                });
                            }
                            statement.close();
                            resultSet.close();
                        }

                        mapping.forEach((t1, t2) -> {
                            OqsEngineEntity oqsEngineEntity = hashSearch.get(t1);
                            if (oqsEngineEntity != null) {
                                oqsEngineEntity.getToOneRelatedList().add(Tuple.of(entityClass.code(), k, related, t2));
                            }
                        });
                    } catch (SQLException e) {
                        e.printStackTrace();
                    }
                    contextService.clear();
                }).get();
            } catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
        });
    }
}
