/*
package com.xforceplus.ultraman.adapter.elasticsearch.service.impl;

import com.xforceplus.ultraman.adapter.elasticsearch.service.EntityClassRelationService;
import com.xforceplus.ultraman.adapter.elasticsearch.service.constant.CommonProperty;
import com.xforceplus.ultraman.cdc.utils.TimeWaitUtils;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.metadata.entity.IEntityField;
import com.xforceplus.ultraman.metadata.entity.IRelation;
import com.xforceplus.ultraman.sdk.core.datasource.route.dynamic.config.DynamicConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import scala.Tuple2;

*/
/**
 * @ClassName EntityClassRelationInitialization
 * @description:
 * @author: WanYi
 * @create: 2023-07-19 20:26
 * @Version 1.0
 **//*

@Slf4j
public class EntityClassRelationServiceImpl implements EntityClassRelationService {

  private Map<String, Map<Long, Collection<IRelation>>> tenantEntityRelationMapping = new HashMap<>();
  private Map<String, Map<Long, IEntityClass>> tenantEntitysMapping = new HashMap<>();
  private Map<String, Map<Long, Map<String, IRelation>>> tenantCdcRelation = new HashMap<>();
  private Map<String, Map<Long, List<Tuple2<IEntityClass, IRelation>>>> tenantCdcRelationMapping = new HashMap<>();
  private Map<String, Map<Long, Collection<IEntityField>>> tenantEntityFields = new HashMap<>();


  @Autowired
  private EntityClassEngine engine;

  @Autowired
  private DynamicConfig dynamicConfig;

  private String profile = CommonProperty.defaultProfile;
  private boolean loadFinish = false;

  public EntityClassRelationServiceImpl() {
    super();
  }

  public void setEngine(EntityClassEngine engine) {
    this.engine = engine;
  }

  public void setDynamicConfig(DynamicConfig dynamicConfig) {
    this.dynamicConfig = dynamicConfig;
  }

  @Override
  public void initEntityClassRelation() {
    getEntityClassRelation(profile);
    dynamicConfig.getIndexRouting().entrySet().stream().forEach(entry ->
        getEntityClassRelation(entry.getKey()));
    loadFinish = true;
  }

  public void updateTenantCdcRelation(String profile, IRelation iRelation, IEntityClass iEntityClass,
      Map<String, Map<Long, Map<String, IRelation>>> tenantCdcRelationTemp) {
    profile = getProfile(profile);
    Map<Long, Map<String, IRelation>> entityRelationMapping = new HashMap<>();
    Map<Long, Map<String, IRelation>> cdcRelation = tenantCdcRelationTemp.putIfAbsent(profile, entityRelationMapping);
    cdcRelation = cdcRelation == null ? entityRelationMapping :
        cdcRelation;
    Map<String, IRelation> relationClass = new HashMap<>();
    Map<String, IRelation> cdcRelationClass = cdcRelation.putIfAbsent(iRelation.getEntityClassId(), relationClass);
    cdcRelationClass = cdcRelationClass == null ? relationClass : cdcRelationClass;
    cdcRelationClass.put(iEntityClass.code(), iRelation);
  }

  @Override
  public Map<String, IRelation> getTenantCdcRelation(String profile, IEntityClass iEntityClass) {
    if (loadFinish) {
      return tenantCdcRelation.getOrDefault(getProfile(profile), new HashMap<>()).get(iEntityClass.id());
    } else {
      loadFinish();
      return tenantCdcRelation.getOrDefault(getProfile(profile), new HashMap<>()).get(iEntityClass.id());
    }
  }

  private String getProfile(String profile) {
    if (profile == null || StringUtils.isEmpty(profile)) {
      profile = this.profile;
    }
    return profile;
  }

  private void getEntityClassRelation(String profile) {
    profile = getProfile(profile);
    Map<String, Map<Long, List<Tuple2<IEntityClass, IRelation>>>> tenantCdcRelationMappingTemp = new HashMap<>();
    Map<String, Map<Long, Map<String, IRelation>>> tenantCdcRelationTemp = new HashMap();
    Map entityRelationMapping = new HashMap<>();
    Map tenantEntitys = new HashMap<>();
    Map tenantEntityField = new HashMap<>();
    for (IEntityClass iEntityClass : engine.findAllEntities(profile)) {
      entityRelationMapping.put(iEntityClass.id(), iEntityClass.relations());
      String finalProfile = profile;
      iEntityClass.relations().forEach(iRelation -> updateTenantCdcRelation(finalProfile, iRelation, iEntityClass, tenantCdcRelationTemp));
      tenantEntityField.put(iEntityClass.id(), engine.describe(iEntityClass, profile).getAllFields());
      tenantEntitys.put(Long.valueOf(iEntityClass.id()), iEntityClass);
      initCdcRelationMapping(iEntityClass, finalProfile, tenantCdcRelationMappingTemp);
    }
    tenantEntityFields.put(profile, tenantEntityField);
    tenantEntitysMapping.put(profile, tenantEntitys);
    tenantEntityRelationMapping.put(profile, entityRelationMapping);
    */
/**更新之前缓存的元数据**//*

    tenantCdcRelationMapping.put(profile, tenantCdcRelationMappingTemp.get(profile));
    tenantCdcRelation.put(profile, tenantCdcRelationTemp.get(profile));
  }

  private void initCdcRelationMapping(IEntityClass iEntityClass, String finalProfile,
      Map<String, Map<Long, List<Tuple2<IEntityClass, IRelation>>>> tenantCdcRelationMappingTemp) {
    iEntityClass.relations().forEach(iRelation -> {
      Map<Long, List<Tuple2<IEntityClass, IRelation>>> tenantCdcRelation = new HashMap<>();
      Map<Long, List<Tuple2<IEntityClass, IRelation>>> tenantCdcRelations = tenantCdcRelationMappingTemp.putIfAbsent(finalProfile,
          tenantCdcRelation);
      tenantCdcRelations = tenantCdcRelations == null ? tenantCdcRelation : tenantCdcRelations;
      List<Tuple2<IEntityClass, IRelation>> relationMapping = new ArrayList<>();
      List<Tuple2<IEntityClass, IRelation>> iRelations = tenantCdcRelations.putIfAbsent(iRelation.getEntityClassId(), relationMapping);
      iRelations = iRelations == null ? relationMapping : iRelations;
      iRelations.add(new Tuple2<>(iEntityClass, iRelation));
    });
  }

  public Collection<IRelation> getTenantEntityRelationMapping(String profile, long entityClassId) {
    if (loadFinish) {
      return tenantEntityRelationMapping.getOrDefault(getProfile(profile), new HashMap<>()).get(entityClassId);
    } else {
      loadFinish();
      return tenantEntityRelationMapping.getOrDefault(getProfile(profile), new HashMap<>()).get(entityClassId);
    }
  }

  public IEntityClass getTenantEntityMapping(String profile, long entityClassId) {
    if (loadFinish) {
      return tenantEntitysMapping.getOrDefault(getProfile(profile), new HashMap<>()).get(entityClassId);
    } else {
      loadFinish();
      return tenantEntitysMapping.getOrDefault(getProfile(profile), new HashMap<>()).get(entityClassId);
    }
  }

  public Collection<IEntityField> getTenantEntityFields(String profile, long entityId) {
    if (loadFinish) {
      return tenantEntityFields.getOrDefault(getProfile(profile), new HashMap<>()).get(entityId);
    } else {
      loadFinish();
      return tenantEntityFields.getOrDefault(getProfile(profile), new HashMap<>()).get(entityId);
    }
  }

  @Override
  public List<Tuple2<IEntityClass, IRelation>> getTenantCdcRelationMapping(String profile, long entityId) {
    if (loadFinish) {
      return tenantCdcRelationMapping.getOrDefault(getProfile(profile), new HashMap<>()).get(entityId);
    } else {
      loadFinish();
      return tenantCdcRelationMapping.getOrDefault(getProfile(profile), new HashMap<>()).get(entityId);
    }
  }

  private boolean loadFinish() {
    while (!loadFinish) {
      TimeWaitUtils.wakeupAfter(CommonProperty.RECONNECT_WAIT_IN_SECONDS, TimeUnit.MILLISECONDS);
    }
    return loadFinish;
  }
}
*/
