package com.xforceplus.ultraman.adapter.elasticsearch.transport;

import com.typesafe.config.Config;
import com.xforceplus.ultraman.sdk.core.datasource.PackageInternal;
import com.xforceplus.ultraman.sdk.core.datasource.SupportClientType;
import com.xforceplus.ultraman.sdk.core.datasource.resolver.DataConfigResolver;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ElasticIndexResolver implements DataConfigResolver {

    private static PackageInternal buildRestHighLevelClient(List<Config> configs, boolean showSql) {
        RestHighLevelClient first = null;
        String name = SupportClientType.INDEX_DB.getName() + "-" + 0;
        Map<Object, Object> ds = new LinkedHashMap<>(configs.size());
        for (int i = 0; i < configs.size(); i++) {
            String dsName = SupportClientType.INDEX_DB.getName() + "-" + i;

            RestHighLevelClient restHighLevelClient = buildRestHighLevelClient(configs.get(i));
            if (i == 0) {
                first = restHighLevelClient;
            }
            ds.put(dsName, restHighLevelClient);
        }
        return new PackageInternal(name, first, ds);
    }

    private static RestHighLevelClient buildRestHighLevelClient(Config config) {
        RestClientBuilder restClientBuilder = RestClient.builder(new
                        HttpHost(config.getString("host"), config.getInt("port"))).
                setRequestConfigCallback(requestConfigBuilder -> requestConfigBuilder
                        .setConnectTimeout(config.getInt("connectTimeout"))  // default 1000
                        .setSocketTimeout(config.getInt("socketTimeout"))
                ).setHttpClientConfigCallback(httpAsyncClientBuilder -> {
                   
                    return httpAsyncClientBuilder;
                });// default 30000
        CredentialsProvider credentialsProvider = new BasicCredentialsProvider();

        String userName = config.getString("username");
        String password = config.getString("password");
        if (null != userName && !userName.isEmpty() &&
                null != password && !password.isEmpty()) {
            credentialsProvider.setCredentials(AuthScope.ANY,
                    new UsernamePasswordCredentials(config.getString("username"), config.getString("password")));
        }
        restClientBuilder.setHttpClientConfigCallback(httpAsyncClientBuilder -> {
            httpAsyncClientBuilder.
                    
                    setMaxConnPerRoute(1000);
            httpAsyncClientBuilder.setMaxConnTotal(10000);
            httpAsyncClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
            return httpAsyncClientBuilder;
        });
        return new RestHighLevelClient(restClientBuilder);
    }

    @Override
    public Tuple2<String, PackageInternal> resolve(Config config) {

        PackageInternal indexPackageInternal = null;
        if (config.hasPath(SupportClientType.INDEX_DB.getPath())) {
            indexPackageInternal = buildRestHighLevelClient(
                    (List<Config>) config.getConfigList(SupportClientType.INDEX_DB.getPath()), true);
        } else {
            indexPackageInternal = PackageInternal.emptyPackage();
        }

        return Tuple.of("index", indexPackageInternal);
    }
}
