package com.xforceplus.ultraman.adapter.elasticsearch.transport;

import com.xforceplus.ultraman.sdk.core.datasource.DataSourcePackage;
import com.xforceplus.ultraman.sdk.core.datasource.route.TransportExecutor;
import com.xforceplus.ultraman.sdk.core.datasource.route.dynamic.RouteMappingProvider;
import io.vavr.Tuple2;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.client.RestHighLevelClient;

import java.util.Collection;
import java.util.List;

/**
 * Created by justin.xu on 05/2023.
 *
 * @since 1.8
 */
public class ElasticsearchTransportExecutor implements TransportExecutor<RestHighLevelClient> {


  private DataSourcePackage dataSourcePackage;


  private RouteMappingProvider routeMappingProvider;

  public ElasticsearchTransportExecutor(DataSourcePackage dataSourcePackage,
      RouteMappingProvider routeMappingProvider) {
    this.dataSourcePackage = dataSourcePackage;
    this.routeMappingProvider = routeMappingProvider;
  }

  @Override
  public RestHighLevelClient executor(String profile) {
    if (StringUtils.isEmpty(profile)) {
      return (RestHighLevelClient) dataSourcePackage.getFirstIndex();
    } else {
      String routingKey = routeMappingProvider.findRoutingKey(profile);
      return null == routingKey ? (RestHighLevelClient) dataSourcePackage.getFirstIndex() :
          (RestHighLevelClient) dataSourcePackage.findIndex(routingKey, true);
    }
  }

  @Override
  public List<Tuple2<String, RestHighLevelClient>> executors(Collection<String> profiles) {
    return null;
  }

  public DataSourcePackage getDataSourcePackage() {
    return dataSourcePackage;
  }
}
