/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.adapter.elasticsearch;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.xforceplus.ultraman.adapter.elasticsearch.transport.ElasticsearchTransportExecutor;
import com.xforceplus.ultraman.sdk.core.datasource.route.TransportExecutor;
import com.xforceplus.ultraman.sdk.core.datasource.route.dynamic.config.DynamicConfig;
import io.vavr.Tuple2;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.client.indices.GetIndexResponse;
import org.elasticsearch.rest.RestStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class CustomElasticSearchTransport {
    private static final Logger log = LoggerFactory.getLogger(CustomElasticSearchTransport.class);
    @Autowired
    private DynamicConfig dynamicConfig;
    @Autowired
    private TransportExecutor elasticsearchTransportExecutor;

    public CustomElasticSearchTransport(DynamicConfig dynamicConfig, TransportExecutor elasticsearchTransportExecutor) {
        this.dynamicConfig = dynamicConfig;
        this.elasticsearchTransportExecutor = elasticsearchTransportExecutor;
    }

    public JSONObject getIndexStats(String indexName, String profile) {
        try {
            RestHighLevelClient executor = ((ElasticsearchTransportExecutor)this.elasticsearchTransportExecutor).executor(profile);
            String path = String.format(Locale.ROOT, "/%s/_stats?pretty", indexName);
            URIBuilder builder = new URIBuilder(path);
            HttpGet get = new HttpGet(builder.build());
            Response apply = new HttpFunction(executor.getLowLevelClient()).apply((HttpRequest)get);
            JSONObject jsonObject = JSON.parseObject((String)EntityUtils.toString((HttpEntity)apply.getEntity()));
            JSONObject primaries = jsonObject.getJSONObject("_all").getJSONObject("primaries");
            JSONObject docs = primaries.getJSONObject("docs");
            JSONObject store = primaries.getJSONObject("store");
            HashMap<String, JSONObject> indexStatus = new HashMap<String, JSONObject>();
            indexStatus.put("docs", docs);
            indexStatus.put("store", store);
            return new JSONObject(indexStatus);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public Set<String> getMatchIndexs(String matchIndexName, String profile, List<Tuple2<String, String>> errors) {
        try {
            String matchSegmentIndex = matchIndexName.concat("_*");
            RestHighLevelClient executor = ((ElasticsearchTransportExecutor)this.elasticsearchTransportExecutor).executor(profile);
            GetIndexResponse getIndexResponse = executor.indices().get(new GetIndexRequest(new String[]{matchSegmentIndex}), RequestOptions.DEFAULT);
            return getIndexResponse.getMappings().keySet();
        }
        catch (Throwable e) {
            if (((ElasticsearchStatusException)e).status() == RestStatus.NOT_FOUND) {
                log.info(e.getMessage());
            } else {
                log.error("FAILURE:elasticSearch execute method,cause by:", (Object)e.getMessage());
                errors.add((Tuple2<String, String>)new Tuple2((Object)matchIndexName, (Object)e.getMessage()));
            }
            return new HashSet<String>();
        }
    }

    private static class HttpFunction
    implements Function<HttpRequest, Response> {
        private final RestClient restClient;

        HttpFunction(RestClient restClient) {
            this.restClient = Objects.requireNonNull(restClient, "restClient");
        }

        @Override
        public Response apply(HttpRequest request) {
            try {
                return this.applyInternal(request);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        private Response applyInternal(HttpRequest request) throws IOException {
            String payload;
            Objects.requireNonNull(request, "request");
            HttpEntity entity = request instanceof HttpEntityEnclosingRequest ? ((HttpEntityEnclosingRequest)request).getEntity() : null;
            Request r = new Request(request.getRequestLine().getMethod(), request.getRequestLine().getUri());
            r.setEntity(entity);
            Response response = this.restClient.performRequest(r);
            String string = payload = entity != null && entity.isRepeatable() ? EntityUtils.toString((HttpEntity)entity) : "<empty>";
            if (response.getStatusLine().getStatusCode() != 200) {
                String error = EntityUtils.toString((HttpEntity)response.getEntity());
                String message = String.format(Locale.ROOT, "Error while querying Elastic (on %s/%s) status: %s\nPayload:\n%s\nError:\n%s\n", response.getHost(), response.getRequestLine(), response.getStatusLine(), payload, error);
                throw new RuntimeException(message);
            }
            return response;
        }
    }
}

