/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.adapter.elasticsearch;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.xforceplus.metadata.schema.dsl.metadata.__;
import com.xforceplus.metadata.schema.runtime.MetadataEngine;
import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.ultraman.adapter.elasticsearch.ElasticsearchTable;
import com.xforceplus.ultraman.adapter.elasticsearch.ElasticsearchTransport;
import com.xforceplus.ultraman.adapter.elasticsearch.service.ManageBocpMetadataService;
import com.xforceplus.ultraman.adapter.elasticsearch.transport.ElasticsearchTransportExecutor;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.sdk.core.calcite.LazySchemaMap;
import com.xforceplus.ultraman.sdk.core.datasource.route.TransportExecutor;
import com.xforceplus.ultraman.sdk.core.facade.ProfileFetcher;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.elasticsearch.client.RestClient;

public class ElasticsearchSchema
extends AbstractSchema {
    private MetadataEngine metadataEngine;
    private EntityClassEngine classEngine;
    private ContextService contextService;
    private ProfileFetcher fetcher;
    private int fetchSize;
    private ObjectMapper mapper;
    private Map<String, Table> tableMap;
    private String appCode;
    private TransportExecutor transportExecutor;
    private ManageBocpMetadataService manageBocpMetadataService;
    private Map<Tuple2<String, String>, ElasticsearchTransport> transportMap = new ConcurrentHashMap<Tuple2<String, String>, ElasticsearchTransport>();
    private LazySchemaMap<String, Table> schemaMap;

    @VisibleForTesting
    ElasticsearchSchema(TransportExecutor transportExecutor, ObjectMapper mapper, MetadataEngine metadataEngine, ProfileFetcher fetcher, EntityClassEngine entityClassEngine, ContextService contextService, ManageBocpMetadataService manageBocpMetadataService, String appCode, int fetchSize) {
        this.mapper = Objects.requireNonNull(mapper, "mapper");
        this.metadataEngine = metadataEngine;
        Preconditions.checkArgument((fetchSize > 0 ? 1 : 0) != 0, (String)"invalid fetch size. Expected %s > 0", (int)fetchSize);
        this.schemaMap = new LazySchemaMap(code -> {
            ElasticsearchTransport transport;
            String profile = fetcher.getProfile(contextService.getAll());
            RestClient client = ((ElasticsearchTransportExecutor)transportExecutor).executor(profile).getLowLevelClient();
            Tuple2<String, String> searchIndex = manageBocpMetadataService.getSearchSegmentIndex(profile, (String)code);
            Tuple2 key = Tuple.of((Object)code.toLowerCase(Locale.ROOT), (Object)searchIndex._2);
            ElasticsearchTransport elasticsearchTransport = this.transportMap.get(key);
            String prefix = manageBocpMetadataService.getIndexPrefix(profile, appCode);
            if (elasticsearchTransport == null) {
                transport = new ElasticsearchTransport(client, mapper, searchIndex, code.toLowerCase(Locale.ROOT), (String)code, fetchSize);
                this.transportMap.put((Tuple2<String, String>)key, transport);
            } else {
                transport = elasticsearchTransport;
            }
            return new ElasticsearchTable(this.classEngine, transport, contextService, fetcher, prefix, this);
        });
        this.schemaMap.keySet(() -> {
            List boList = metadataEngine.getMulti((GraphTraversal)__.has((String)"nodeLabel", (Object)"Bo"));
            return boList.stream().map(x -> x.get("code").toString().toLowerCase(Locale.ROOT)).collect(Collectors.toSet());
        });
        this.fetchSize = fetchSize;
        this.fetcher = fetcher;
        this.classEngine = entityClassEngine;
        this.contextService = contextService;
        this.tableMap = this.createTables();
        this.manageBocpMetadataService = manageBocpMetadataService;
        this.appCode = appCode;
        this.transportExecutor = transportExecutor;
    }

    public Map<Tuple2<String, String>, ElasticsearchTransport> getTransportMap() {
        return this.transportMap;
    }

    public ElasticsearchSchema(TransportExecutor transportExecutor, ObjectMapper mapper, MetadataEngine metadataEngine, EntityClassEngine entityClassEngine, ProfileFetcher fetcher, ContextService contextService, ManageBocpMetadataService manageBocpMetadataService, String appCode) {
        this(transportExecutor, mapper, metadataEngine, fetcher, entityClassEngine, contextService, manageBocpMetadataService, appCode, 5196);
    }

    protected Map<String, Table> getTableMap() {
        return this.tableMap;
    }

    private Map<String, Table> createTables() {
        return this.schemaMap;
    }
}

