/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.adapter.elasticsearch;

import com.alibaba.google.common.base.Supplier;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.collect.ImmutableMap;
import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.ultraman.adapter.elasticsearch.ElasticsearchEnumerators;
import com.xforceplus.ultraman.adapter.elasticsearch.ElasticsearchJson;
import com.xforceplus.ultraman.adapter.elasticsearch.ElasticsearchRel;
import com.xforceplus.ultraman.adapter.elasticsearch.ElasticsearchSchema;
import com.xforceplus.ultraman.adapter.elasticsearch.ElasticsearchTableScan;
import com.xforceplus.ultraman.adapter.elasticsearch.ElasticsearchTransport;
import com.xforceplus.ultraman.adapter.elasticsearch.ElasticsearchVersion;
import com.xforceplus.ultraman.adapter.elasticsearch.Scrolling;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.metadata.engine.EntityClassGroup;
import com.xforceplus.ultraman.metadata.entity.FieldType;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.metadata.entity.IRelation;
import com.xforceplus.ultraman.sdk.core.facade.ProfileFetcher;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.Tuple3;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.java.AbstractQueryableTable;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.Linq4j;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.linq4j.Queryable;
import org.apache.calcite.linq4j.function.Function1;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.QueryableTable;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.calcite.schema.impl.AbstractTableQueryable;
import org.apache.calcite.util.Pair;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchTable
extends AbstractQueryableTable
implements TranslatableTable {
    private static final Logger log = LoggerFactory.getLogger(ElasticsearchTable.class);
    private static final String AGGREGATIONS = "aggregations";
    public final ObjectMapper mapper;
    private final ElasticsearchVersion version;
    public final EntityClassEngine engine;
    private final ContextService contextService;
    public final ProfileFetcher fetcher;
    private final String indexName;
    private final ElasticsearchTransport transport;
    public final String entityCode;
    private final String prefix;
    public List<String> list = new ArrayList<String>();
    private ElasticsearchSchema schema;

    public ElasticsearchTable(EntityClassEngine engine, ElasticsearchTransport transport, ContextService contextService, ProfileFetcher fetcher, String prefix, ElasticsearchSchema schema) {
        super(Object[].class);
        this.engine = engine;
        this.transport = transport;
        this.version = Optional.ofNullable(transport).map(x -> x.version).orElse(null);
        this.mapper = Optional.ofNullable(transport).map(x -> x.mapper()).orElse(null);
        this.contextService = contextService;
        this.fetcher = fetcher;
        this.indexName = Optional.ofNullable(transport).map(x -> x.indexName).orElse(null);
        this.entityCode = Optional.ofNullable(transport).map(x -> x.entityCode).orElse(null);
        this.prefix = prefix;
        this.schema = schema;
    }

    public String scriptedFieldPrefix() {
        return this.version == ElasticsearchVersion.ES2 ? "_source" : "params._source";
    }

    private void merge(ObjectNode query, ObjectNode newNode, String key) {
        if (query.has(key)) {
            ObjectNode jsonNode = (ObjectNode)query.get(key);
            JsonNode newTargetNode = newNode.get("query");
            JsonNode jsonNode2 = ElasticsearchTable.merge((JsonNode)jsonNode, newTargetNode);
        } else {
            query.setAll(newNode);
        }
    }

    public static JsonNode merge(JsonNode mainNode, JsonNode updateNode) {
        Iterator fieldNames = updateNode.fieldNames();
        while (fieldNames.hasNext()) {
            String updatedFieldName = (String)fieldNames.next();
            JsonNode valueToBeUpdated = mainNode.get(updatedFieldName);
            JsonNode updatedValue = updateNode.get(updatedFieldName);
            if (valueToBeUpdated != null && valueToBeUpdated.isArray()) {
                if (updatedValue.isArray()) {
                    for (int i = 0; i < updatedValue.size(); ++i) {
                        JsonNode updatedChildNode = updatedValue.get(i);
                        if (valueToBeUpdated.size() <= i) {
                            ((ArrayNode)valueToBeUpdated).add(updatedChildNode);
                        }
                        JsonNode childNodeToBeUpdated = valueToBeUpdated.get(i);
                        ElasticsearchTable.merge(childNodeToBeUpdated, updatedChildNode);
                    }
                    continue;
                }
                ((ArrayNode)valueToBeUpdated).add(updatedValue);
                continue;
            }
            if (valueToBeUpdated != null && valueToBeUpdated.isObject()) {
                ElasticsearchTable.merge(valueToBeUpdated, updatedValue);
                continue;
            }
            if (!(mainNode instanceof ObjectNode)) continue;
            ((ObjectNode)mainNode).replace(updatedFieldName, updatedValue);
        }
        return mainNode;
    }

    public Enumerable<Object> find(List<String> ops, List<Map.Entry<String, Class>> fields, List<Map.Entry<String, RelFieldCollation.Direction>> sort, List<String> groupBy, List<Map.Entry<String, String>> aggregations, Map<String, String> mappings, Map<String, String> rawNameMapping, Long offset, Long fetch, RelNode rawTree, DataContext dataContext) throws IOException {
        if (this.transport == null) {
            return Linq4j.emptyEnumerable();
        }
        String profile = this.fetcher.getProfile(Collections.emptyMap());
        Optional targetOp = this.engine.loadByCode(this.entityCode, profile);
        if (!targetOp.isPresent()) {
            throw new RuntimeException("ElasticSearch Table Not found " + this.entityCode);
        }
        EntityClassGroup group = this.engine.describe((IEntityClass)targetOp.get(), profile);
        try {
            Iterable iter;
            if (!aggregations.isEmpty() || !groupBy.isEmpty()) {
                return this.aggregate(this.transport, group, ops, fields, sort, groupBy, aggregations, mappings, rawNameMapping, offset, fetch, false);
            }
            ObjectNode query = this.mapper.createObjectNode();
            Boolean join_query = this.contextService.getAll().get("join_query") != null && (Boolean)this.contextService.getAll().get("join_query") != false;
            String targetIndex = this.indexName;
            for (String op : ops) {
                if (this.mapper.readTree(op).get("query") != null) {
                    if (join_query.booleanValue()) {
                        targetIndex = this.generateJoinModelQuery(group, query, op);
                    } else {
                        query.setAll((ObjectNode)this.mapper.readTree(op));
                    }
                    if (this.contextService.getAll().get("hasCount") == null || !((Boolean)this.contextService.getAll().get("hasCount")).booleanValue()) continue;
                    if (this.indexName.equals(targetIndex)) {
                        this.executeQueryCount(this.transport, group, mappings, rawNameMapping, query.toString(), true);
                        continue;
                    }
                    ElasticsearchTable table = (ElasticsearchTable)this.schema.getTable(targetIndex);
                    this.executeQueryCount(table.transport, group, mappings, rawNameMapping, query.toString(), true);
                    continue;
                }
                if (this.mapper.readTree(op).get("fields") != null) {
                    if (!targetIndex.equalsIgnoreCase(this.indexName)) {
                        JsonNode jsonNode = this.mapper.readTree(op).get("fields");
                        ObjectNode fieldsNode = this.mapper.createObjectNode();
                        ArrayNode arrayNode = this.mapper.createArrayNode();
                        fieldsNode.put("fields", (JsonNode)arrayNode);
                        jsonNode.forEach(x -> {
                            if (x instanceof TextNode) {
                                arrayNode.add((JsonNode)new TextNode(group.getEntityClass().code().concat(".").concat(x.asText())));
                            }
                        });
                        query.setAll(fieldsNode);
                        continue;
                    }
                    query.setAll((ObjectNode)this.mapper.readTree(op));
                    continue;
                }
                query.setAll((ObjectNode)this.mapper.readTree(op));
            }
            if (!sort.isEmpty()) {
                ArrayNode sortNode = query.withArray("sort");
                sort.forEach(e -> {
                    String key = (String)e.getKey();
                    if (!StringUtils.isEmpty((CharSequence)key)) {
                        boolean isJson = key.startsWith("__json");
                        JsonNode input = null;
                        if (isJson) {
                            if (key.contains("$order$")) {
                                key = key.replace("$order$", ((RelFieldCollation.Direction)e.getValue()).isDescending() ? "desc" : "asc");
                            }
                            try {
                                input = this.mapper.readTree(key.substring(6));
                            }
                            catch (JsonProcessingException ex) {
                                ex.printStackTrace();
                            }
                        } else {
                            input = this.mapper.createObjectNode().put(key, ((RelFieldCollation.Direction)e.getValue()).isDescending() ? "desc" : "asc");
                        }
                        if (input != null) {
                            sortNode.add(input);
                        }
                    }
                });
            }
            if (offset != null) {
                query.put("from", offset);
            }
            if (fetch != null) {
                query.put("size", fetch);
            }
            query.put("_source", false);
            ElasticsearchTransport targetTransport = !targetIndex.equalsIgnoreCase(this.indexName) ? ((ElasticsearchTable)this.schema.getTable((String)targetIndex)).transport : this.transport;
            if (offset == null) {
                String finalTargetIndex = targetIndex;
                iter = () -> new Scrolling(targetTransport, group, this.contextService).query(finalTargetIndex.equalsIgnoreCase(this.indexName), query);
            } else {
                ElasticsearchJson.Result search = targetTransport.search().apply(query);
                ElasticsearchJson.SearchHits searchHits = search.searchHits();
                ElasticsearchJson.SearchTotal total = searchHits.total();
                if (total != null && this.contextService.getAll().get("show_count") == null) {
                    this.contextService.getAll().put("show_count", total.value());
                }
                String finalTargetIndex1 = targetIndex;
                iter = () -> search.searchHits().flattenHits(finalTargetIndex1.equalsIgnoreCase(this.indexName), group).iterator();
            }
            Function1<ElasticsearchJson.SearchHit, Object> getter = ElasticsearchEnumerators.getter(fields, rawNameMapping, (Map<String, String>)ImmutableMap.copyOf(mappings));
            return Linq4j.asEnumerable(iter).select(getter);
        }
        catch (Throwable throwable) {
            log.warn("elasticsearch table execute query failed!, {}", (Object)throwable.getMessage());
            this.contextService.getAll().compute("errors", (k, v) -> {
                if (v == null) {
                    v = new ArrayList();
                }
                ((List)v).add(throwable.getMessage());
                return v;
            });
            throw throwable;
        }
    }

    private void executeQueryCount(ElasticsearchTransport targetTransport, EntityClassGroup group, Map<String, String> mappings, Map<String, String> rawMapping, String op, boolean ignoreJoin) throws IOException {
        HashMap<String, String> aggregationMap = new HashMap<String, String>();
        HashMap<String, Class<Long>> fieldMap = new HashMap<String, Class<Long>>();
        aggregationMap.put("c", "{\"value_count\":{\"field\":\"_id\"}}");
        fieldMap.put("c", Long.class);
        ArrayList<Map.Entry<String, Class>> fieldEntries = new ArrayList<Map.Entry<String, Class>>();
        ArrayList<Map.Entry<String, String>> aggregationEntries = new ArrayList<Map.Entry<String, String>>();
        aggregationEntries.addAll(aggregationMap.entrySet());
        fieldEntries.addAll(fieldMap.entrySet());
        this.aggregate(targetTransport, group, Collections.singletonList(op), fieldEntries, new ArrayList<Map.Entry<String, RelFieldCollation.Direction>>(), new ArrayList<String>(), aggregationEntries, mappings, rawMapping, null, null, ignoreJoin);
    }

    private String visitor(JsonNode sourceNode, ObjectMapper mapper, JsonNode node, Set<Tuple2<JsonNode, JsonNode>> nonRelatedPos, Set<Tuple3<String, JsonNode, JsonNode>> relatedPos, Set<Tuple3<String, JsonNode, JsonNode>> relatedAnchorList, Set<Tuple2<JsonNode, JsonNode>> selfAnchorList) {
        if (sourceNode.isArray()) {
            Iterator elements = sourceNode.elements();
            while (elements.hasNext()) {
                JsonNode next = (JsonNode)elements.next();
                this.visitor(next, mapper, node, nonRelatedPos, relatedPos, relatedAnchorList, selfAnchorList);
            }
        } else if (sourceNode.isObject()) {
            Iterator rootFields = sourceNode.fields();
            ObjectNode parent = mapper.createObjectNode();
            block21: while (rootFields.hasNext()) {
                Map.Entry next = (Map.Entry)rootFields.next();
                String nextToken = (String)next.getKey();
                if (node != null) {
                    if (node.isArray()) {
                        ((ArrayNode)node).add((JsonNode)parent);
                    } else {
                        ((ObjectNode)node).put(nextToken, (JsonNode)parent);
                    }
                }
                switch (nextToken) {
                    case "bool": {
                        JsonNode value = (JsonNode)next.getValue();
                        Iterator subClauses = value.fields();
                        block22: while (subClauses.hasNext()) {
                            String subClauseKey;
                            Map.Entry subClause = (Map.Entry)subClauses.next();
                            switch (subClauseKey = (String)subClause.getKey()) {
                                case "must_not": 
                                case "filter": 
                                case "must": {
                                    JsonNode mustClause = (JsonNode)subClause.getValue();
                                    if (mustClause instanceof ArrayNode) {
                                        ArrayNode arrayNode = mapper.createArrayNode();
                                        parent.put(subClauseKey, (JsonNode)arrayNode);
                                        HashMap<String, ArrayNode> relatedMapping = new HashMap<String, ArrayNode>();
                                        for (JsonNode x : mustClause) {
                                            String relatedCode = this.visitor(x, mapper, null, nonRelatedPos, relatedPos, relatedAnchorList, selfAnchorList);
                                            if (!StringUtils.isEmpty((CharSequence)relatedCode)) {
                                                relatedMapping.compute(relatedCode, (k, v) -> {
                                                    if (v == null) {
                                                        v = mapper.createArrayNode();
                                                    }
                                                    v.add(x);
                                                    return v;
                                                });
                                                continue;
                                            }
                                            selfAnchorList.add((Tuple2<JsonNode, JsonNode>)Tuple.of((Object)arrayNode, (Object)x));
                                        }
                                        if (relatedMapping.isEmpty()) continue block22;
                                        for (Map.Entry entry : relatedMapping.entrySet()) {
                                            relatedAnchorList.add((Tuple3<String, JsonNode, JsonNode>)Tuple.of(entry.getKey(), (Object)arrayNode, entry.getValue()));
                                        }
                                        continue block22;
                                    }
                                    return this.visitor(mustClause, mapper, (JsonNode)parent, nonRelatedPos, relatedPos, relatedAnchorList, selfAnchorList);
                                }
                            }
                        }
                        continue block21;
                    }
                    case "match": 
                    case "range": 
                    case "term": {
                        return this.visitor((JsonNode)next.getValue(), mapper, (JsonNode)parent, nonRelatedPos, relatedPos, relatedAnchorList, selfAnchorList);
                    }
                    case "exists": {
                        JsonNode existsFields = (JsonNode)next.getValue();
                        JsonNode jsonNode1 = existsFields.get("field");
                        String relatedResult = this.visitor(jsonNode1, mapper, (JsonNode)parent, nonRelatedPos, relatedPos, relatedAnchorList, selfAnchorList);
                        if (!StringUtils.isEmpty((CharSequence)relatedResult)) {
                            relatedPos.add((Tuple3<String, JsonNode, JsonNode>)Tuple.of((Object)relatedResult, (Object)sourceNode, (Object)existsFields));
                        } else {
                            nonRelatedPos.add((Tuple2<JsonNode, JsonNode>)Tuple.of((Object)sourceNode, (Object)existsFields));
                        }
                        return relatedResult;
                    }
                }
                String key = (String)next.getKey();
                if (key.contains(".")) {
                    String relatedCode = key.split("\\.")[0];
                    relatedPos.add((Tuple3<String, JsonNode, JsonNode>)Tuple.of((Object)relatedCode, (Object)sourceNode, (Object)sourceNode));
                    return relatedCode;
                }
                nonRelatedPos.add((Tuple2<JsonNode, JsonNode>)Tuple.of((Object)sourceNode, (Object)sourceNode));
                parent.set(key, (JsonNode)next.getValue());
            }
        } else if (sourceNode.isTextual() && sourceNode.textValue().contains(".")) {
            String[] split = sourceNode.textValue().split("\\.");
            return split[0];
        }
        return null;
    }

    private String generateJoinModelQuery(EntityClassGroup group, ObjectNode query, String op) throws JsonProcessingException {
        JsonNode queryNodes = this.mapper.readTree(op).get("query");
        JsonNode jsonNode = queryNodes.get("constant_score").get("filter");
        ObjectNode objectNode = this.mapper.createObjectNode();
        HashSet<Tuple3<String, JsonNode, JsonNode>> list = new HashSet<Tuple3<String, JsonNode, JsonNode>>();
        HashSet<Tuple2<JsonNode, JsonNode>> noneList = new HashSet<Tuple2<JsonNode, JsonNode>>();
        HashSet<Tuple3<String, JsonNode, JsonNode>> anchorList = new HashSet<Tuple3<String, JsonNode, JsonNode>>();
        HashSet<Tuple2<JsonNode, JsonNode>> selfAnchorList = new HashSet<Tuple2<JsonNode, JsonNode>>();
        this.visitor(jsonNode, this.mapper, (JsonNode)objectNode, noneList, list, anchorList, selfAnchorList);
        boolean needQueryInRelatedIndex = false;
        String targetEntityCode = null;
        HashSet<String> toOneRelatedSet = new HashSet<String>();
        if (!list.isEmpty()) {
            for (Tuple3 tuple3 : list) {
                Optional relatedEntityClassOp;
                JsonNode jsonNode2 = (JsonNode)tuple3._2;
                String relatedCode = (String)tuple3._1;
                Optional relation = group.relation(relatedCode);
                if (!relation.isPresent()) continue;
                boolean isToOne = ((IRelation)relation.get()).getRelationType().equalsIgnoreCase("TO_ONE");
                if (isToOne) {
                    toOneRelatedSet.add(relatedCode.toLowerCase());
                    if (toOneRelatedSet.size() > 1) {
                        throw new RuntimeException("Cannot query TO ONE more than one");
                    }
                    needQueryInRelatedIndex = true;
                }
                if (!(relatedEntityClassOp = group.relatedEntityClass(relatedCode)).isPresent()) continue;
                targetEntityCode = ((IEntityClass)relatedEntityClassOp.get()).code();
            }
            if (needQueryInRelatedIndex) {
                JsonNode jsonNode2;
                JsonNode jsonNode1;
                if (!anchorList.isEmpty()) {
                    for (Tuple3 tuple3 : anchorList) {
                        JsonNode jsonNode3 = (JsonNode)tuple3._2;
                        ObjectNode hasChildQuery = this.mapper.createObjectNode();
                        ObjectNode queryNode = this.mapper.createObjectNode();
                        ObjectNode mustNode = this.mapper.createObjectNode();
                        queryNode.set("bool", mustNode.set("must", (JsonNode)tuple3._3));
                        hasChildQuery.set("parent_type", (JsonNode)new TextNode(targetEntityCode));
                        hasChildQuery.set("query", (JsonNode)queryNode);
                        hasChildQuery.set("inner_hits", (JsonNode)this.mapper.createObjectNode());
                        if (jsonNode3.isArray()) {
                            ObjectNode childRootNode = this.mapper.createObjectNode();
                            ((ArrayNode)jsonNode3).add((JsonNode)childRootNode);
                            childRootNode.set("has_parent", (JsonNode)hasChildQuery);
                            continue;
                        }
                        ((ObjectNode)jsonNode3).set("has_parent", (JsonNode)hasChildQuery);
                    }
                }
                if (!selfAnchorList.isEmpty()) {
                    for (Tuple2 tuple2 : selfAnchorList) {
                        JsonNode jsonNode4 = (JsonNode)tuple2._1;
                        if (!jsonNode4.isArray()) continue;
                        ((ArrayNode)jsonNode4).add((JsonNode)tuple2._2);
                    }
                }
                String selfCode = group.getEntityClass().code();
                for (Tuple2 tuple2 : noneList) {
                    jsonNode1 = (JsonNode)tuple2._1;
                    jsonNode2 = (JsonNode)tuple2._2;
                    if (jsonNode1 != jsonNode2) continue;
                    if (jsonNode2.isObject()) {
                        Map.Entry next = (Map.Entry)jsonNode1.fields().next();
                        String newKey = selfCode.concat(".").concat((String)next.getKey());
                        ((ObjectNode)jsonNode1).removeAll();
                        ((ObjectNode)jsonNode1).set(newKey, (JsonNode)next.getValue());
                        continue;
                    }
                    log.warn("current not support non-object");
                }
                for (Tuple3 tuple3 : list) {
                    jsonNode1 = (JsonNode)tuple3._2;
                    jsonNode2 = (JsonNode)tuple3._3;
                    if (jsonNode1 == jsonNode2) {
                        if (jsonNode2.isObject()) {
                            Map.Entry next = (Map.Entry)jsonNode1.fields().next();
                            String[] split = ((String)next.getKey()).split("\\.");
                            String newKey = split[1];
                            ((ObjectNode)jsonNode1).removeAll();
                            ((ObjectNode)jsonNode1).set(newKey, (JsonNode)next.getValue());
                            continue;
                        }
                        log.warn("current not support non-object");
                        continue;
                    }
                    boolean field = jsonNode2.has("field");
                    if (!field) continue;
                    JsonNode jsonNode3 = jsonNode2.get("field");
                    if (jsonNode3.isTextual()) {
                        String resultString = jsonNode3.textValue().split("\\.")[1];
                        if (jsonNode1.isObject()) {
                            Iterator fields = jsonNode1.fields();
                            String targetName = null;
                            while (fields.hasNext()) {
                                Map.Entry next = (Map.Entry)fields.next();
                                if (next.getValue() != jsonNode2) continue;
                                targetName = (String)next.getKey();
                                break;
                            }
                            if (targetName == null) continue;
                            ObjectNode objectNode1 = this.mapper.createObjectNode();
                            objectNode1.set("field", (JsonNode)new TextNode(resultString));
                            ((ObjectNode)jsonNode1).set(targetName, (JsonNode)objectNode1);
                            continue;
                        }
                        if (!jsonNode1.isArray()) continue;
                        Iterator elements = jsonNode1.elements();
                        int i = 0;
                        boolean found = false;
                        while (elements.hasNext()) {
                            JsonNode next = (JsonNode)elements.next();
                            if (next == jsonNode2) {
                                found = true;
                                break;
                            }
                            ++i;
                        }
                        if (found) {
                            ((ArrayNode)jsonNode1).remove(i);
                        }
                        ((ArrayNode)jsonNode1).add((JsonNode)new TextNode(resultString));
                        continue;
                    }
                    log.warn("current not support non-textual");
                }
            } else {
                String finalTargetEntityCode = targetEntityCode;
                if (!anchorList.isEmpty()) {
                    for (Tuple3 tuple3 : anchorList) {
                        JsonNode anchorNode = (JsonNode)tuple3._2;
                        ObjectNode hasChildQuery = this.mapper.createObjectNode();
                        ObjectNode queryNode = this.mapper.createObjectNode();
                        ObjectNode mustNode = this.mapper.createObjectNode();
                        queryNode.set("bool", mustNode.set("must", (JsonNode)tuple3._3));
                        hasChildQuery.set("type", (JsonNode)new TextNode((String)tuple3._1));
                        hasChildQuery.set("query", (JsonNode)queryNode);
                        hasChildQuery.set("inner_hits", (JsonNode)this.mapper.createObjectNode());
                        if (anchorNode.isArray()) {
                            ObjectNode childRootNode = this.mapper.createObjectNode();
                            ((ArrayNode)anchorNode).add((JsonNode)childRootNode);
                            childRootNode.set("has_child", (JsonNode)hasChildQuery);
                            continue;
                        }
                        ((ObjectNode)anchorNode).set("has_child", (JsonNode)hasChildQuery);
                    }
                }
                if (!selfAnchorList.isEmpty()) {
                    for (Tuple2 tuple2 : selfAnchorList) {
                        JsonNode container = (JsonNode)tuple2._1;
                        if (!container.isArray()) continue;
                        ((ArrayNode)container).add((JsonNode)tuple2._2);
                    }
                }
                list.forEach(tuple -> {
                    String relatedCode = (String)tuple._1;
                    JsonNode jsonNode1 = (JsonNode)tuple._2;
                    JsonNode jsonNode2 = (JsonNode)tuple._3;
                    if (jsonNode1 == jsonNode2) {
                        if (jsonNode2.isObject()) {
                            Map.Entry next = (Map.Entry)jsonNode1.fields().next();
                            String[] split = ((String)next.getKey()).split("\\.");
                            String newKey = finalTargetEntityCode.concat(".").concat(split[1]);
                            ((ObjectNode)jsonNode1).removeAll();
                            ((ObjectNode)jsonNode1).set(newKey, (JsonNode)next.getValue());
                        } else {
                            log.warn("current not support non-object");
                        }
                    } else {
                        boolean field = jsonNode2.has("field");
                        if (field) {
                            JsonNode jsonNode3 = jsonNode2.get("field");
                            if (jsonNode3.isTextual()) {
                                String resultString = finalTargetEntityCode.concat(".").concat(jsonNode3.textValue().split("\\.")[1]);
                                if (jsonNode1.isObject()) {
                                    Iterator fields = jsonNode1.fields();
                                    String targetName = null;
                                    while (fields.hasNext()) {
                                        Map.Entry next = (Map.Entry)fields.next();
                                        if (next.getValue() != jsonNode2) continue;
                                        targetName = (String)next.getKey();
                                        break;
                                    }
                                    if (targetName != null) {
                                        ObjectNode objectNode1 = this.mapper.createObjectNode();
                                        objectNode1.set("field", (JsonNode)new TextNode(resultString));
                                        ((ObjectNode)jsonNode1).set(targetName, (JsonNode)objectNode1);
                                    }
                                } else if (jsonNode1.isArray()) {
                                    Iterator elements = jsonNode1.elements();
                                    int i = 0;
                                    boolean found = false;
                                    while (elements.hasNext()) {
                                        JsonNode next = (JsonNode)elements.next();
                                        if (next == jsonNode2) {
                                            found = true;
                                            break;
                                        }
                                        ++i;
                                    }
                                    if (found) {
                                        ((ArrayNode)jsonNode1).remove(i);
                                    }
                                    ((ArrayNode)jsonNode1).add((JsonNode)new TextNode(resultString));
                                }
                            } else {
                                log.warn("current not support non-textual");
                            }
                        }
                    }
                });
            }
        }
        ((ObjectNode)jsonNode).setAll(objectNode);
        query.set("query", jsonNode);
        if (needQueryInRelatedIndex) {
            return targetEntityCode;
        }
        return this.indexName;
    }

    private ObjectNode constructSelfQuery(String prefix, Map<String, Object> parentChild, Map<String, JsonNode> terms, String type) {
        ObjectNode parentBool = this.mapper.createObjectNode();
        ObjectNode boolNode = this.mapper.createObjectNode();
        ArrayNode must = this.mapper.createArrayNode();
        parentChild.entrySet().forEach(entry -> {
            ObjectNode objectNode = (ObjectNode)terms.get(entry.getKey());
            objectNode.fields().forEachRemaining(e -> {
                String rawKey = (String)e.getKey();
                JsonNode termNode = (JsonNode)e.getValue();
                ObjectNode targetNode = this.mapper.createObjectNode();
                ObjectNode targetTermsNode = this.mapper.createObjectNode();
                Iterator fields = termNode.fields();
                while (fields.hasNext()) {
                    Map.Entry next = (Map.Entry)fields.next();
                    String key = (String)next.getKey();
                    targetTermsNode.put(prefix.concat(".").concat(key), (JsonNode)next.getValue());
                }
                targetNode.set(rawKey, (JsonNode)targetTermsNode);
                must.add((JsonNode)targetNode);
            });
        });
        parentBool.put(type, (JsonNode)must);
        boolNode.put("bool", (JsonNode)parentBool);
        return boolNode;
    }

    private ObjectNode constructReplacePrefixQuery(String prefix, Map<String, Object> parentChild, Map<String, JsonNode> terms, String type) {
        ObjectNode parentBool = this.mapper.createObjectNode();
        ObjectNode boolNode = this.mapper.createObjectNode();
        ArrayNode must = this.mapper.createArrayNode();
        parentChild.entrySet().forEach(entry -> {
            ObjectNode objectNode = (ObjectNode)terms.get(entry.getKey());
            objectNode.fields().forEachRemaining(e -> {
                String rawKey = (String)e.getKey();
                JsonNode termNode = (JsonNode)e.getValue();
                ObjectNode targetNode = this.mapper.createObjectNode();
                ObjectNode targetTermsNode = this.mapper.createObjectNode();
                Iterator fields = termNode.fields();
                while (fields.hasNext()) {
                    Map.Entry next = (Map.Entry)fields.next();
                    String key = (String)next.getKey();
                    String targetName = null;
                    if (key.contains(".")) {
                        String[] split = key.split("\\.");
                        String fieldName = split[1];
                        targetName = prefix.concat(".").concat(fieldName);
                    } else {
                        targetName = !rawKey.equalsIgnoreCase("exists") ? prefix.concat(".").concat(key) : key;
                    }
                    targetTermsNode.put(targetName, (JsonNode)next.getValue());
                }
                targetNode.set(rawKey, (JsonNode)targetTermsNode);
                must.add((JsonNode)targetNode);
            });
        });
        parentBool.put(type, (JsonNode)must);
        boolNode.put("bool", (JsonNode)parentBool);
        return boolNode;
    }

    private ObjectNode constructRelatedQuery(Map<String, Object> parentChild, Map<String, JsonNode> terms, String type) {
        ObjectNode parentBool = this.mapper.createObjectNode();
        ObjectNode boolNode = this.mapper.createObjectNode();
        ArrayNode must = this.mapper.createArrayNode();
        parentChild.entrySet().forEach(entry -> {
            ObjectNode objectNode = (ObjectNode)terms.get(entry.getKey());
            objectNode.fields().forEachRemaining(e -> {
                String rawKey = (String)e.getKey();
                if (rawKey.equalsIgnoreCase("exists")) {
                    JsonNode termNode = (JsonNode)e.getValue();
                    ObjectNode targetNode = this.mapper.createObjectNode();
                    ObjectNode targetTermsNode = this.mapper.createObjectNode();
                    Iterator fields = termNode.fields();
                    while (fields.hasNext()) {
                        Map.Entry next = (Map.Entry)fields.next();
                        String value = ((JsonNode)next.getValue()).asText();
                        if (value.contains(".")) {
                            value = value.substring(value.indexOf(".") + 1);
                        }
                        targetTermsNode.put((String)next.getKey(), value);
                    }
                    targetNode.set(rawKey, (JsonNode)targetTermsNode);
                    must.add((JsonNode)targetNode);
                } else {
                    JsonNode termNode = (JsonNode)e.getValue();
                    ObjectNode targetNode = this.mapper.createObjectNode();
                    ObjectNode targetTermsNode = this.mapper.createObjectNode();
                    Iterator fields = termNode.fields();
                    while (fields.hasNext()) {
                        Map.Entry next = (Map.Entry)fields.next();
                        String key = (String)next.getKey();
                        if (key.contains(".")) {
                            key = key.substring(key.indexOf(".") + 1);
                        }
                        targetTermsNode.put(key, (JsonNode)next.getValue());
                    }
                    targetNode.set(rawKey, (JsonNode)targetTermsNode);
                    must.add((JsonNode)targetNode);
                }
            });
        });
        parentBool.put(type, (JsonNode)must);
        boolNode.put("bool", (JsonNode)parentBool);
        return boolNode;
    }

    private void parseTerms(EntityClassGroup group, Map<String, Object> selfTerms, Map<String, Object> relatedTerms, Map<String, JsonNode> terms, JsonNode term) {
        Iterator fields = term.fields();
        while (fields.hasNext()) {
            Map.Entry result = (Map.Entry)fields.next();
            JsonNode termTuple = (JsonNode)result.getValue();
            String operation = (String)result.getKey();
            Supplier termFields = () -> ((JsonNode)termTuple).fields();
            Iterator entryIterator = (Iterator)termFields.get();
            Map.Entry next = (Map.Entry)entryIterator.next();
            if ("exists".equalsIgnoreCase(operation)) {
                if (!((JsonNode)next.getValue()).asText().contains(".")) {
                    terms.put(((JsonNode)next.getValue()).asText(), term);
                    selfTerms.put(((JsonNode)next.getValue()).asText(), next.getValue());
                    continue;
                }
                terms.put(((JsonNode)next.getValue()).asText(), term);
                relatedTerms.put(((JsonNode)next.getValue()).asText(), next.getValue());
                continue;
            }
            if (!((String)next.getKey()).contains(".")) {
                terms.put((String)next.getKey(), term);
                selfTerms.put((String)next.getKey(), next.getValue());
                continue;
            }
            terms.put((String)next.getKey(), term);
            relatedTerms.put((String)next.getKey(), next.getValue());
        }
    }

    private ObjectNode constructQuery(Map<String, Object> parentChild, Map<String, JsonNode> terms, String type) {
        ObjectNode parentBool = this.mapper.createObjectNode();
        ObjectNode boolNode = this.mapper.createObjectNode();
        ArrayNode must = this.mapper.createArrayNode();
        parentChild.entrySet().forEach(entry -> must.add((JsonNode)terms.get(entry.getKey())));
        parentBool.put(type, (JsonNode)must);
        boolNode.put("bool", (JsonNode)parentBool);
        return boolNode;
    }

    private ObjectNode constructExistsCreateTimeQuery() {
        ObjectNode parentBool = this.mapper.createObjectNode();
        ObjectNode boolNode = this.mapper.createObjectNode();
        ArrayNode must = this.mapper.createArrayNode();
        ObjectNode exists = this.mapper.createObjectNode();
        exists.put("exists", (JsonNode)this.mapper.createObjectNode().put("field", "create_time"));
        must.add((JsonNode)exists);
        parentBool.put("must", (JsonNode)must);
        boolNode.put("bool", (JsonNode)parentBool);
        return boolNode;
    }

    private Enumerable<Object> aggregate(ElasticsearchTransport targetTransport, EntityClassGroup group, List<String> ops, List<Map.Entry<String, Class>> fields, List<Map.Entry<String, RelFieldCollation.Direction>> sort, List<String> groupBy, List<Map.Entry<String, String>> aggregations, Map<String, String> mapping, Map<String, String> rawMapping, Long offset, Long fetch, boolean ignoreJoin) throws IOException {
        if (null != groupBy && !groupBy.isEmpty() && offset != null) {
            String message = "Currently ES doesn't support generic pagination with aggregations. You can still use LIMIT keyword (without OFFSET). For more details see https://github.com/elastic/elasticsearch/issues/4915";
            throw new IllegalStateException(message);
        }
        ObjectNode query = this.mapper.createObjectNode();
        for (String op : ops) {
            if (this.contextService.getAll().get("join_query") != null && ((Boolean)this.contextService.getAll().get("join_query")).booleanValue()) {
                if (this.mapper.readTree(op).get("query") != null && !ignoreJoin) {
                    this.generateJoinModelQuery(group, query, op);
                    continue;
                }
                query.setAll((ObjectNode)this.mapper.readTree(op));
                continue;
            }
            query.setAll((ObjectNode)this.mapper.readTree(op));
        }
        query.put("_source", false);
        query.put("size", 0);
        query.remove("script_fields");
        query.put("stored_fields", "_none_");
        Predicate<Map.Entry> isCountStar = e -> ((String)e.getValue()).contains("\"_id\"");
        Set countAll = aggregations.stream().filter(isCountStar).map(Map.Entry::getKey).collect(Collectors.toSet());
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        LinkedHashSet<String> orderedGroupBy = new LinkedHashSet<String>();
        orderedGroupBy.addAll(sort.stream().map(Map.Entry::getKey).collect(Collectors.toList()));
        orderedGroupBy.addAll(groupBy);
        ObjectNode parent = query.with(AGGREGATIONS);
        for (String string : orderedGroupBy) {
            String aggName = "g_" + string;
            fieldMap.put(aggName, string);
            ObjectNode section = parent.with(aggName);
            ObjectNode terms = section.with("terms");
            terms.put("field", string);
            this.transport.mapping.missingValueFor(string).ifPresent(m -> terms.set("missing", m));
            if (fetch != null) {
                terms.put("size", fetch);
            }
            sort.stream().filter(e -> ((String)e.getKey()).equals(name)).findAny().ifPresent(s -> terms.with("order").put("_key", ((RelFieldCollation.Direction)s.getValue()).isDescending() ? "desc" : "asc"));
            parent = section.with(AGGREGATIONS);
        }
        if (!groupBy.isEmpty() || !aggregations.stream().allMatch(isCountStar)) {
            for (Map.Entry entry : aggregations) {
                JsonNode value = this.mapper.readTree((String)entry.getValue());
                parent.set((String)entry.getKey(), value);
            }
        }
        Consumer<JsonNode> emptyAggRemover = new Consumer<JsonNode>(){

            @Override
            public void accept(JsonNode node) {
                if (!node.has(ElasticsearchTable.AGGREGATIONS)) {
                    node.elements().forEachRemaining(this);
                    return;
                }
                JsonNode agg = node.get(ElasticsearchTable.AGGREGATIONS);
                if (agg.size() == 0) {
                    ((ObjectNode)node).remove(ElasticsearchTable.AGGREGATIONS);
                } else {
                    this.accept(agg);
                }
            }
        };
        emptyAggRemover.accept((JsonNode)query);
        if (groupBy.isEmpty() && this.version.elasticVersionMajor() >= ElasticsearchVersion.ES6.elasticVersionMajor()) {
            query.put("track_total_hits", true);
        }
        ElasticsearchJson.Result result = targetTransport.search(Collections.emptyMap()).apply(query);
        ArrayList result2 = new ArrayList();
        if (result.aggregations() != null) {
            ElasticsearchJson.visitValueNodes(result.aggregations(), m -> {
                LinkedHashMap newMap = new LinkedHashMap();
                for (String key : m.keySet()) {
                    newMap.put(fieldMap.getOrDefault(key, key), m.get(key));
                }
                result2.add(newMap);
            });
        } else {
            result2.add(new LinkedHashMap());
        }
        long total = result.searchHits().total().value();
        this.contextService.getAll().put("show_count", total);
        if (groupBy.isEmpty()) {
            for (String expr : countAll) {
                result2.forEach(m -> m.put(expr, total));
            }
        }
        Function1<ElasticsearchJson.SearchHit, Object> getter = ElasticsearchEnumerators.getter(fields, rawMapping, (Map<String, String>)ImmutableMap.copyOf(mapping));
        ElasticsearchJson.SearchHits hits = new ElasticsearchJson.SearchHits(result.searchHits().total(), result2.stream().map(r -> new ElasticsearchJson.SearchHit("_id", (Map<String, Object>)r, null, null)).collect(Collectors.toList()));
        return Linq4j.asEnumerable(hits.hits()).select(getter);
    }

    private RelDataType fieldTypeToRelDataType(RelDataTypeFactory relDataTypeFactory, Class type) {
        return relDataTypeFactory.createJavaType(type);
    }

    public RelDataType getRowType(RelDataTypeFactory relDataTypeFactory) {
        String profile = this.fetcher.getProfile(this.contextService.getAll());
        Optional targetClass = this.engine.loadByCode(this.entityCode, profile);
        IEntityClass iEntityClass = (IEntityClass)targetClass.get();
        EntityClassGroup describe = this.engine.describe((IEntityClass)targetClass.get(), profile);
        Collection allFields = describe.getAllFields();
        List names = allFields.stream().map(x -> Pair.of((Object)x.name().replace(".", "_"), (Object)this.fieldTypeToRelDataType(relDataTypeFactory, x.type().getJavaType()))).collect(Collectors.toList());
        allFields.stream().forEach(x -> {
            if (x.type() == FieldType.STRINGS) {
                names.add(Pair.of((Object)x.name().replace(".", "_").concat("@raw"), (Object)this.fieldTypeToRelDataType(relDataTypeFactory, x.type().getJavaType())));
            }
        });
        HashMap relationSet = new HashMap();
        for (IRelation iRelation : iEntityClass.relations()) {
            Optional iRelationEntityClassGroup = this.engine.load(String.valueOf(iRelation.getEntityClassId()), profile);
            IEntityClass iRelationEntityClass = (IEntityClass)iRelationEntityClassGroup.get();
            Collection relationAllFields = this.engine.describe(iRelationEntityClass, profile).getAllFields();
            List relationNames = relationAllFields.stream().map(x -> Pair.of((Object)iRelation.getName().concat(".").concat(x.name().replace(".", "_")), (Object)this.fieldTypeToRelDataType(relDataTypeFactory, x.type().getJavaType()))).collect(Collectors.toList());
            relationAllFields.stream().forEach(x -> {
                if (x.type() == FieldType.STRINGS) {
                    relationNames.add(Pair.of((Object)iRelation.getName().concat(".").concat(x.name()).replace(".", "_").concat("@raw"), (Object)this.fieldTypeToRelDataType(relDataTypeFactory, x.type().getJavaType())));
                }
            });
            relationSet.put(iRelationEntityClass.code(), relationNames);
        }
        for (List relationValue : relationSet.values()) {
            names.addAll(relationValue);
        }
        RelDataType structType = relDataTypeFactory.createStructType(names);
        return structType;
    }

    public String toString() {
        return "ElasticsearchTable{" + this.indexName + "}";
    }

    public <T> Queryable<T> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
        return new ElasticsearchQueryable(queryProvider, schema, this, tableName);
    }

    public RelNode toRel(RelOptTable.ToRelContext context, RelOptTable relOptTable) {
        RelOptCluster cluster = context.getCluster();
        return new ElasticsearchTableScan(cluster, cluster.traitSetOf((RelTrait)ElasticsearchRel.CONVENTION), relOptTable, this, null);
    }

    public static class ElasticsearchQueryable<T>
    extends AbstractTableQueryable<T> {
        ElasticsearchQueryable(QueryProvider queryProvider, SchemaPlus schema, ElasticsearchTable table, String tableName) {
            super(queryProvider, schema, (QueryableTable)table, tableName);
        }

        public Enumerator<T> enumerator() {
            return null;
        }

        private ElasticsearchTable getTable() {
            return (ElasticsearchTable)this.table;
        }

        public Enumerable<Object> find(List<String> ops, List<Map.Entry<String, Class>> fields, List<Map.Entry<String, RelFieldCollation.Direction>> sort, List<String> groupBy, List<Map.Entry<String, String>> aggregations, Map<String, String> mappings, Map<String, String> rawMapping, Long offset, Long fetch, RelNode rawTree, DataContext dataContext) {
            try {
                long currentTimeMillis = System.currentTimeMillis();
                System.out.println("Come into ElasticSearch Table " + currentTimeMillis);
                Enumerable<Object> objects = this.getTable().find(ops, fields, sort, groupBy, aggregations, mappings, rawMapping, offset, fetch, rawTree, dataContext);
                System.out.println("Query cost is " + (System.currentTimeMillis() - currentTimeMillis));
                return objects;
            }
            catch (Throwable e) {
                throw new RuntimeException("Failed to query " + this.getTable().indexName, e);
            }
        }
    }
}

