/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.adapter.elasticsearch;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractSequentialIterator;
import com.google.common.collect.Iterators;
import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.ultraman.adapter.elasticsearch.ElasticsearchJson;
import com.xforceplus.ultraman.adapter.elasticsearch.ElasticsearchTransport;
import com.xforceplus.ultraman.metadata.engine.EntityClassGroup;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Consumer;

class Scrolling {
    private final ElasticsearchTransport transport;
    private final int fetchSize;
    private ContextService contextService;
    private EntityClassGroup group;

    Scrolling(ElasticsearchTransport transport, EntityClassGroup group, ContextService contextService) {
        this.transport = Objects.requireNonNull(transport, "transport");
        int fetchSize = transport.fetchSize;
        Preconditions.checkArgument((fetchSize > 0 ? 1 : 0) != 0, (String)"invalid fetch size. Expected %s > 0", (int)fetchSize);
        this.fetchSize = fetchSize;
        this.contextService = contextService;
        this.group = group;
    }

    Iterator<ElasticsearchJson.SearchHit> query(boolean useSelf, ObjectNode query) {
        ElasticsearchJson.SearchTotal total;
        long limit;
        Objects.requireNonNull(query, "query");
        if (query.has("size")) {
            limit = query.get("size").asLong();
            if ((long)this.fetchSize > limit) {
                ElasticsearchJson.SearchHits searchHits = this.transport.search().apply(query).searchHits();
                ElasticsearchJson.SearchTotal total2 = searchHits.total();
                if (total2 != null && this.contextService.getAll().get("show_count") == null) {
                    long value = searchHits.total().value();
                    this.contextService.getAll().put("show_count", value);
                }
                return searchHits.flattenHits(useSelf, this.group).iterator();
            }
        } else {
            limit = Long.MAX_VALUE;
        }
        query.put("size", this.fetchSize);
        ElasticsearchJson.Result first = this.transport.search(Collections.singletonMap("scroll", "1m")).apply(query);
        ElasticsearchJson.SearchHits searchHits = first.searchHits();
        if (searchHits != null && (total = searchHits.total()) != null && this.contextService.getAll().get("show_count") == null) {
            this.contextService.getAll().put("show_count", total.value());
        }
        AutoClosingIterator iterator = new AutoClosingIterator((Iterator)((Object)new SequentialIterator(first, this.transport, limit)), scrollId -> this.transport.closeScroll(Collections.singleton(scrollId)));
        Iterator result = this.flatten(iterator, useSelf);
        if (limit != Long.MAX_VALUE) {
            result = Iterators.limit(result, (int)((int)limit));
        }
        return result;
    }

    private Iterator<ElasticsearchJson.SearchHit> flatten(Iterator<ElasticsearchJson.Result> results, boolean useSelf) {
        Iterator inputs = Iterators.transform(results, input -> input.searchHits().flattenHits(useSelf, this.group).iterator());
        return Iterators.concat((Iterator)inputs);
    }

    private static class SequentialIterator
    extends AbstractSequentialIterator<ElasticsearchJson.Result> {
        private final ElasticsearchTransport transport;
        private final long limit;
        private long count;

        private SequentialIterator(ElasticsearchJson.Result first, ElasticsearchTransport transport, long limit) {
            super((Object)first);
            this.transport = transport;
            Preconditions.checkArgument((limit >= 0L ? 1 : 0) != 0, (String)"limit: %s >= 0", (long)limit);
            this.limit = limit;
        }

        protected ElasticsearchJson.Result computeNext(ElasticsearchJson.Result previous) {
            int hits = previous.searchHits().hits().size();
            if (hits == 0 || this.count >= this.limit) {
                return null;
            }
            this.count += (long)hits;
            String scrollId = previous.scrollId().orElseThrow(() -> new IllegalStateException("scrollId has to be present"));
            return this.transport.scroll().apply(scrollId);
        }
    }

    private static class AutoClosingIterator
    implements Iterator<ElasticsearchJson.Result>,
    AutoCloseable {
        private final Iterator<ElasticsearchJson.Result> delegate;
        private final Consumer<String> closer;
        private boolean closed;
        private String scrollId;

        private AutoClosingIterator(Iterator<ElasticsearchJson.Result> delegate, Consumer<String> closer) {
            this.delegate = delegate;
            this.closer = closer;
        }

        @Override
        public void close() {
            if (!this.closed && this.scrollId != null) {
                this.closer.accept(this.scrollId);
            }
            this.closed = true;
        }

        @Override
        public boolean hasNext() {
            boolean hasNext = this.delegate.hasNext();
            if (!hasNext) {
                this.close();
            }
            return hasNext;
        }

        @Override
        public ElasticsearchJson.Result next() {
            ElasticsearchJson.Result next = this.delegate.next();
            next.scrollId().ifPresent(id -> {
                this.scrollId = id;
            });
            return next;
        }
    }
}

