/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.adapter.elasticsearch.config;

import com.xforceplus.metadata.schema.runtime.MetadataEngine;
import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.ultraman.adapter.elasticsearch.CustomElasticSearchTransport;
import com.xforceplus.ultraman.adapter.elasticsearch.ElasticsearchSchemaFactory;
import com.xforceplus.ultraman.adapter.elasticsearch.config.BocpElasticsearchConfiguration;
import com.xforceplus.ultraman.adapter.elasticsearch.listener.ElasticIndexConfigUpload;
import com.xforceplus.ultraman.adapter.elasticsearch.listener.ElasticSearchSdkMetadataListener;
import com.xforceplus.ultraman.adapter.elasticsearch.query.ElasticSearchQueryProvider;
import com.xforceplus.ultraman.adapter.elasticsearch.service.IndexOperation;
import com.xforceplus.ultraman.adapter.elasticsearch.service.ManageBocpMetadataService;
import com.xforceplus.ultraman.adapter.elasticsearch.service.adatper.CompleteOqsEntity;
import com.xforceplus.ultraman.adapter.elasticsearch.service.adatper.MultiValueRawExtend;
import com.xforceplus.ultraman.adapter.elasticsearch.service.adatper.ToOneRelatedCallback;
import com.xforceplus.ultraman.adapter.elasticsearch.service.impl.ElasticSearchIndexImpl;
import com.xforceplus.ultraman.adapter.elasticsearch.service.impl.ElasticSearchServiceImpl;
import com.xforceplus.ultraman.adapter.elasticsearch.service.impl.ManageBocpMetadataServiceImpl;
import com.xforceplus.ultraman.adapter.elasticsearch.strategy.ESQueryStrategy;
import com.xforceplus.ultraman.adapter.elasticsearch.strategy.ESQueryWaitForStrategy;
import com.xforceplus.ultraman.adapter.elasticsearch.transport.ElasticIndexResolver;
import com.xforceplus.ultraman.adapter.elasticsearch.transport.ElasticsearchTransportExecutor;
import com.xforceplus.ultraman.cdc.adapter.CDCBeforeCallback;
import com.xforceplus.ultraman.cdc.adapter.CDCFilter;
import com.xforceplus.ultraman.cdc.adapter.EngineAdapterService;
import com.xforceplus.ultraman.cdc.adapter.IndexUpsertBeforeCallBack;
import com.xforceplus.ultraman.cdc.adapter.impl.TypeBasedCDCFilter;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.sdk.core.calcite.oqs.DataQueryProvider;
import com.xforceplus.ultraman.sdk.core.calcite.oqs.strategy.QueryProviderSelectStrategy;
import com.xforceplus.ultraman.sdk.core.calcite.oqs.strategy.QueryStrategy;
import com.xforceplus.ultraman.sdk.core.calcite.proxy.ProxyConnection;
import com.xforceplus.ultraman.sdk.core.config.CdcConfig;
import com.xforceplus.ultraman.sdk.core.config.ExecutionConfig;
import com.xforceplus.ultraman.sdk.core.datasource.DataSourceFactory;
import com.xforceplus.ultraman.sdk.core.datasource.DataSourcePackage;
import com.xforceplus.ultraman.sdk.core.datasource.route.TransportExecutor;
import com.xforceplus.ultraman.sdk.core.datasource.route.dynamic.DynamicRouteMappingProvider;
import com.xforceplus.ultraman.sdk.core.datasource.route.dynamic.RouteMappingProvider;
import com.xforceplus.ultraman.sdk.core.datasource.route.dynamic.config.DynamicConfig;
import com.xforceplus.ultraman.sdk.core.datasource.route.index.IndexConfig;
import com.xforceplus.ultraman.sdk.core.facade.ProfileFetcher;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Collections;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.apache.calcite.avatica.AvaticaFactory;
import org.apache.calcite.avatica.UnregisteredDriver;
import org.apache.calcite.jdbc.CalciteJdbc41Factory;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.jdbc.Driver;
import org.apache.calcite.schema.Schema;
import org.elasticsearch.client.RestHighLevelClient;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.env.Environment;

@AutoConfigureBefore(name={"com.xforceplus.ultraman.starter.autoconfigure.EventConfiguration"})
@ConditionalOnProperty(value={"xplat.elasticsearch.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={BocpElasticsearchConfiguration.class})
public class UltramanESAutoConfiguration {
    @Lazy
    @Bean
    public DataQueryProvider elasticSearchQueryProvider(RestHighLevelClient restHighLevelClient, MetadataEngine metadataEngine, EntityClassEngine engine, ContextService contextService, ProfileFetcher fetcher) throws SQLException, IllegalAccessException {
        return new ElasticSearchQueryProvider();
    }

    @Bean
    public CDCFilter typeBasedFilter(EntityClassEngine engine, CdcConfig cdcConfig) {
        return new TypeBasedCDCFilter(engine, cdcConfig);
    }

    @ConditionalOnMissingBean(value={TransportExecutor.class})
    @Bean
    public TransportExecutor transportExecutor(DynamicConfig dynamicConfig, Environment env) {
        ElasticIndexResolver resolver = new ElasticIndexResolver();
        DataSourcePackage dataSourcePackage = DataSourceFactory.build((boolean)false, (boolean)false, Collections.singletonList(resolver), (String[])env.getActiveProfiles());
        DynamicRouteMappingProvider routeMappingProvider = new DynamicRouteMappingProvider(dynamicConfig.getIndexRouting());
        return new ElasticsearchTransportExecutor(dataSourcePackage, (RouteMappingProvider)routeMappingProvider);
    }

    @Bean
    public ElasticSearchSdkMetadataListener esListener() {
        ElasticSearchSdkMetadataListener sdkMetadataListener = new ElasticSearchSdkMetadataListener();
        return sdkMetadataListener;
    }

    @Bean(value={"elasticIndexConfigUpload"})
    public ElasticIndexConfigUpload getIndexStats() {
        return new ElasticIndexConfigUpload();
    }

    @Bean
    public CustomElasticSearchTransport customElasticSearchTransport(DynamicConfig dynamicConfig, TransportExecutor elasticsearchTransportExecutor) {
        return new CustomElasticSearchTransport(dynamicConfig, elasticsearchTransportExecutor);
    }

    @Bean
    public ManageBocpMetadataService manageBocpMetadataService() {
        return new ManageBocpMetadataServiceImpl();
    }

    @Bean
    public EngineAdapterService adapterService(IndexConfig indexConfig) {
        return new ElasticSearchServiceImpl(indexConfig.getShards(), indexConfig.getReplicas(), indexConfig.getThreadHandleBatch(), indexConfig.getRetryOnConflict());
    }

    @Bean
    public IndexOperation indexService(IndexConfig indexConfig) {
        return new ElasticSearchIndexImpl(indexConfig.getShards(), indexConfig.getReplicas(), indexConfig.getThreadHandleBatch(), indexConfig.getRetryOnConflict());
    }

    @Lazy
    @Bean(value={"elasticSearchDS"})
    public DataSource esConnection(TransportExecutor transportExecutor, MetadataEngine metadataEngine, EntityClassEngine engine, ContextService contextService, ProfileFetcher fetcher, ExecutionConfig executionConfig, DynamicConfig dynamicConfig, ManageBocpMetadataService manageBocpMetadataService) throws SQLException {
        CalciteSchema rootSchema = CalciteSchema.createRootSchema((boolean)true, (boolean)true);
        final ElasticsearchSchemaFactory factory = new ElasticsearchSchemaFactory(metadataEngine, engine, contextService, transportExecutor, fetcher, manageBocpMetadataService);
        Schema schema = factory.create(rootSchema.plus(), "", Collections.emptyMap());
        rootSchema.add("", schema);
        final CalciteJdbc41Factory calciteJdbc41Factory = new CalciteJdbc41Factory();
        final Properties info = new Properties();
        info.setProperty("caseSensitive", "false");
        info.setProperty("lex", "java");
        info.setProperty("conformance", "MYSQL_5");
        HikariConfig config = new HikariConfig();
        config.setDataSource(new DataSource(){

            @Override
            public Connection getConnection() {
                CalciteSchema rootSchema = CalciteSchema.createRootSchema((boolean)true, (boolean)true);
                Schema schema = factory.create(rootSchema.plus(), "", Collections.emptyMap());
                rootSchema.add("", schema);
                CalciteJdbc41Factory.CalciteJdbc41Connection connection = calciteJdbc41Factory.newConnection((UnregisteredDriver)new Driver(), (AvaticaFactory)calciteJdbc41Factory, "jdbc:calcite:", info, rootSchema, null);
                return new ProxyConnection((Connection)connection);
            }

            @Override
            public Connection getConnection(String username, String password) throws SQLException {
                return this.getConnection();
            }

            @Override
            public <T> T unwrap(Class<T> iface) throws SQLException {
                return null;
            }

            @Override
            public boolean isWrapperFor(Class<?> iface) throws SQLException {
                return false;
            }

            @Override
            public PrintWriter getLogWriter() throws SQLException {
                return null;
            }

            @Override
            public void setLogWriter(PrintWriter out) throws SQLException {
            }

            @Override
            public int getLoginTimeout() throws SQLException {
                return 0;
            }

            @Override
            public void setLoginTimeout(int seconds) throws SQLException {
            }

            @Override
            public Logger getParentLogger() throws SQLFeatureNotSupportedException {
                return null;
            }
        });
        config.setMaximumPoolSize(executionConfig.getMaxConnection());
        HikariDataSource dataSource = new HikariDataSource(config);
        return dataSource;
    }

    @Bean
    public IndexUpsertBeforeCallBack indexUpsertBeforeCallBack() {
        return new MultiValueRawExtend();
    }

    @Lazy
    @Bean
    public CDCBeforeCallback toOneRelated() {
        return new ToOneRelatedCallback();
    }

    @Lazy
    @Bean
    public CDCBeforeCallback complete() {
        return new CompleteOqsEntity();
    }

    @Bean
    public QueryProviderSelectStrategy pageSelectStrategy(ContextService contextService, EntityClassEngine engine, CdcConfig cdcConfig) {
        return new ESQueryStrategy(contextService, engine, cdcConfig);
    }

    @Bean
    public QueryStrategy waitForQueryStrategy(ContextService contextService) {
        return new ESQueryWaitForStrategy(contextService);
    }
}

