/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.adapter.elasticsearch.listener;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.xforceplus.ultraman.adapter.elasticsearch.CustomElasticSearchTransport;
import com.xforceplus.ultraman.adapter.elasticsearch.query.po.BocpElasticConfigPo;
import com.xforceplus.ultraman.adapter.elasticsearch.service.IndexOperation;
import com.xforceplus.ultraman.adapter.elasticsearch.service.ManageBocpMetadataService;
import com.xforceplus.ultraman.adapter.elasticsearch.service.utils.BocpMetabaseCacheUtils;
import com.xforceplus.ultraman.extensions.reporter.callback.NodeReporterBeforeSendCallback;
import com.xforceplus.ultraman.extensions.reporter.domain.NodeExtInfoDTO;
import com.xforceplus.ultraman.extensions.reporter.domain.NodeInfoDTO;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ElasticIndexConfigUpload
implements NodeReporterBeforeSendCallback {
    private static final Logger log = LoggerFactory.getLogger(ElasticIndexConfigUpload.class);
    @Autowired
    private IndexOperation engineAdapterService;
    @Autowired
    public EntityClassEngine entityClassEngine;
    @Autowired
    private CustomElasticSearchTransport customElasticSearchTransport;
    @Autowired
    private ManageBocpMetadataService manageBocpMetadataService;

    public void modify(NodeInfoDTO nodeInfoDTO) {
        ArrayList errors = new ArrayList();
        List<String> bocpConfigAllKey = BocpMetabaseCacheUtils.getBocpConfigAllKey();
        HashMap extInfos = new HashMap();
        if (nodeInfoDTO.getExtInfo() == null) {
            nodeInfoDTO.setExtInfo(extInfos);
        }
        bocpConfigAllKey.forEach(bocpConfigKey -> {
            Map<Long, BocpElasticConfigPo> bocpConfig = BocpMetabaseCacheUtils.getExactlyBocpConfig(bocpConfigKey);
            bocpConfig.values().forEach(bocpElasticConfigPo -> {
                IEntityClass iEntityClass = (IEntityClass)this.entityClassEngine.load(String.valueOf(bocpElasticConfigPo.getEntityClassId()), bocpConfigKey).get();
                try {
                    List<String> entityClassMappingIndexs = this.manageBocpMetadataService.getEntityClassMappingIndexs((String)bocpConfigKey, iEntityClass);
                    ArrayList nodeExtInfoDTOS = new ArrayList();
                    entityClassMappingIndexs.forEach(indexName -> {
                        if (this.engineAdapterService.indexExists((String)indexName, (String)bocpConfigKey)) {
                            JSONObject indexStats = this.customElasticSearchTransport.getIndexStats((String)indexName, (String)bocpConfigKey);
                            NodeExtInfoDTO nodeExtInfoDTO = new NodeExtInfoDTO();
                            nodeExtInfoDTO.setEntityClassId(bocpElasticConfigPo.getEntityClassId());
                            nodeExtInfoDTO.setIndexName(indexName);
                            nodeExtInfoDTO.setEntityClassCode(bocpElasticConfigPo.getEntityClassCode().toLowerCase());
                            nodeExtInfoDTO.setIndexStats(indexStats.toJSONString(new JSONWriter.Feature[0]));
                            nodeExtInfoDTOS.add(nodeExtInfoDTO);
                        }
                    });
                    if (nodeExtInfoDTOS.size() >= 1) {
                        extInfos.put(bocpElasticConfigPo.getEntityClassId(), nodeExtInfoDTOS);
                    }
                }
                catch (Throwable e) {
                    this.logInfo(false, iEntityClass, errors, e.getMessage());
                }
            });
            if (!errors.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                errors.stream().forEach(x -> {
                    String entityCode = (String)x._1;
                    String reason = (String)x._2;
                    sb.append(entityCode).append(":").append(reason).append("|").append(System.lineSeparator());
                });
                log.error("FATAL --- get elasticsearch index stats infos failure. {}{}", (Object)System.lineSeparator(), (Object)sb);
            }
        });
    }

    private void logInfo(boolean status, IEntityClass iEntityClass, List<Tuple2<String, String>> errors, String message) {
        if (!status) {
            errors.add((Tuple2<String, String>)Tuple.of((Object)iEntityClass.code(), (Object)Optional.ofNullable(message).orElse("NullPoint Exception")));
        }
    }
}

