/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.adapter.elasticsearch.listener;

import com.xforceplus.ultraman.adapter.elasticsearch.config.BocpElasticsearchConfiguration;
import com.xforceplus.ultraman.adapter.elasticsearch.query.dto.ElasticTenantProfile;
import com.xforceplus.ultraman.adapter.elasticsearch.query.po.BocpElasticConfigPo;
import com.xforceplus.ultraman.adapter.elasticsearch.service.ManageBocpMetadataService;
import com.xforceplus.ultraman.adapter.elasticsearch.service.constant.SegmentFieldType;
import com.xforceplus.ultraman.adapter.elasticsearch.service.impl.ManageBocpMetadataServiceImpl;
import com.xforceplus.ultraman.adapter.elasticsearch.service.utils.BocpMetabaseCacheUtils;
import com.xforceplus.ultraman.adapter.elasticsearch.utils.ParseBocpJsonUtils;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.sdk.core.config.CdcConfig;
import com.xforceplus.ultraman.sdk.core.pipeline.operation.validator.dynamic.DynamicRegexChecked;
import com.xforceplus.ultraman.sdk.core.pipeline.operation.validator.dynamic.DynamicRegexCheckedConfig;
import com.xforceplus.ultraman.sdk.core.pipeline.operation.validator.dynamic.DynamicRequired;
import com.xforceplus.ultraman.sdk.core.pipeline.operation.validator.dynamic.DynamicRequiredConfig;
import com.xforceplus.ultraman.transfer.common.event.SDKMetadataEvent;
import io.vavr.Tuple2;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;

public class ElasticSearchSdkMetadataListener {
    private static final Logger log = LoggerFactory.getLogger(ElasticSearchSdkMetadataListener.class);
    @Autowired
    private ManageBocpMetadataService manageBocpMetadataService;
    @Autowired(required=false)
    private BocpElasticsearchConfiguration bocpElasticsearchConfiguration;
    @Autowired
    public EntityClassEngine entityClassEngine;
    @Autowired(required=false)
    DynamicRequiredConfig dynamicRequiredConfig;
    @Autowired(required=false)
    DynamicRegexCheckedConfig dynamicRegexCheckedConfig;
    @Autowired
    private CdcConfig cdcConfig;

    public void setManageBocpMetadataService(ManageBocpMetadataService manageBocpMetadataService) {
        this.manageBocpMetadataService = manageBocpMetadataService;
    }

    @EventListener(value={SDKMetadataEvent.class})
    public void onApplicationEvent(SDKMetadataEvent payload) {
        if (payload instanceof SDKMetadataEvent) {
            List sdkSettings = payload.getSdkSettings();
            AtomicBoolean isParsedFromBocp = new AtomicBoolean(false);
            sdkSettings.forEach(sdkSetting -> {
                if (StringUtils.equalsIgnoreCase((CharSequence)sdkSetting.getType(), (CharSequence)"sdk20")) {
                    this.cdcConfig.setInclude(new ArrayList(this.cdcConfig.getInclude()));
                    this.cdcConfig.setExclude(Collections.emptyList());
                    BocpElasticsearchConfiguration bocpElasticConfig = ParseBocpJsonUtils.parseBocpJson(sdkSetting.getSetting());
                    this.parseBocpConfig(bocpElasticConfig, this.cdcConfig);
                    this.prepareExtraConfig();
                    isParsedFromBocp.set(true);
                }
            });
            if (!isParsedFromBocp.get() && this.bocpElasticsearchConfiguration != null) {
                this.parseBocpConfig(this.bocpElasticsearchConfiguration, this.cdcConfig);
            }
            this.manageBocpMetadataService.setLoadFinish(true);
        }
    }

    private void parseBocpConfig(BocpElasticsearchConfiguration bocpElasticsearchConfiguration, CdcConfig cdcConfig) {
        ArrayList<Tuple2<String, String>> errors = new ArrayList<Tuple2<String, String>>();
        bocpElasticsearchConfiguration.getBocpElasticConfigs().forEach(bocpElasticConfig -> {
            long entityClassId;
            IEntityClass iEntityClass;
            if (bocpElasticConfig.isEnableSync() && (iEntityClass = (IEntityClass)this.entityClassEngine.load(String.valueOf(entityClassId = bocpElasticConfig.getEntityClassId()), "default").get()) != null) {
                List<ElasticTenantProfile> selfSegmentRule;
                cdcConfig.getInclude().add(iEntityClass.code());
                if (bocpElasticConfig.getSelfSegmentRule() == null) {
                    selfSegmentRule = Collections.EMPTY_LIST;
                } else {
                    bocpElasticConfig.getSelfSegmentRule().setTenantCode("default");
                    selfSegmentRule = Collections.singletonList(bocpElasticConfig.getSelfSegmentRule());
                }
                this.manageBocpMetadataService.updateMetadataCache(selfSegmentRule, iEntityClass, errors);
                if (bocpElasticConfig.getElasticTenantProfiles() != null) {
                    List<ElasticTenantProfile> enableSegmentTenantProfiles = bocpElasticConfig.getElasticTenantProfiles().stream().filter(tenantProfile -> !tenantProfile.isEnableSegment()).collect(Collectors.toList());
                    this.updateMetadataCache(errors, iEntityClass, enableSegmentTenantProfiles);
                    enableSegmentTenantProfiles = bocpElasticConfig.getElasticTenantProfiles().stream().filter(tenantProfile -> tenantProfile.isEnableSegment()).collect(Collectors.toList());
                    this.updateMetadataCache(errors, iEntityClass, enableSegmentTenantProfiles);
                }
            }
        });
        ((ManageBocpMetadataServiceImpl)this.manageBocpMetadataService).printErrors(errors);
    }

    private void prepareExtraConfig() {
        BocpMetabaseCacheUtils.getBocpConfigAllKey().forEach(k -> {
            Map<Long, BocpElasticConfigPo> bocpConfig = BocpMetabaseCacheUtils.getBocpConfig(k);
            if (bocpConfig != null) {
                bocpConfig.forEach((key, value) -> {
                    String tenantCode = value.getTenantCode();
                    if (StringUtils.isEmpty((CharSequence)tenantCode)) {
                        tenantCode = "default";
                    }
                    if (value.isEnableSegment()) {
                        String entityClassCode = value.getEntityClassCode();
                        String segmentFieldName = value.getSegmentFieldName();
                        if (this.dynamicRequiredConfig != null) {
                            ((DynamicRequired)this.dynamicRequiredConfig.buildTenant(tenantCode, DynamicRequired::new)).addRequired(entityClassCode, segmentFieldName);
                        }
                        if (this.dynamicRegexCheckedConfig != null && !StringUtils.isEmpty((CharSequence)value.getSegmentDateFormat()) && value.getSegmentFieldType() == SegmentFieldType.STRING) {
                            ((DynamicRegexChecked)this.dynamicRegexCheckedConfig.buildTenant(tenantCode, DynamicRegexChecked::new)).addRegexChecked(entityClassCode, segmentFieldName, value.getSegmentDateFormat());
                        }
                    }
                });
            }
        });
    }

    private void updateMetadataCache(List<Tuple2<String, String>> errors, IEntityClass iEntityClass, List<ElasticTenantProfile> enableSegmentTenantProfiles) {
        if (enableSegmentTenantProfiles.size() >= 1) {
            this.manageBocpMetadataService.updateMetadataCache(enableSegmentTenantProfiles, iEntityClass, errors);
        }
    }
}

