/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.adapter.elasticsearch.mock;

import com.xforceplus.ultraman.sdk.infra.lifecycle.BeanInitialization;
import com.xforceplus.ultraman.sdk.infra.utils.InitializationHelper;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpHost;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestHighLevelClient;

public class ElasticSearchInitialization
implements BeanInitialization {
    private static volatile ElasticSearchInitialization instance = null;
    private RestHighLevelClient restHighLevelClient;
    private ExecutorService runner;

    private ElasticSearchInitialization() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ElasticSearchInitialization getInstance() throws IllegalAccessException {
        if (null != instance) return instance;
        Class<ElasticSearchInitialization> clazz = ElasticSearchInitialization.class;
        synchronized (ElasticSearchInitialization.class) {
            if (null != instance) return instance;
            instance = new ElasticSearchInitialization();
            instance.init();
            InitializationHelper.add((BeanInitialization)instance);
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void init() throws IllegalAccessException {
        this.runner = new ThreadPoolExecutor(1, 10, 0L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(1024));
    }

    public void clear() throws Exception {
        try {
            if (null != this.restHighLevelClient) {
                this.restHighLevelClient.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void destroy() {
        if (null != this.restHighLevelClient) {
            try {
                this.restHighLevelClient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.restHighLevelClient = null;
        }
        this.runner.shutdown();
        this.runner = null;
        instance = null;
    }

    public synchronized RestHighLevelClient getRestHighLevelClient() {
        if (null == this.restHighLevelClient) {
            this.restHighLevelClient = new RestHighLevelClient(RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost("172.25.8.77", 9200, "http")}).setHttpClientConfigCallback(httpClientBuilder -> {
                httpClientBuilder.disableAuthCaching();
                return httpClientBuilder;
            }));
            return this.restHighLevelClient;
        }
        return this.restHighLevelClient;
    }

    public ExecutorService getRunner() {
        return this.runner;
    }
}

