/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.adapter.elasticsearch.query;

import com.xforceplus.ultraman.adapter.elasticsearch.query.exception.ElasticSqlValidatorException;
import java.util.Stack;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.TableFunctionScan;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.calcite.rel.logical.LogicalCalc;
import org.apache.calcite.rel.logical.LogicalCorrelate;
import org.apache.calcite.rel.logical.LogicalExchange;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalIntersect;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.logical.LogicalMatch;
import org.apache.calcite.rel.logical.LogicalMinus;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.logical.LogicalSort;
import org.apache.calcite.rel.logical.LogicalTableModify;
import org.apache.calcite.rel.logical.LogicalUnion;
import org.apache.calcite.rel.logical.LogicalValues;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticCustomShuttle
implements RelShuttle {
    private static final Logger log = LoggerFactory.getLogger(ElasticCustomShuttle.class);
    private boolean joinQuery = false;
    private int joinUpperLimit = 2;
    private Stack<String> termStack = new Stack();

    public RelNode visit(@NotNull TableScan scan) {
        if (this.currentStackHas("OqsengineJoin") && this.termStack.size() > this.joinUpperLimit) {
            log.error("elasticsearch is not supported More than three join queries.");
            throw new ElasticSqlValidatorException("elasticsearch is not supported More than three join queries,please\nModify the SQL or Select other the query engine");
        }
        return scan;
    }

    public RelNode visit(TableFunctionScan scan) {
        return null;
    }

    public RelNode visit(LogicalValues values) {
        return null;
    }

    public RelNode visit(LogicalFilter filter) {
        return null;
    }

    public RelNode visit(LogicalCalc calc) {
        return null;
    }

    public RelNode visit(LogicalProject project) {
        return null;
    }

    public RelNode visit(LogicalJoin join) {
        return null;
    }

    public RelNode visit(LogicalCorrelate correlate) {
        return null;
    }

    public RelNode visit(LogicalUnion union) {
        return null;
    }

    public RelNode visit(LogicalIntersect intersect) {
        return null;
    }

    public RelNode visit(LogicalMinus minus) {
        return null;
    }

    public RelNode visit(LogicalAggregate aggregate) {
        return null;
    }

    public RelNode visit(LogicalMatch match) {
        return null;
    }

    public RelNode visit(LogicalSort sort) {
        return null;
    }

    public RelNode visit(LogicalExchange exchange) {
        return null;
    }

    public RelNode visit(LogicalTableModify modify) {
        return null;
    }

    private boolean currentStackHas(String term) {
        int termSearch = this.termStack.search(term);
        return termSearch > 0;
    }

    public RelNode visit(RelNode other) {
        if (other instanceof Join) {
            this.termStack.push(other.getRelTypeName());
        }
        other.getInputs().forEach(x -> x.accept((RelShuttle)this));
        return null;
    }

    public boolean getJoinsCounter() {
        return this.termStack.size() >= 1;
    }
}

