/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.adapter.elasticsearch.query;

import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.ultraman.adapter.elasticsearch.query.ElasticCustomShuttle;
import com.xforceplus.ultraman.adapter.elasticsearch.query.utils.ElasticSearchSqlConverter;
import com.xforceplus.ultraman.adapter.elasticsearch.query.utils.ParseSqlNodeUtils;
import com.xforceplus.ultraman.adapter.elasticsearch.service.ManageBocpMetadataService;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.plus.storage.pojo.dto.select.SelectConfig;
import com.xforceplus.ultraman.sdk.core.calcite.oqs.DataQueryProvider;
import com.xforceplus.ultraman.sdk.core.config.ExecutionConfig;
import com.xforceplus.ultraman.sdk.core.utils.MasterStorageHelper;
import io.micrometer.core.annotation.Timed;
import io.vavr.Tuple2;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.calcite.DataContext;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.StructKind;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;

public class ElasticSearchQueryProvider
implements DataQueryProvider {
    private static final Logger log = LoggerFactory.getLogger(ElasticSearchQueryProvider.class);
    @Lazy
    @Qualifier(value="elasticSearchDS")
    @Autowired
    private DataSource esDataSource;
    @Autowired
    private ContextService contextService;
    @Autowired
    private EntityClassEngine engine;
    @Lazy
    @Autowired
    private ExecutionConfig executionConfig;
    @Autowired
    private ManageBocpMetadataService manageBocpMetadataService;

    public void setEsDataSource(DataSource esDataSource) {
        this.esDataSource = esDataSource;
    }

    public void setContextService(ContextService contextService) {
        this.contextService = contextService;
    }

    public void setEngine(EntityClassEngine engine) {
        this.engine = engine;
    }

    public void setExecutionConfig(ExecutionConfig executionConfig) {
        this.executionConfig = executionConfig;
    }

    public DataQueryProvider.QueryProviderType type() {
        return DataQueryProvider.QueryProviderType.INDEX;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Timed(value="oqs.process.delay.latency", percentiles={0.5, 0.9, 0.99}, extraTags={"query", "es"})
    public List<Object> query(String app, IEntityClass entityClass, String profile, RelDataType type, List<RexNode> ops, List<Map.Entry<String, Tuple2<StructKind, Class>>> fields, List<Pair<RexNode, String>> projects, List<Map.Entry<String, RelFieldCollation.Direction>> sort, Long offset, Long fetch, List<String> groupBy, List<AggregateCall> aggs, List<RelHint> hints, RelNode rawTree, DataContext dataContext) {
        this.contextService.getAll().put("invocation", "index");
        Tuple2<String, String> searchIndex = this.manageBocpMetadataService.getSearchSegmentIndex(profile, entityClass.code());
        if (searchIndex != null) {
            if (searchIndex._2 == null) return Collections.emptyList();
            if (((String)searchIndex._2).equalsIgnoreCase("$TEMP$")) {
                return Collections.emptyList();
            }
        }
        SelectConfig selectConfig = ParseSqlNodeUtils.getSelectConfig(profile, type, ops, fields, projects, sort, offset, fetch, groupBy, aggs, hints, rawTree, dataContext);
        try (Connection connection = this.esDataSource.getConnection();){
            ArrayList<Object> retList;
            ElasticCustomShuttle elasticCustomShuttle = new ElasticCustomShuttle();
            rawTree.accept((RelShuttle)elasticCustomShuttle);
            ElasticSearchSqlConverter elasticSearchSqlConverter = new ElasticSearchSqlConverter(this.engine, this.contextService, elasticCustomShuttle);
            SqlNode sqlNode = elasticSearchSqlConverter.oqsRelNodeConverterElasticSql(entityClass, selectConfig);
            String sql = ParseSqlNodeUtils.converterSqlString(sqlNode);
            log.info(String.format("elasticsearch query engine execute sql:%s.", sql));
            this.contextService.getAll().put("hasCount", this.hasCount(selectConfig));
            try (Statement preparedStatement = connection.createStatement();){
                ResultSet resultSet = preparedStatement.executeQuery(sql);
                retList = new ArrayList<Object>();
                while (resultSet.next()) {
                    ArrayList row = new ArrayList();
                    fields.forEach(f -> {
                        String key = (String)f.getKey();
                        if (!key.startsWith("_") && key.contains(".")) {
                            key = ((String)f.getKey()).replace(".", "_");
                        }
                        if (key.startsWith("_")) {
                            key = key.substring(1);
                        }
                        Object rs = MasterStorageHelper.getRs((ResultSet)resultSet, (String)key, (Class)((Class)((Tuple2)f.getValue())._2));
                        row.add(rs);
                    });
                    if (row.size() > 1) {
                        retList.add(row.toArray());
                        continue;
                    }
                    retList.add(row.get(0));
                }
            }
            ArrayList<Object> arrayList = retList;
            return arrayList;
        }
        catch (Throwable throwable) {
            log.error("elasticsearch execute query failed!,cause by {}", throwable);
            throw new RuntimeException(throwable);
        }
    }

    private boolean hasCount(SelectConfig selectConfig) {
        return selectConfig.getHints().stream().anyMatch(x -> x.hintName.equalsIgnoreCase("show_count"));
    }
}

