/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.adapter.elasticsearch.query.utils;

import com.google.common.collect.ImmutableList;
import com.xforceplus.ultraman.metadata.engine.EntityClassGroup;
import com.xforceplus.ultraman.metadata.entity.FieldType;
import com.xforceplus.ultraman.metadata.entity.IEntityField;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.rel2sql.RelToSqlConverter;
import org.apache.calcite.rel.rel2sql.SqlImplementor;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;

public class ElasticSearchRelToSqlConverter
extends RelToSqlConverter {
    private EntityClassGroup entityClassGroup;

    public ElasticSearchRelToSqlConverter(SqlDialect dialect, EntityClassGroup entityClassGroup) {
        super(dialect);
        this.entityClassGroup = entityClassGroup;
    }

    private void parseCorrelTable(RelNode relNode, SqlImplementor.Result x) {
        for (CorrelationId id : relNode.getVariablesSet()) {
            this.correlTableMap.put(id, x.qualifiedContext());
        }
    }

    private SqlNode castNullType(SqlNode nullLiteral, RelDataType type) {
        SqlNode typeNode = this.dialect.getCastSpec(type);
        if (typeNode == null) {
            return nullLiteral;
        }
        return SqlStdOperatorTable.CAST.createCall(POS, new SqlNode[]{nullLiteral, typeNode});
    }

    public SqlImplementor.Result visit(Project e) {
        SqlImplementor.Result x = e.getInput() instanceof Sort ? this.visitInput((RelNode)e, 0) : this.visitInput((RelNode)e, 0, new SqlImplementor.Clause[]{SqlImplementor.Clause.SELECT});
        this.parseCorrelTable((RelNode)e, x);
        SqlImplementor.Builder builder = x.builder((RelNode)e);
        if (!ElasticSearchRelToSqlConverter.isStar((List)e.getProjects(), (RelDataType)e.getInput().getRowType(), (RelDataType)e.getRowType())) {
            ArrayList selectList = new ArrayList();
            for (RexNode ref : e.getProjects()) {
                ImmutableList names;
                String value;
                Optional field;
                SqlNode sqlExpr = builder.context.toSql(null, ref);
                if (sqlExpr instanceof SqlIdentifier && (field = this.entityClassGroup.field(value = (names = ((SqlIdentifier)sqlExpr).names).size() > 1 ? (String)((SqlIdentifier)sqlExpr).names.get(1) : ((SqlIdentifier)sqlExpr).getSimple())).isPresent() && ((IEntityField)field.get()).type() == FieldType.STRINGS) {
                    ArrayList as = new ArrayList();
                    sqlExpr = new SqlIdentifier(value.concat("@raw"), SqlParserPos.ZERO);
                }
                if (SqlUtil.isNullLiteral((SqlNode)sqlExpr, (boolean)false)) {
                    RelDataTypeField field2 = (RelDataTypeField)e.getRowType().getFieldList().get(selectList.size());
                    sqlExpr = this.castNullType(sqlExpr, field2.getType());
                }
                this.addSelect(selectList, sqlExpr, e.getRowType());
            }
            builder.setSelect(new SqlNodeList(selectList, POS));
        }
        return builder.result();
    }
}

