/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.adapter.elasticsearch.query.utils;

import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.ultraman.adapter.elasticsearch.query.ElasticCustomShuttle;
import com.xforceplus.ultraman.adapter.elasticsearch.query.utils.ElasticSearchRelToSqlConverter;
import com.xforceplus.ultraman.adapter.elasticsearch.query.utils.ParseSqlNodeUtils;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.metadata.engine.EntityClassGroup;
import com.xforceplus.ultraman.metadata.entity.FieldType;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.metadata.entity.IEntityField;
import com.xforceplus.ultraman.metadata.entity.IRelation;
import com.xforceplus.ultraman.metadata.entity.legacy.impl.ColumnField;
import com.xforceplus.ultraman.oqsengine.plus.master.mysql.MysqlSqlDialectEx;
import com.xforceplus.ultraman.oqsengine.plus.storage.pojo.dto.select.SelectConfig;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Stack;
import java.util.stream.Collectors;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.RelShuttleImpl;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.sql.SqlAsOperator;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlNumericLiteral;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.util.SqlShuttle;
import org.apache.calcite.sql.util.SqlVisitor;

public class ElasticSearchSqlConverter {
    private EntityClassEngine engine;
    private ContextService contextService;
    private ElasticCustomShuttle elasticCustomShuttle;

    public ElasticSearchSqlConverter(EntityClassEngine engine, ContextService contextService, ElasticCustomShuttle elasticCustomShuttle) {
        this.engine = engine;
        this.contextService = contextService;
        this.elasticCustomShuttle = elasticCustomShuttle;
    }

    public SqlNode oqsRelNodeConverterElasticSql(IEntityClass entityClass, SelectConfig selectConfig) {
        EntityClassGroup group = this.engine.describe(entityClass, selectConfig.getProfile());
        ParseSqlNodeUtils parseSqlNodeUtils = new ParseSqlNodeUtils(group, this.engine);
        SqlNode sqlNode = new ElasticSearchRelToSqlConverter(MysqlSqlDialectEx.DEFAULT, group).visitRoot(selectConfig.getRawTree()).asStatement();
        if (this.elasticCustomShuttle.getJoinsCounter()) {
            if (sqlNode instanceof SqlSelect) {
                ArrayList<String> qualifiedName = new ArrayList<String>();
                qualifiedName.add(entityClass.appCode());
                qualifiedName.add(entityClass.code());
                SqlIdentifier from = new SqlIdentifier(qualifiedName, SqlParserPos.ZERO);
                SqlNodeList selectList = ((SqlSelect)sqlNode).getSelectList();
                SqlNodeList orderList = ((SqlSelect)sqlNode).getOrderList();
                parseSqlNodeUtils.findSqlJoinConditions(sqlNode);
                List<SqlNode> conditions = parseSqlNodeUtils.getConditions();
                SqlBasicCall condition = null;
                if (parseSqlNodeUtils.getConditions().size() > 1) {
                    condition = new SqlBasicCall((SqlOperator)SqlStdOperatorTable.AND, parseSqlNodeUtils.getConditions(), SqlParserPos.ZERO);
                } else if (conditions.size() == 1) {
                    condition = (SqlBasicCall)conditions.get(0);
                }
                Integer fetch = selectConfig.getFetch();
                Integer offset = selectConfig.getOffset();
                SqlNumericLiteral fetchExactNumeric = SqlLiteral.createExactNumeric((String)String.valueOf(fetch), (SqlParserPos)SqlParserPos.ZERO);
                SqlNumericLiteral offsetExactNumeric = null;
                if (offset != null) {
                    offsetExactNumeric = SqlLiteral.createExactNumeric((String)String.valueOf(offset), (SqlParserPos)SqlParserPos.ZERO);
                }
                SqlSelect sqlSelect = new SqlSelect(SqlParserPos.ZERO, SqlNodeList.EMPTY, selectList, (SqlNode)from, (SqlNode)condition, null, null, null, orderList, (SqlNode)offsetExactNumeric, (SqlNode)fetchExactNumeric, null);
                parseSqlNodeUtils.recursion((SqlNode)sqlSelect);
                sqlNode = sqlSelect;
            }
            this.contextService.getAll().put("join_query", true);
        } else {
            this.contextService.getAll().put("join_query", false);
            this.queryMasterCondition(sqlNode, selectConfig.getRawTree(), group);
        }
        return sqlNode;
    }

    private void queryMasterCondition(SqlNode sqlNode, RelNode rawTree, EntityClassGroup group) {
        if (sqlNode instanceof SqlSelect) {
            AppendSql appendSql = new AppendSql();
            ProjectExpand projectExpand = new ProjectExpand();
            NormalizeFields normalizeFields = new NormalizeFields(group);
            sqlNode.accept((SqlVisitor)appendSql);
            rawTree.accept((RelShuttle)projectExpand);
            if (((SqlSelect)sqlNode).getOrderList() != null) {
                ((SqlSelect)sqlNode).setOrderBy((SqlNodeList)((SqlSelect)sqlNode).getOrderList().accept((SqlVisitor)normalizeFields));
            }
            if (projectExpand.noProject) {
                List collect = group.getEntityClass().fields().stream().map(x -> {
                    SqlIdentifier from = null;
                    String realName = x.name().replaceAll("\\.", "_");
                    if (x.type() == FieldType.STRINGS) {
                        ArrayList<SqlIdentifier> as = new ArrayList<SqlIdentifier>();
                        as.add(new SqlIdentifier(realName.concat("@raw"), SqlParserPos.ZERO));
                        as.add(new SqlIdentifier(realName, SqlParserPos.ZERO));
                        from = new SqlBasicCall((SqlOperator)new SqlAsOperator(), as, SqlParserPos.ZERO);
                    } else {
                        from = new SqlIdentifier(realName, SqlParserPos.ZERO);
                    }
                    return from;
                }).collect(Collectors.toList());
                ((SqlSelect)sqlNode).setSelectList(new SqlNodeList(collect, SqlParserPos.ZERO));
            }
            Stack<Tuple2<SqlSelect, SqlNode>> node = appendSql.node;
            Tuple2 where = null;
            SqlIdentifier create_time = new SqlIdentifier("create_time", SqlParserPos.ZERO);
            ArrayList<SqlIdentifier> sqlNodes = new ArrayList<SqlIdentifier>();
            sqlNodes.add(create_time);
            SqlBasicCall condition = new SqlBasicCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, sqlNodes, SqlParserPos.ZERO);
            if (!node.isEmpty()) {
                where = (Tuple2)node.get(0);
                if (where._2 instanceof SqlLiteral) {
                    ((SqlSelect)where._1).setWhere((SqlNode)condition.accept((SqlVisitor)normalizeFields));
                } else {
                    ArrayList<Object> conditions = new ArrayList<Object>();
                    conditions.add(((SqlNode)where._2).accept((SqlVisitor)normalizeFields));
                    conditions.add(condition);
                    ((SqlSelect)where._1).setWhere((SqlNode)new SqlBasicCall((SqlOperator)SqlStdOperatorTable.AND, conditions, SqlParserPos.ZERO));
                }
            }
        }
    }

    private Map<String, IEntityField> getRowType(String profile, IEntityClass iEntityClass) {
        EntityClassGroup describe = this.engine.describe(iEntityClass, profile);
        HashMap<String, IEntityField> entityFieldSet = new HashMap<String, IEntityField>();
        describe.getAllFields().stream().forEach(x -> entityFieldSet.put(x.name().toLowerCase(Locale.ROOT).replace(".", "_"), (IEntityField)x));
        for (IRelation iRelation : iEntityClass.relations()) {
            Optional iRelationEntityClassGroup = this.engine.load(String.valueOf(iRelation.getEntityClassId()), profile);
            IEntityClass iRelationEntityClass = (IEntityClass)iRelationEntityClassGroup.get();
            this.engine.describe(iRelationEntityClass, profile).getAllFields().stream().forEach(x -> entityFieldSet.put(x.name().toLowerCase(Locale.ROOT).replace(".", "_"), (IEntityField)x));
        }
        return entityFieldSet;
    }

    class AppendSql
    extends SqlShuttle {
        Stack<Tuple2<SqlSelect, SqlNode>> node = new Stack();

        AppendSql() {
        }

        public SqlNode visit(SqlCall call) {
            if (call instanceof SqlSelect) {
                call.getOperandList().stream().filter(Objects::nonNull).forEach(x -> {
                    SqlNode cfr_ignored_0 = (SqlNode)x.accept((SqlVisitor)this);
                });
                if (((SqlSelect)call).getWhere() != null) {
                    this.node.push((Tuple2<SqlSelect, SqlNode>)Tuple.of((Object)((SqlSelect)call), (Object)((SqlSelect)call).getWhere()));
                } else {
                    this.node.push((Tuple2<SqlSelect, SqlNode>)Tuple.of((Object)((SqlSelect)call), (Object)SqlLiteral.createBoolean((boolean)true, (SqlParserPos)SqlParserPos.ZERO)));
                }
            }
            return super.visit(call);
        }
    }

    class ProjectExpand
    extends RelShuttleImpl {
        private boolean noProject = true;

        ProjectExpand() {
        }

        public RelNode visit(RelNode other) {
            other.getInputs().forEach(x -> x.accept((RelShuttle)this));
            if (other instanceof Project) {
                this.noProject = false;
            }
            return super.visit(other);
        }
    }

    class NormalizeFields
    extends SqlShuttle {
        private EntityClassGroup group;

        public NormalizeFields(EntityClassGroup group) {
            this.group = group;
        }

        public SqlNode visit(SqlIdentifier identifier) {
            String targetName;
            super.visit(identifier);
            String finalTargetName = targetName = identifier.getSimple();
            Optional<ColumnField> first = this.group.columns().stream().filter(x -> x.name().equalsIgnoreCase(finalTargetName)).findFirst();
            if (first.isPresent()) {
                targetName = first.get().name();
            }
            String replace = targetName.replace(".", "_");
            return identifier.setName(0, replace);
        }
    }
}

