/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.adapter.elasticsearch.rules;

import com.xforceplus.ultraman.adapter.elasticsearch.ElasticsearchRel;
import com.xforceplus.ultraman.adapter.elasticsearch.ElasticsearchTable;
import com.xforceplus.ultraman.metadata.engine.EntityClassGroup;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.metadata.entity.legacy.impl.ColumnField;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ElasticsearchSort
extends Sort
implements ElasticsearchRel {
    public ElasticsearchSort(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, RelCollation collation, RexNode offset, RexNode fetch) {
        super(cluster, traitSet, child, collation, offset, fetch);
        assert (this.getConvention() == ElasticsearchRel.CONVENTION);
        assert (this.getConvention() == child.getConvention());
    }

    public @Nullable RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return super.computeSelfCost(planner, mq).multiplyBy(0.05);
    }

    public Sort copy(RelTraitSet traitSet, RelNode relNode, RelCollation relCollation, RexNode offset, RexNode fetch) {
        return new ElasticsearchSort(this.getCluster(), traitSet, relNode, this.collation, offset, fetch);
    }

    @Override
    public void implement(ElasticsearchRel.Implementor implementor) {
        implementor.visitChild(0, this.getInput());
        List fields = this.getRowType().getFieldList();
        for (RelFieldCollation fieldCollation : this.collation.getFieldCollations()) {
            String name = ((RelDataTypeField)fields.get(fieldCollation.getFieldIndex())).getName();
            String rawName = implementor.expressionItemMap.getOrDefault(name, name);
            ElasticsearchTable elasticsearchTable = implementor.elasticsearchTable;
            String profile = elasticsearchTable.fetcher.getProfile(Collections.emptyMap());
            Optional targetIEntityClass = elasticsearchTable.engine.loadByCode(elasticsearchTable.entityCode, profile);
            EntityClassGroup group = elasticsearchTable.engine.describe((IEntityClass)targetIEntityClass.get(), profile);
            Optional<ColumnField> targetField = group.columns().stream().filter(x -> x.name().equalsIgnoreCase(rawName) || x.name().replace(".", "_").equalsIgnoreCase(rawName)).findAny();
            targetField.ifPresent(columnField -> implementor.addSort(columnField.name(), fieldCollation.getDirection()));
        }
        if (this.offset != null) {
            implementor.offset((Long)((RexLiteral)this.offset).getValueAs(Long.class));
        }
        if (this.fetch != null) {
            implementor.fetch((Long)((RexLiteral)this.fetch).getValueAs(Long.class));
        }
    }
}

