/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.adapter.elasticsearch.service.adatper;

import com.xforceplus.ultraman.cdc.adapter.CDCBeforeCallback;
import com.xforceplus.ultraman.metadata.cdc.OqsEngineEntity;
import com.xforceplus.ultraman.metadata.domain.record.Record;
import com.xforceplus.ultraman.metadata.domain.vo.DataCollection;
import com.xforceplus.ultraman.metadata.engine.EntityClassGroup;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.sdk.core.facade.EntityFacade;
import com.xforceplus.ultraman.sdk.core.facade.result.QueryResult;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpCondition;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpField;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpNode;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpOperator;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpQuery;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpRel;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpValue;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.control.Either;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class CompleteOqsEntity
implements CDCBeforeCallback {
    private static final Logger log = LoggerFactory.getLogger(CompleteOqsEntity.class);
    @Autowired
    private EntityFacade entityFacade;

    public String name() {
        return this.getClass().getName();
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public void mutate(List<OqsEngineEntity> oqsEngineEntities) {
        Map<Tuple2, List<OqsEngineEntity>> grouped = oqsEngineEntities.stream().filter(x -> !x.isIntact()).collect(Collectors.groupingBy(x -> Tuple.of((Object)x.getEntityClassRef().getId(), (Object)Optional.ofNullable(x.getAttributes().get("_sys_profile")).orElse(""))));
        grouped.forEach((k, v) -> {
            Optional targetOp = this.entityFacade.load(Long.toString((Long)k._1), (String)k._2());
            if (targetOp.isPresent()) {
                EntityClassGroup group = this.entityFacade.getEntityClassEngine().describe((IEntityClass)targetOp.get(), (String)k._2());
                log.warn("Trigger {} complete, this will get newest state and maybe rollback afterwards", k);
                IEntityClass entityClass = (IEntityClass)targetOp.get();
                List collect = v.stream().map(x -> x.getId()).collect(Collectors.toList());
                ExpQuery expQuery = new ExpQuery().range(Integer.valueOf(1), Integer.valueOf(collect.size()));
                expQuery.filters((ExpNode)ExpCondition.call((ExpOperator)ExpOperator.IN, (ExpNode)ExpField.ID, (List)ExpValue.from(collect)));
                CompletionStage query = this.entityFacade.query(entityClass, (ExpRel)expQuery, Collections.emptyMap());
                try {
                    Either dataCollections = (Either)query.toCompletableFuture().get();
                    if (dataCollections.isRight()) {
                        this.fillOqsEntities(group, ((DataCollection)dataCollections.get()).getRows(), (List<OqsEngineEntity>)v);
                    } else {
                        log.error(((QueryResult)dataCollections.getLeft()).getMessage());
                    }
                }
                catch (InterruptedException | ExecutionException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void fillOqsEntities(EntityClassGroup group, List<Record> rows, List<OqsEngineEntity> v) {
        Map<Long, OqsEngineEntity> mapping = v.stream().collect(Collectors.toMap(x -> x.getId(), y -> y, (a, b) -> b));
        rows.forEach(row -> {
            Long id = row.getId();
            OqsEngineEntity oqsEngineEntity = (OqsEngineEntity)mapping.get(id);
            if (oqsEngineEntity != null) {
                group.getAllFields().forEach(f -> oqsEngineEntity.getAttributes().put(f.name(), row.get(f.name()).orElse(null)));
            }
        });
    }
}

