/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.adapter.elasticsearch.service.adatper;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.xforceplus.metadata.schema.rels.MetadataRelationType;
import com.xforceplus.metadata.schema.runtime.MetadataEngine;
import com.xforceplus.tech.base.core.context.ContextKeys;
import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.ultraman.adapter.elasticsearch.query.po.BocpElasticConfigPo;
import com.xforceplus.ultraman.adapter.elasticsearch.service.utils.BocpMetabaseCacheUtils;
import com.xforceplus.ultraman.cdc.adapter.CDCBeforeCallback;
import com.xforceplus.ultraman.metadata.cdc.OqsEngineEntity;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.metadata.engine.EntityClassGroup;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.sdk.infra.utils.JacksonDefaultMapper;
import com.xforceplus.ultraman.sdk.infra.utils.ThreadFactoryHelper;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;

public class ToOneRelatedCallback
implements CDCBeforeCallback {
    private static final String SQL = "SELECT * from %s where %s in (%s)";
    @Autowired
    private EntityClassEngine engine;
    @Lazy
    @Qualifier(value="master")
    @Autowired
    private DataSource dataSource;
    @Autowired
    private ContextService contextService;
    private ExecutorService executorService = ThreadFactoryHelper.buildThreadPool((int)20, (int)1000, (String)"ToOneRelated", (boolean)false);

    public void setEngine(EntityClassEngine engine) {
        this.engine = engine;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setContextService(ContextService contextService) {
        this.contextService = contextService;
    }

    public String name() {
        return this.getClass().getName();
    }

    public void mutate(List<OqsEngineEntity> oqsEngineEntities) {
        Map<Long, List<OqsEngineEntity>> grouped = oqsEngineEntities.stream().collect(Collectors.groupingBy(x -> x.getEntityClassRef().getId()));
        grouped.forEach((k, v) -> {
            Map<String, List<OqsEngineEntity>> profiledMapping = oqsEngineEntities.stream().collect(Collectors.groupingBy(x -> x.getEntityClassRef().getProfile()));
            MetadataEngine meta = this.engine.meta();
            List toOne = (List)meta.raw(g -> {
                ArrayList<Tuple2> relatedList = new ArrayList<Tuple2>();
                GraphTraversal select = g.traversal().V(new Object[0]).has("nodeLabel", (Object)"Bo").has("_id", k).inE(new String[]{MetadataRelationType.TO_ONE.name()}).as("TO_ONE", new String[0]).outV().as("RELATED_V", new String[0]).select("TO_ONE", "RELATED_V", new String[0]);
                while (select.hasNext()) {
                    Map next = (Map)select.next();
                    Edge edge = (Edge)next.get("TO_ONE");
                    Vertex relatedV = (Vertex)next.get("RELATED_V");
                    String related = (String)edge.value("code");
                    String id = (String)relatedV.value("_id");
                    relatedList.add(Tuple.of((Object)related, (Object)id));
                }
                return relatedList;
            });
            toOne.forEach(rel -> {
                Optional related = this.engine.load((String)rel._2, "");
                if (related.isPresent()) {
                    IEntityClass targetRelated = (IEntityClass)related.get();
                    this.fillRelatedId((String)rel._1, targetRelated, (List<OqsEngineEntity>)v, false);
                }
            });
            Optional selfOp = this.engine.load(Long.toString(k), "");
            if (selfOp.isPresent()) {
                IEntityClass entityClass = (IEntityClass)selfOp.get();
                EntityClassGroup describe = this.engine.describe(entityClass, "");
                describe.getAllRelations().forEach(rel -> {
                    Optional relatedEntityClass;
                    if (rel.getRelationType().equalsIgnoreCase("TO_ONE") && (relatedEntityClass = describe.relatedEntityClass(rel.getName())).isPresent()) {
                        ArrayList<OqsEngineEntity> needForRetrieve = new ArrayList<OqsEngineEntity>();
                        profiledMapping.forEach((p, rest) -> {
                            BocpElasticConfigPo bocpElasticConfigPo;
                            Map<Long, BocpElasticConfigPo> bocpConfig = BocpMetabaseCacheUtils.getBocpConfig(p);
                            if (bocpConfig != null && (bocpElasticConfigPo = bocpConfig.get(((IEntityClass)relatedEntityClass.get()).id())) != null && bocpElasticConfigPo.isEnableSegment()) {
                                needForRetrieve.addAll((Collection<OqsEngineEntity>)rest);
                            }
                        });
                        this.fillRelatedId(rel.getName(), (IEntityClass)relatedEntityClass.get(), needForRetrieve, true);
                    }
                });
            }
        });
    }

    void fillRelatedId(String related, IEntityClass entityClass, List<OqsEngineEntity> oqsEngineEntities, boolean isSelf) {
        Map<String, List<OqsEngineEntity>> tenantGrouped = oqsEngineEntities.stream().collect(Collectors.groupingBy(x -> {
            Object tenantCode = x.getAttributes().get("tenant_code");
            if (tenantCode == null) {
                return "DEFAULT";
            }
            return tenantCode.toString();
        }));
        tenantGrouped.forEach((k, v) -> {
            try {
                this.executorService.submit(() -> {
                    try {
                        HashMap idMapping = new HashMap();
                        String ids = !isSelf ? v.stream().map(OqsEngineEntity::getId).map(Object::toString).distinct().collect(Collectors.joining(",")) : v.stream().map(x -> {
                            Map attributes = x.getAttributes();
                            Object id = attributes.get(related.concat("_id"));
                            if (id != null) {
                                Long idLong = Long.parseLong(id.toString());
                                idMapping.compute(idLong, (k1, v1) -> {
                                    if (v1 == null) {
                                        v1 = new ArrayList<Long>();
                                    }
                                    v1.add(x.getId());
                                    return v1;
                                });
                            }
                            return id;
                        }).filter(Objects::nonNull).map(Object::toString).distinct().collect(Collectors.joining(","));
                        if (StringUtils.isEmpty((CharSequence)ids)) {
                            return;
                        }
                        Map<Long, OqsEngineEntity> hashSearch = v.stream().collect(Collectors.toMap(OqsEngineEntity::getId, y -> y, (a, b) -> a));
                        if (!"DEFAULT".equals(k)) {
                            this.contextService.set((ContextService.ContextKey)ContextKeys.StringKeys.TENANTCODE_KEY, k);
                        }
                        String relatedID = !isSelf ? related.concat("_id") : "id";
                        String sql = String.format(SQL, entityClass.masterWriteTable(true), relatedID, ids);
                        HashMap<Long, Tuple2> mapping = new HashMap<Long, Tuple2>();
                        try (Connection connection = this.dataSource.getConnection();
                             PreparedStatement statement = connection.prepareStatement(sql);){
                            ResultSet resultSet = statement.executeQuery();
                            ResultSetMetaData metaData = resultSet.getMetaData();
                            int columnCount = metaData.getColumnCount();
                            while (resultSet.next()) {
                                long mainId = resultSet.getLong("id");
                                List relatedId = new ArrayList<Long>();
                                if (!isSelf) {
                                    relatedId.add(resultSet.getLong(relatedID));
                                } else {
                                    relatedId = (List)idMapping.get(mainId);
                                }
                                String dynamic = resultSet.getString("_sys_dynamic");
                                HashMap<String, Object> rawBody = new HashMap<String, Object>();
                                for (int i = 1; i <= columnCount; ++i) {
                                    String columnName = metaData.getColumnName(i);
                                    if (columnName.equalsIgnoreCase("_sys_dynamic")) continue;
                                    rawBody.put(columnName, resultSet.getObject(i));
                                }
                                try {
                                    Map dynamicValue = (Map)JacksonDefaultMapper.OBJECT_MAPPER.readValue(dynamic, Map.class);
                                    rawBody.putAll(dynamicValue);
                                }
                                catch (JsonProcessingException e) {
                                    e.printStackTrace();
                                }
                                relatedId.forEach(rd -> mapping.put((Long)rd, Tuple.of((Object)mainId, (Object)rawBody)));
                            }
                            statement.close();
                            resultSet.close();
                        }
                        mapping.forEach((t1, t2) -> {
                            OqsEngineEntity oqsEngineEntity = (OqsEngineEntity)hashSearch.get(t1);
                            if (oqsEngineEntity != null) {
                                oqsEngineEntity.getToOneRelatedList().add(Tuple.of((Object)entityClass.code(), (Object)k, (Object)related, (Object)t2));
                            }
                        });
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                    this.contextService.clear();
                }).get();
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
        });
    }
}

