/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.adapter.elasticsearch.service.impl;

import com.xforceplus.ultraman.adapter.elasticsearch.service.IndexOperation;
import com.xforceplus.ultraman.adapter.elasticsearch.service.constant.FieldMappingType;
import com.xforceplus.ultraman.adapter.elasticsearch.service.constant.SettingProperties;
import com.xforceplus.ultraman.adapter.elasticsearch.service.entity.FieldMapping;
import com.xforceplus.ultraman.adapter.elasticsearch.service.utils.ElasticSearchMappingBuildUtils;
import com.xforceplus.ultraman.adapter.elasticsearch.transport.ElasticsearchTransportExecutor;
import com.xforceplus.ultraman.metadata.entity.FieldType;
import com.xforceplus.ultraman.metadata.entity.IEntityField;
import com.xforceplus.ultraman.sdk.core.datasource.route.TransportExecutor;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.CreateIndexResponse;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.client.indices.GetIndexResponse;
import org.elasticsearch.client.indices.GetMappingsRequest;
import org.elasticsearch.client.indices.GetMappingsResponse;
import org.elasticsearch.client.indices.PutMappingRequest;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ElasticSearchIndexImpl
implements IndexOperation {
    private static final Logger log = LoggerFactory.getLogger(ElasticSearchIndexImpl.class);
    private int shards;
    private int replicas;
    private int retryOnConflict;
    private int threadHandleBatch = 1000;
    @Autowired
    private TransportExecutor elasticsearchTransportExecutor;

    public ElasticSearchIndexImpl(int shards, int replicas, int retryOnConflict, int threadHandleBatch) {
        this.shards = shards;
        this.replicas = replicas;
        this.retryOnConflict = retryOnConflict;
        this.threadHandleBatch = threadHandleBatch;
    }

    public static void buildSetting(CreateIndexRequest request, int number_of_shards, int number_of_replicas) {
        if (number_of_shards == 0 && number_of_replicas == 0) {
            number_of_replicas = SettingProperties.NUMBER_OF_REPLICAS;
            number_of_shards = SettingProperties.NUMBER_OF_SHARDS;
        }
        request.settings(Settings.builder().put("index.number_of_shards", number_of_shards).put("index.number_of_replicas", number_of_replicas).put("index.max_script_fields", 1000).put("index.max_docvalue_fields_search", 1000));
    }

    @Override
    public boolean createIndexAndCreateMapping(String idxName, Collection<IEntityField> allFields, String profile) {
        try {
            if (!this.indexExists(idxName, profile)) {
                CreateIndexRequest request = new CreateIndexRequest(idxName);
                ElasticSearchIndexImpl.buildSetting(request, this.shards, this.replicas);
                request.mapping(this.getxContentBuilder(allFields, null));
                RestHighLevelClient executor = ((ElasticsearchTransportExecutor)this.elasticsearchTransportExecutor).executor(profile);
                CreateIndexResponse res = executor.indices().create(request, RequestOptions.DEFAULT);
                return res.isAcknowledged();
            }
            return true;
        }
        catch (Exception ex) {
            log.error(ex.getMessage());
            throw new RuntimeException(ex.getCause());
        }
    }

    @Override
    public boolean indexExists(String idxName, String profile) {
        try {
            GetIndexRequest request = new GetIndexRequest(new String[]{idxName.toLowerCase(Locale.ROOT)});
            boolean exists = ((ElasticsearchTransportExecutor)this.elasticsearchTransportExecutor).executor(profile).indices().exists(request, RequestOptions.DEFAULT);
            return exists;
        }
        catch (Exception ex) {
            log.error(ex.getMessage());
            throw new RuntimeException(ex.getCause());
        }
    }

    @Override
    public boolean indexExists(String profile, String ... idxNames) {
        try {
            String[] lowercaseIndices = new String[idxNames.length];
            int index = 0;
            for (String idxName : idxNames) {
                lowercaseIndices[index++] = idxName.toLowerCase(Locale.ROOT);
            }
            GetIndexRequest request = new GetIndexRequest(lowercaseIndices);
            boolean exists = ((ElasticsearchTransportExecutor)this.elasticsearchTransportExecutor).executor(profile).indices().exists(request, RequestOptions.DEFAULT);
            return exists;
        }
        catch (Exception ex) {
            log.error(ex.getMessage());
            throw new RuntimeException(ex.getCause());
        }
    }

    @Override
    public Set<String> getAllIndex(String profile) {
        try {
            GetIndexRequest request = new GetIndexRequest(new String[]{"*"});
            GetIndexResponse response = ((ElasticsearchTransportExecutor)this.elasticsearchTransportExecutor).executor(profile).indices().get(request, RequestOptions.DEFAULT);
            String[] indices = response.getIndices();
            return new HashSet<String>(Arrays.asList(indices));
        }
        catch (Exception ex) {
            log.error(ex.getMessage());
            throw new RuntimeException(ex.getCause());
        }
    }

    @Override
    public boolean joinMapping(String indexName, Set<String> relations, String entityClassCode, String profile) {
        try {
            PutMappingRequest putMappingRequest = new PutMappingRequest(new String[]{indexName});
            AcknowledgedResponse acknowledgedResponse = ((ElasticsearchTransportExecutor)this.elasticsearchTransportExecutor).executor(profile).indices().putMapping(putMappingRequest.source(this.getxContentBuilder(relations, entityClassCode)), RequestOptions.DEFAULT);
            return acknowledgedResponse.isAcknowledged();
        }
        catch (Exception ex) {
            log.error(ex.getMessage());
            throw new RuntimeException(ex);
        }
    }

    private XContentBuilder getxContentBuilder(Collection<IEntityField> allFields, String prefixName) throws IOException {
        XContentBuilder properties = XContentFactory.jsonBuilder().startObject().field("dynamic", "true").field("properties").startObject();
        this.getxContentBuilder(allFields, properties, prefixName);
        properties.endObject();
        properties.endObject();
        return properties;
    }

    private XContentBuilder getxContentBuilder(Set<String> relations, String entityClassCode) throws IOException {
        XContentBuilder properties = XContentFactory.jsonBuilder().startObject().field("dynamic", "true").field("properties").startObject();
        properties = properties.startObject(entityClassCode.concat("_join")).field("type", "join").startObject("relations");
        if (relations != null && relations.size() > 0) {
            properties = properties.field(entityClassCode, (Object)relations.toArray());
        }
        properties.endObject();
        properties.endObject();
        properties.endObject();
        properties.endObject();
        return properties;
    }

    private XContentBuilder getxContentBuilder(Collection<IEntityField> allFields, XContentBuilder properties, String prefixName) throws IOException {
        for (FieldMapping field : ElasticSearchMappingBuildUtils.getFieldInfos(allFields)) {
            String filedName = field.getField().contains(".") ? field.getField().replace(".", "_") : field.getField();
            String string = filedName = StringUtils.isNotEmpty((String)prefixName) ? prefixName.concat(".").concat(filedName) : filedName;
            if (StringUtils.equalsIgnoreCase((String)field.getType(), (String)FieldMappingType.TEXT.getType())) {
                properties = properties.startObject(filedName).field("type", FieldMappingType.TEXT.getType()).field("analyzer", field.getAnalyzer()).field("fielddata", "true").endObject();
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)field.getType(), (String)FieldMappingType.KEYWORD.getType())) {
                properties = properties.startObject(filedName).field("type", FieldMappingType.KEYWORD.getType()).endObject();
                if (field.getOriginField().type() != FieldType.STRINGS) continue;
                properties = properties.startObject(filedName.concat("@raw")).field("type", FieldMappingType.TEXT.getType()).endObject();
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)field.getType(), (String)FieldMappingType.LONG.getType())) {
                properties = properties.startObject(filedName).field("type", FieldMappingType.LONG.getType()).endObject();
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)field.getType(), (String)FieldMappingType.DOUBLE.getType())) {
                properties = properties.startObject(filedName).field("type", FieldMappingType.DOUBLE.getType()).endObject();
                continue;
            }
            if (!StringUtils.equalsIgnoreCase((String)field.getType(), (String)FieldMappingType.BOOLEAN.getType())) continue;
            properties = properties.startObject(filedName).field("type", FieldMappingType.BOOLEAN.getType()).endObject();
        }
        return properties;
    }

    public boolean deleteIndex(String idxName, String profile) {
        try {
            if (!this.indexExists(idxName, profile)) {
                log.error(" idxName={} \u4e0d\u5b58\u5728", (Object)idxName);
                return true;
            }
            AcknowledgedResponse delete = ((ElasticsearchTransportExecutor)this.elasticsearchTransportExecutor).executor(profile).indices().delete(new DeleteIndexRequest(idxName), RequestOptions.DEFAULT);
            return delete.isAcknowledged();
        }
        catch (Exception ex) {
            log.error(ex.getMessage());
            throw new RuntimeException(ex);
        }
    }

    @Override
    public boolean putMapping(String idxName, Collection<IEntityField> appendFields, String prefixName, String profile) {
        try {
            Map<String, String> mappings = this.getMappings(idxName, profile);
            List<IEntityField> filterFields = appendFields.stream().filter(fields -> {
                if (StringUtils.isEmpty((String)prefixName)) {
                    return mappings.get(fields.name()) == null;
                }
                return true;
            }).collect(Collectors.toList());
            PutMappingRequest putMappingRequest = new PutMappingRequest(new String[]{idxName});
            AcknowledgedResponse acknowledgedResponse = ((ElasticsearchTransportExecutor)this.elasticsearchTransportExecutor).executor(profile).indices().putMapping(putMappingRequest.source(this.getxContentBuilder(filterFields, prefixName)), RequestOptions.DEFAULT);
            return acknowledgedResponse.isAcknowledged();
        }
        catch (IOException ex) {
            log.error(ex.getMessage());
            throw new RuntimeException(ex.getCause());
        }
    }

    public Map<String, String> getMappings(String idxName, String profile) throws IOException {
        HashMap<String, String> fieldTypes = new HashMap<String, String>();
        GetMappingsRequest getMappings = new GetMappingsRequest().indices(new String[]{idxName});
        GetMappingsResponse getMappingResponse = ((ElasticsearchTransportExecutor)this.elasticsearchTransportExecutor).executor(profile).indices().getMapping(getMappings, RequestOptions.DEFAULT);
        Map mappings = getMappingResponse.mappings();
        Map indexFields = ((MappingMetadata)mappings.get(idxName)).sourceAsMap();
        indexFields.entrySet().stream().filter(x -> "properties".equalsIgnoreCase((String)x.getKey())).forEach(entry -> {
            Map fieldProperties = (Map)entry.getValue();
            fieldProperties.entrySet().stream().forEach(field -> fieldTypes.put(((String)field.getKey()).toLowerCase(Locale.ROOT), (String)((Map)field.getValue()).get("type")));
        });
        return fieldTypes;
    }
}

