/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.adapter.elasticsearch.service.impl;

import com.xforceplus.ultraman.adapter.elasticsearch.service.ManageBocpMetadataService;
import com.xforceplus.ultraman.adapter.elasticsearch.service.constant.FieldMappingType;
import com.xforceplus.ultraman.adapter.elasticsearch.service.entity.FieldMapping;
import com.xforceplus.ultraman.adapter.elasticsearch.service.utils.ElasticSearchMappingBuildUtils;
import com.xforceplus.ultraman.adapter.elasticsearch.service.utils.ThreadPoolExecutorUtils;
import com.xforceplus.ultraman.adapter.elasticsearch.transport.ElasticsearchTransportExecutor;
import com.xforceplus.ultraman.adapter.elasticsearch.utils.DynamicConfigUtils;
import com.xforceplus.ultraman.cdc.adapter.CDCFilter;
import com.xforceplus.ultraman.cdc.adapter.EngineAdapterService;
import com.xforceplus.ultraman.cdc.adapter.IndexUpsertBeforeCallBack;
import com.xforceplus.ultraman.metadata.cdc.OqsEngineEntity;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.metadata.entity.FieldType;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.metadata.entity.IEntityField;
import com.xforceplus.ultraman.metadata.entity.IRelation;
import com.xforceplus.ultraman.sdk.core.datasource.route.TransportExecutor;
import com.xforceplus.ultraman.sdk.core.datasource.route.dynamic.config.DynamicConfig;
import io.vavr.Tuple2;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.join.query.JoinQueryBuilders;
import org.elasticsearch.join.query.ParentIdQueryBuilder;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ElasticSearchServiceImpl
implements EngineAdapterService {
    private static final Logger log = LoggerFactory.getLogger(ElasticSearchServiceImpl.class);
    @Autowired
    public EntityClassEngine entityClassEngine;
    @Autowired
    private DynamicConfig dynamicConfig;
    @Autowired(required=false)
    private List<CDCFilter> filters = new ArrayList<CDCFilter>();
    private long writeTimeOut = 50L;
    @Autowired(required=false)
    private List<IndexUpsertBeforeCallBack> beforeCallBacks = new ArrayList<IndexUpsertBeforeCallBack>();
    private ForkJoinPool pool = new ForkJoinPool(4);
    @Autowired
    private ManageBocpMetadataService manageBocpMetadataService;
    @Autowired
    private TransportExecutor elasticsearchTransportExecutor;
    private volatile double sync_time = 0.0;
    private volatile long sync_docs = 0L;
    private int shards;
    private int replicas;
    private int retryOnConflict;
    private int threadHandleBatch = 1000;
    private ThreadPoolExecutor executor = ThreadPoolExecutorUtils.executor;

    public ElasticSearchServiceImpl(int shards, int replicas, int threadHandleBatch, int retryOnConflict) {
        this.shards = shards;
        this.replicas = replicas;
        this.threadHandleBatch = threadHandleBatch;
        this.retryOnConflict = retryOnConflict;
    }

    public void setDynamicConfig(DynamicConfig dynamicConfig) {
        this.dynamicConfig = dynamicConfig;
    }

    public void setFilters(List<CDCFilter> filters) {
        this.filters = filters;
    }

    public void setBeforeCallBacks(List<IndexUpsertBeforeCallBack> beforeCallBacks) {
        this.beforeCallBacks = beforeCallBacks;
    }

    public void setManageBocpMetadataService(ManageBocpMetadataService manageBocpMetadataService) {
        this.manageBocpMetadataService = manageBocpMetadataService;
    }

    public void setElasticsearchTransportExecutor(TransportExecutor elasticsearchTransportExecutor) {
        this.elasticsearchTransportExecutor = elasticsearchTransportExecutor;
    }

    public void setEntityClassEngine(EntityClassEngine entityClassEngine) {
        this.entityClassEngine = entityClassEngine;
    }

    private XContentBuilder getxContentBuilder(Collection<IEntityField> allFields, String prefixName) throws IOException {
        XContentBuilder properties = XContentFactory.jsonBuilder().startObject().field("dynamic", "true").field("properties").startObject();
        this.getxContentBuilder(allFields, properties, prefixName);
        properties.endObject();
        properties.endObject();
        return properties;
    }

    private XContentBuilder getxContentBuilder(Set<String> relations, String entityClassCode) throws IOException {
        XContentBuilder properties = XContentFactory.jsonBuilder().startObject().field("dynamic", "true").field("properties").startObject();
        properties = properties.startObject(entityClassCode.concat("_join")).field("type", "join").startObject("relations");
        if (relations != null && relations.size() > 0) {
            properties = properties.field(entityClassCode, (Object)relations.toArray());
        }
        properties.endObject();
        properties.endObject();
        properties.endObject();
        properties.endObject();
        return properties;
    }

    private XContentBuilder getxContentBuilder(Collection<IEntityField> allFields, XContentBuilder properties, String prefixName) throws IOException {
        for (FieldMapping field : ElasticSearchMappingBuildUtils.getFieldInfos(allFields)) {
            String filedName = field.getField().contains(".") ? field.getField().replace(".", "_") : field.getField();
            String string = filedName = StringUtils.isNotEmpty((String)prefixName) ? prefixName.concat(".").concat(filedName) : filedName;
            if (StringUtils.equalsIgnoreCase((String)field.getType(), (String)FieldMappingType.TEXT.getType())) {
                properties = properties.startObject(filedName).field("type", FieldMappingType.TEXT.getType()).field("analyzer", field.getAnalyzer()).field("fielddata", "true").endObject();
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)field.getType(), (String)FieldMappingType.KEYWORD.getType())) {
                properties = properties.startObject(filedName).field("type", FieldMappingType.KEYWORD.getType()).endObject();
                if (field.getOriginField().type() != FieldType.STRINGS) continue;
                properties = properties.startObject(filedName.concat("@raw")).field("type", FieldMappingType.TEXT.getType()).endObject();
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)field.getType(), (String)FieldMappingType.LONG.getType())) {
                properties = properties.startObject(filedName).field("type", FieldMappingType.LONG.getType()).endObject();
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)field.getType(), (String)FieldMappingType.DOUBLE.getType())) {
                properties = properties.startObject(filedName).field("type", FieldMappingType.DOUBLE.getType()).endObject();
                continue;
            }
            if (!StringUtils.equalsIgnoreCase((String)field.getType(), (String)FieldMappingType.BOOLEAN.getType())) continue;
            properties = properties.startObject(filedName).field("type", FieldMappingType.BOOLEAN.getType()).endObject();
        }
        return properties;
    }

    public List<CDCFilter> getFilters() {
        return this.filters;
    }

    public List<IndexUpsertBeforeCallBack> getCallBacks() {
        return this.beforeCallBacks;
    }

    public boolean initMetadataInitStatus() {
        return this.manageBocpMetadataService.getLoadFinish();
    }

    public boolean sync(List<OqsEngineEntity> oqsEngineEntities) {
        ArrayList<Future> futures = new ArrayList<Future>();
        long startTime = System.currentTimeMillis();
        for (int i = 0; i <= oqsEngineEntities.size() / this.threadHandleBatch; ++i) {
            int endSubIndex = i * this.threadHandleBatch + this.threadHandleBatch;
            endSubIndex = endSubIndex > oqsEngineEntities.size() ? oqsEngineEntities.size() : endSubIndex;
            this.submitThreadHandler(oqsEngineEntities.subList(i * this.threadHandleBatch, endSubIndex), futures);
        }
        for (Future future : futures) {
            try {
                boolean status = (Boolean)future.get(this.writeTimeOut, TimeUnit.SECONDS);
                if (status) continue;
                return false;
            }
            catch (Exception e) {
                log.error(e.getMessage());
                return false;
            }
        }
        long endTime = System.currentTimeMillis() - startTime;
        this.sync_time += (double)endTime;
        this.sync_docs += (long)oqsEngineEntities.size();
        log.info("elastc_sync(\u5355\u4f4d\u6beb\u79d2)-------elastic\u603b\u5171\u540c\u6b65\u65f6\u95f4time:({})----\u603b\u5171\u540c\u6b65\u8bb0\u5f55:docs({})-----\u5f53\u524d\u6279\u6b21\u540c\u6b65\u6570docs:({}) \u5f53\u524d\u6279\u6b21\u5904\u7406\u65f6\u95f4time:({})", new Object[]{this.sync_time, this.sync_docs, oqsEngineEntities.size(), endTime});
        return true;
    }

    private void submitThreadHandler(List<OqsEngineEntity> batchHandlerEntities, List<Future> futures) {
        Future<Boolean> future = this.executor.submit(() -> {
            try {
                ArrayList<OqsEngineEntity> threadBatchDeletes = new ArrayList<OqsEngineEntity>();
                ArrayList<OqsEngineEntity> threadBatchUpserts = new ArrayList<OqsEngineEntity>();
                batchHandlerEntities.forEach(entity -> {
                    if (entity.isDeleted()) {
                        threadBatchDeletes.add((OqsEngineEntity)entity);
                    } else {
                        threadBatchUpserts.add((OqsEngineEntity)entity);
                    }
                });
                if (threadBatchUpserts.size() > 0 && !this.saveOrUpdate(threadBatchUpserts)) {
                    return false;
                }
                if (threadBatchDeletes.size() > 0 && !this.deleteBatch(threadBatchDeletes).booleanValue()) {
                    return false;
                }
            }
            catch (Exception e) {
                log.error("FAILURE,elasticsearch submitThreadHandler method execute failed!,cause by:{}", (Object)e.getMessage());
                return false;
            }
            return true;
        });
        futures.add(future);
    }

    public boolean saveOrUpdate(List<OqsEngineEntity> oqsEngineEntitys) throws IOException {
        HashMap<String, List<BulkRequest>> tenantBulkRequests = new HashMap<String, List<BulkRequest>>();
        this.handleTenantsBatchRows(oqsEngineEntitys).entrySet().stream().forEach(tenantEngineEntitys -> {
            ArrayList bulkRequests = new ArrayList();
            ((Map)tenantEngineEntitys.getValue()).entrySet().stream().forEach(oqsEngineEntities -> {
                BulkRequest bulkRequest = new BulkRequest();
                ((List)oqsEngineEntities.getValue()).forEach(oqsEngineEntity -> {
                    UpdateRequest updateRequest = new UpdateRequest((String)oqsEngineEntities.getKey(), String.valueOf(oqsEngineEntity.getId()));
                    IndexRequest indexRequest = new IndexRequest((String)oqsEngineEntities.getKey()).source(oqsEngineEntity.getAttributes(), XContentType.JSON);
                    indexRequest.id(String.valueOf(oqsEngineEntity.getId()));
                    if (oqsEngineEntity.getRoutingId() != null) {
                        indexRequest.routing(oqsEngineEntity.getRoutingId());
                        updateRequest.routing(oqsEngineEntity.getRoutingId());
                    }
                    updateRequest.doc(indexRequest);
                    updateRequest.retryOnConflict(this.retryOnConflict);
                    updateRequest.docAsUpsert(true);
                    bulkRequest.add(updateRequest);
                });
                bulkRequests.add(bulkRequest);
            });
            tenantBulkRequests.put((String)tenantEngineEntitys.getKey(), bulkRequests);
        });
        return this.sumbitBulk(tenantBulkRequests);
    }

    private boolean sumbitBulk(Map<String, List<BulkRequest>> tenantBulkRequests) {
        for (Map.Entry<String, List<BulkRequest>> bulkRequests : tenantBulkRequests.entrySet()) {
            Boolean result = null;
            try {
                result = (Boolean)((ForkJoinTask)this.pool.submit(() -> {
                    String profile = StringUtils.equalsIgnoreCase((String)((String)bulkRequests.getKey()), (String)"default") ? null : (String)bulkRequests.getKey();
                    return ((Stream)((List)bulkRequests.getValue()).stream().parallel()).map(x -> {
                        x.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                        BulkResponse bulk = null;
                        try {
                            bulk = ((ElasticsearchTransportExecutor)this.elasticsearchTransportExecutor).executor(profile).bulk(x, RequestOptions.DEFAULT);
                        }
                        catch (IOException e) {
                            log.error("{}", (Throwable)e);
                            return false;
                        }
                        if (bulk.hasFailures()) {
                            log.error("FAILURE,elasticsearch sumbitBulk method execute failed!,cause by:{}", (Object)bulk.buildFailureMessage());
                            return false;
                        }
                        return true;
                    }).filter(x -> x == false).findAny().orElse(true);
                })).get();
            }
            catch (InterruptedException | ExecutionException e) {
                log.error("{}", (Throwable)e);
                return false;
            }
            if (result.booleanValue()) continue;
            return false;
        }
        return true;
    }

    public Map<String, Map<String, List<OqsEngineEntity>>> handleTenantsBatchRows(List<OqsEngineEntity> oqsEngineEntitys) {
        try {
            ConcurrentHashMap<String, Map<String, List<OqsEngineEntity>>> batchRows = new ConcurrentHashMap<String, Map<String, List<OqsEngineEntity>>>();
            for (OqsEngineEntity oqsEngineEntity : oqsEngineEntitys) {
                HashMap orDefault = new HashMap();
                String profile = oqsEngineEntity.getEntityClassRef().getProfile();
                IEntityClass iEntityClass = (IEntityClass)this.entityClassEngine.load(String.valueOf(oqsEngineEntity.getEntityClassRef().getId()), profile).get();
                if (null != null || !this.manageBocpMetadataService.checkPassage(profile, iEntityClass)) continue;
                String prefixEntitysKey = this.getProfile(profile);
                Map<String, List<OqsEngineEntity>> tenantEngineEntities = batchRows.putIfAbsent(prefixEntitysKey, orDefault);
                tenantEngineEntities = tenantEngineEntities == null ? orDefault : tenantEngineEntities;
                ArrayList defaultTenantEntities = new ArrayList();
                Tuple2<Boolean, String> writeSegmentIndex = this.getWriteSegmentIndex(profile, oqsEngineEntity.getAttributes(), iEntityClass);
                if (!((Boolean)writeSegmentIndex._1).booleanValue()) continue;
                String indexName = (String)writeSegmentIndex._2;
                List<OqsEngineEntity> oqsEngineEntities = tenantEngineEntities.putIfAbsent(indexName, defaultTenantEntities);
                List<Object> list = oqsEngineEntities = oqsEngineEntities == null ? defaultTenantEntities : oqsEngineEntities;
                if (iEntityClass.relations().size() > 0) {
                    HashMap<String, String> relationMap = new HashMap<String, String>();
                    relationMap.put("name", iEntityClass.code());
                    oqsEngineEntity.getAttributes().put(iEntityClass.code().concat("_join"), relationMap);
                }
                oqsEngineEntities.add(oqsEngineEntity);
                this.buildFatherAttributes(oqsEngineEntity, tenantEngineEntities);
                this.buildWideAttributes(oqsEngineEntity, iEntityClass, tenantEngineEntities);
            }
            return batchRows;
        }
        catch (Throwable e) {
            log.error("FAILURE,elasticsearch handleTenantsBatchRows method failed,cause by:{}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    @NotNull
    private String getProfile(String profile) {
        String prefixEntitysKey = "default";
        if (!StringUtils.isEmpty((String)profile)) {
            prefixEntitysKey = profile;
        }
        return prefixEntitysKey;
    }

    private void buildFatherAttributes(OqsEngineEntity oqsEngineEntity, Map<String, List<OqsEngineEntity>> tenantEngineEntities) {
        if (oqsEngineEntity.getFather() != 0L && !oqsEngineEntity.isDeleted()) {
            String profile = oqsEngineEntity.getEntityClassRef().getProfile();
            ArrayList defaultFatherEntities = new ArrayList();
            IEntityClass fatherEntities = (IEntityClass)this.entityClassEngine.load(String.valueOf(oqsEngineEntity.getFather()), profile).get();
            if (fatherEntities != null || this.manageBocpMetadataService.checkPassage(profile, fatherEntities)) {
                Map<String, List<OqsEngineEntity>> finalTenantEngineEntities = tenantEngineEntities;
                HashMap<String, Long> fatherAttributes = new HashMap<String, Long>();
                for (IEntityField field : fatherEntities.fields()) {
                    String fieldName = field.name().replace(".", "_");
                    if (StringUtils.equalsIgnoreCase((String)fieldName, (String)"id")) {
                        fatherAttributes.put(fieldName, oqsEngineEntity.getId());
                        continue;
                    }
                    fatherAttributes.put(fieldName, (Long)oqsEngineEntity.getAttributes().get(fieldName));
                }
                OqsEngineEntity fatherOqsEngineEntity = new OqsEngineEntity();
                fatherOqsEngineEntity.setId(oqsEngineEntity.getId());
                fatherOqsEngineEntity.setAttributes(fatherAttributes);
                Tuple2<Boolean, String> writeSegmentIndex = this.getWriteSegmentIndex(profile, oqsEngineEntity.getAttributes(), fatherEntities);
                if (!((Boolean)writeSegmentIndex._1).booleanValue()) {
                    return;
                }
                String segmentIndex = (String)writeSegmentIndex._2;
                List<OqsEngineEntity> fatherOqsEngineEntities = finalTenantEngineEntities.putIfAbsent(segmentIndex, defaultFatherEntities);
                fatherOqsEngineEntities = fatherOqsEngineEntities == null ? defaultFatherEntities : fatherOqsEngineEntities;
                fatherOqsEngineEntities.add(fatherOqsEngineEntity);
            }
        }
    }

    private void buildWideAttributes(OqsEngineEntity oqsEngineEntity, IEntityClass iEntityClass, Map<String, List<OqsEngineEntity>> tenantEngineEntities) throws CloneNotSupportedException {
        this.generateRelationOqsEngine(oqsEngineEntity, iEntityClass, tenantEngineEntities);
    }

    private void generateRelationOqsEngine(OqsEngineEntity oqsEngineEntity, IEntityClass iEntityClass, Map<String, List<OqsEngineEntity>> engineEntities) throws CloneNotSupportedException {
        List toOneRelatedList = oqsEngineEntity.getToOneRelatedList();
        String profile = oqsEngineEntity.getEntityClassRef().getProfile();
        HashMap relationAttributesMap = new HashMap();
        String prefixCode = iEntityClass.code();
        Collection cdcRelation = iEntityClass.relations();
        toOneRelatedList.forEach(tuple4 -> {
            Map cfr_ignored_0 = (Map)relationAttributesMap.put(((Tuple2)tuple4._4)._1, ((Tuple2)tuple4._4)._2);
        });
        if (!cdcRelation.isEmpty()) {
            for (IRelation iRelation : cdcRelation) {
                Collection reverseRelations;
                List reversedRelation;
                IEntityClass relatedEntityClass = (IEntityClass)this.entityClassEngine.load(String.valueOf(iRelation.getEntityClassId()), profile).get();
                if (!StringUtils.equalsIgnoreCase((String)iRelation.getRelationType(), (String)"TO_ONE") || !this.manageBocpMetadataService.checkPassage(profile, relatedEntityClass) || (reversedRelation = (reverseRelations = relatedEntityClass.relations()).stream().filter(x -> x.getEntityClassId() == iEntityClass.id()).collect(Collectors.toList())).isEmpty()) continue;
                String iRelationName = iRelation.getName();
                String relationIdName = iRelationName.concat("_").concat("id");
                Object relationIdVal = oqsEngineEntity.getAttributes().get(relationIdName);
                if (relationIdVal == null || !StringUtils.isNotEmpty((String)String.valueOf(relationIdVal))) continue;
                String value = String.valueOf(relationIdVal);
                OqsEngineEntity.Builder builder = (OqsEngineEntity.Builder)oqsEngineEntity.clone();
                OqsEngineEntity wideOqsEngineEntity = builder.build();
                Tuple2<Boolean, String> writeSegmentIndex = this.getWriteSegmentIndex(profile, (Map)relationAttributesMap.get(iRelation.getEntityClassId()), relatedEntityClass);
                if (!((Boolean)writeSegmentIndex._1).booleanValue()) continue;
                String indexName = (String)writeSegmentIndex._2;
                HashMap attributes = new HashMap();
                if (wideOqsEngineEntity.getAttributes().containsKey(prefixCode.concat("_").concat("join"))) {
                    wideOqsEngineEntity.getAttributes().remove(prefixCode.concat("_").concat("join"));
                }
                wideOqsEngineEntity.getAttributes().keySet().stream().forEach(key -> {
                    if (StringUtils.equalsIgnoreCase((String)"id", (String)key)) {
                        attributes.put((String)key, wideOqsEngineEntity.getAttributes().get(key));
                    }
                    attributes.put(prefixCode.concat(".").concat((String)key), wideOqsEngineEntity.getAttributes().get(key));
                });
                HashMap<String, String> relationMap = new HashMap<String, String>();
                relationMap.put("name", iRelationName);
                relationMap.put("parent", value);
                attributes.put(relatedEntityClass.code().concat("_join"), relationMap);
                wideOqsEngineEntity.setAttributes(attributes);
                wideOqsEngineEntity.setRoutingId(value);
                this.commondBuildWideRow(wideOqsEngineEntity, engineEntities, indexName);
            }
        }
    }

    private Tuple2<Boolean, String> getWriteSegmentIndex(String profile, Map<String, Object> attribute, IEntityClass iEntityClass) {
        try {
            String indexName = this.manageBocpMetadataService.getWriteSegmentIndex(profile, iEntityClass, attribute);
            return new Tuple2((Object)true, (Object)indexName);
        }
        catch (Exception e) {
            log.warn(e.getMessage());
            return new Tuple2((Object)false, null);
        }
    }

    private void parentIdQueryDelete(OqsEngineEntity oqsEngineEntity, IEntityClass relationClass, IEntityClass iEntityClass, String profile) {
        try {
            String indexName = DynamicConfigUtils.insulateTenant(this.dynamicConfig, profile, iEntityClass.code(), iEntityClass.ref().getAppCode());
            ParentIdQueryBuilder parentIdQuery = JoinQueryBuilders.parentId((String)relationClass.code(), (String)String.valueOf(oqsEngineEntity.getId()));
            DeleteByQueryRequest deleteByQueryRequest = new DeleteByQueryRequest();
            deleteByQueryRequest.setRouting(String.valueOf(oqsEngineEntity.getId()));
            deleteByQueryRequest.setQuery((QueryBuilder)parentIdQuery);
            deleteByQueryRequest.indices(new String[]{indexName});
            deleteByQueryRequest.setConflicts("proceed");
            RestHighLevelClient executor = ((ElasticsearchTransportExecutor)this.elasticsearchTransportExecutor).executor(profile);
            BulkByScrollResponse deleteResponse = null;
            deleteResponse = executor.deleteByQuery(deleteByQueryRequest, RequestOptions.DEFAULT);
            if (deleteResponse.getDeleted() >= 1L) {
                log.info("delete parent-child \u5197\u4f59\u660e\u7ec6\u660e\u7ec6\u6587\u6863\u6210\u7acb,\u5220\u9664\u6587\u6863\u6761\u6570: " + deleteResponse.getDeleted() + ",indexName\uff1a" + indexName);
            }
        }
        catch (Throwable e) {
            log.error("FAILURE,elasticsearch parentIdQueryDelete method failed,cause by:{}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    private void commondBuildWideRow(OqsEngineEntity oqsEngineEntity, Map<String, List<OqsEngineEntity>> tenantEngineEntities, String indexName) {
        ArrayList defaultChildEntities = new ArrayList();
        List<OqsEngineEntity> oqsEngineEntities = tenantEngineEntities.putIfAbsent(indexName, defaultChildEntities);
        oqsEngineEntities = oqsEngineEntities == null ? defaultChildEntities : oqsEngineEntities;
        oqsEngineEntities.add(oqsEngineEntity);
    }

    private Boolean deleteBatch(List<OqsEngineEntity> oqsEngineEntitys) throws IOException {
        HashMap<String, List<BulkRequest>> tenantBulkRequests = new HashMap<String, List<BulkRequest>>();
        this.handleTenantsBatchRows(oqsEngineEntitys).entrySet().stream().forEach(tenantEngineEntitys -> {
            ArrayList bulkRequests = new ArrayList();
            ((Map)tenantEngineEntitys.getValue()).entrySet().stream().forEach(oqsEngineEntities -> {
                BulkRequest bulkRequest = new BulkRequest();
                ((List)oqsEngineEntities.getValue()).forEach(oqsEngineEntity -> {
                    DeleteRequest deleteRequest = new DeleteRequest((String)oqsEngineEntities.getKey()).id(String.valueOf(oqsEngineEntity.getId()));
                    if (oqsEngineEntity.getRoutingId() != null) {
                        deleteRequest.routing(oqsEngineEntity.getRoutingId());
                    }
                    bulkRequest.add(deleteRequest);
                });
                bulkRequests.add(bulkRequest);
            });
            tenantBulkRequests.put((String)tenantEngineEntitys.getKey(), bulkRequests);
        });
        return this.sumbitBulk(tenantBulkRequests);
    }
}

