/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.adapter.elasticsearch.service.impl;

import akka.japi.function.Procedure;
import akka.stream.ActorMaterializer;
import akka.stream.Materializer;
import akka.stream.javadsl.Source;
import com.google.common.collect.Sets;
import com.xforceplus.ultraman.adapter.elasticsearch.CustomElasticSearchTransport;
import com.xforceplus.ultraman.adapter.elasticsearch.query.dto.ElasticTenantProfile;
import com.xforceplus.ultraman.adapter.elasticsearch.query.po.BocpElasticConfigPo;
import com.xforceplus.ultraman.adapter.elasticsearch.service.IndexOperation;
import com.xforceplus.ultraman.adapter.elasticsearch.service.ManageBocpMetadataService;
import com.xforceplus.ultraman.adapter.elasticsearch.service.constant.SegmentFieldType;
import com.xforceplus.ultraman.adapter.elasticsearch.service.constant.SegmentIndexRule;
import com.xforceplus.ultraman.adapter.elasticsearch.service.impl.ElasticSearchServiceImpl;
import com.xforceplus.ultraman.adapter.elasticsearch.service.utils.BocpMetabaseCacheUtils;
import com.xforceplus.ultraman.adapter.elasticsearch.utils.DynamicConfigUtils;
import com.xforceplus.ultraman.cdc.utils.TimeWaitUtils;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.sdk.core.datasource.route.dynamic.config.DynamicConfig;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ApplicationContext;

public class ManageBocpMetadataServiceImpl
implements ManageBocpMetadataService,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(ManageBocpMetadataServiceImpl.class);
    @Autowired
    private IndexOperation engineAdapterService;
    @Autowired
    private DynamicConfig dynamicConfig;
    @Resource
    private ApplicationContext applicationContext;
    @Autowired
    private CustomElasticSearchTransport customElasticSearchTransport;
    @Autowired
    private IndexOperation indexOperation;
    @Autowired
    private EntityClassEngine entityClassEngine;
    @Autowired
    private ActorMaterializer mat;
    private static int TICK = 0;
    private volatile boolean loadFinish = false;

    public void setEngineAdapterService(IndexOperation engineAdapterService) {
        this.engineAdapterService = engineAdapterService;
        if (engineAdapterService instanceof ElasticSearchServiceImpl) {
            ((ElasticSearchServiceImpl)((Object)engineAdapterService)).setManageBocpMetadataService(this);
        }
    }

    public void setDynamicConfig(DynamicConfig dynamicConfig) {
        this.dynamicConfig = dynamicConfig;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setCustomElasticSearchTransport(CustomElasticSearchTransport customElasticSearchTransport) {
        this.customElasticSearchTransport = customElasticSearchTransport;
    }

    public void setEntityClassEngine(EntityClassEngine entityClassEngine) {
        this.entityClassEngine = entityClassEngine;
    }

    @Override
    public void updateMetadataCache(Collection<ElasticTenantProfile> elasticTenantProfiles, IEntityClass iEntityClass, List<Tuple2<String, String>> errors) {
        try {
            if (elasticTenantProfiles.isEmpty()) {
                String profile = "default";
                String indexName = this.getIndexName(profile, iEntityClass);
                this.createOrUpdateIndexMapping(errors, iEntityClass, profile, indexName);
                BocpElasticConfigPo bocpElasticConfigPo = BocpElasticConfigPo.builder().enableSegment(false).enableSync(true).entityClassCode(iEntityClass.code()).entityClassId(iEntityClass.id()).tenantCode(profile).build();
                HashMap<String, String> currentSegmentIndexs = new HashMap<String, String>();
                currentSegmentIndexs.put(indexName, indexName);
                this.updateMetadataCache(iEntityClass, profile, currentSegmentIndexs, bocpElasticConfigPo);
            } else {
                elasticTenantProfiles.stream().forEach(tenantProfile -> {
                    if (!StringUtils.isEmpty((String)tenantProfile.getTenantCode())) {
                        String profile = tenantProfile.getTenantCode();
                        String indexName = this.genBaseIndexName(profile, iEntityClass);
                        SegmentIndexRule segmentIndexRule = null;
                        HashMap<String, String> currentSegmentIndexs = new HashMap<String, String>();
                        if (tenantProfile.isEnableSegment()) {
                            segmentIndexRule = this.getSegmentIndexRule(tenantProfile.getSegmentRule().toLowerCase(Locale.ROOT));
                            String expression = this.getSegmentMatch(indexName, segmentIndexRule);
                            Set<String> matchIndexs = this.customElasticSearchTransport.getMatchIndexs(indexName, tenantProfile.getTenantCode(), errors);
                            for (String matchIndex : matchIndexs) {
                                Pattern pattern = Pattern.compile(expression, 2);
                                Matcher matcher = pattern.matcher(matchIndex);
                                if (!matcher.matches()) continue;
                                this.createOrUpdateIndexMapping(errors, iEntityClass, profile, matchIndex);
                                currentSegmentIndexs.put(matcher.group(1), matchIndex);
                            }
                        } else {
                            indexName = this.getIndexName(profile, iEntityClass);
                            this.createOrUpdateIndexMapping(errors, iEntityClass, profile, indexName);
                            currentSegmentIndexs.put(indexName, indexName);
                        }
                        BocpElasticConfigPo bocpElasticConfigPo = BocpElasticConfigPo.builder().enableSegment(tenantProfile.isEnableSegment()).enableSync(true).segmentFieldName(tenantProfile.getSegmentField()).entityClassCode(iEntityClass.code()).entityClassId(iEntityClass.id()).segmentDateFormat(tenantProfile.getSegmentDateFormat()).segmentRule(segmentIndexRule).segmentFieldType(this.getSegmentFieldType(tenantProfile.getSegmentFieldType(), tenantProfile.getSegmentDateFormat())).tenantCode(profile).build();
                        this.updateMetadataCache(iEntityClass, profile, currentSegmentIndexs, bocpElasticConfigPo);
                    }
                });
            }
        }
        catch (Throwable e) {
            errors.add((Tuple2<String, String>)new Tuple2((Object)String.valueOf(iEntityClass.id()), (Object)e.getMessage()));
        }
    }

    private String genBaseIndexName(String tenantProfile, IEntityClass iEntityClass) {
        if (StringUtils.isEmpty((String)tenantProfile) || "default".equalsIgnoreCase(tenantProfile)) {
            return iEntityClass.ref().getAppCode().concat("_").concat(iEntityClass.code()).toLowerCase();
        }
        return tenantProfile.concat("_").concat(iEntityClass.ref().getAppCode()).concat("_").concat(iEntityClass.code()).toLowerCase();
    }

    private void updateMetadataCache(IEntityClass iEntityClass, String profile, Map<String, String> currentSegmentIndexs, BocpElasticConfigPo bocpElasticConfigPo) {
        if (BocpMetabaseCacheUtils.getExactlyIndexMapping(profile) != null) {
            BocpMetabaseCacheUtils.getExactlyIndexMapping(profile).put(iEntityClass.id(), currentSegmentIndexs);
        } else {
            HashMap<Long, Map<String, String>> segmentIndex = new HashMap<Long, Map<String, String>>();
            segmentIndex.put(iEntityClass.id(), currentSegmentIndexs);
            BocpMetabaseCacheUtils.putIndexMapping(profile, segmentIndex);
        }
        if (BocpMetabaseCacheUtils.getExactlyBocpConfig(profile) != null) {
            BocpMetabaseCacheUtils.getExactlyBocpConfig(profile).put(iEntityClass.id(), bocpElasticConfigPo);
        } else {
            HashMap<Long, BocpElasticConfigPo> segmentBocpConfig = new HashMap<Long, BocpElasticConfigPo>();
            segmentBocpConfig.put(iEntityClass.id(), bocpElasticConfigPo);
            BocpMetabaseCacheUtils.putBocpConfig(profile, segmentBocpConfig);
        }
    }

    @NotNull
    private String getIndexName(String tenantProfile, IEntityClass iEntityClass) {
        BocpElasticConfigPo bocpElasticConfigPo;
        String dynamicAwareIndexName = DynamicConfigUtils.insulateTenant(this.dynamicConfig, tenantProfile, iEntityClass.code(), iEntityClass.ref().getAppCode());
        if (dynamicAwareIndexName != null && dynamicAwareIndexName.toLowerCase().contains(tenantProfile.toLowerCase())) {
            return dynamicAwareIndexName;
        }
        Map<Long, BocpElasticConfigPo> exactlyBocpConfig = BocpMetabaseCacheUtils.getExactlyBocpConfig(tenantProfile);
        if (exactlyBocpConfig != null && (bocpElasticConfigPo = exactlyBocpConfig.get(iEntityClass.id())) != null) {
            if (StringUtils.isEmpty((String)tenantProfile) || "default".equalsIgnoreCase(tenantProfile)) {
                return iEntityClass.ref().getAppCode().concat("_").concat(iEntityClass.code()).toLowerCase();
            }
            return tenantProfile.concat("_").concat(iEntityClass.ref().getAppCode()).concat("_").concat(iEntityClass.code()).toLowerCase();
        }
        return dynamicAwareIndexName;
    }

    @Nullable
    private String getSegmentMatch(String indexName, SegmentIndexRule segmentIndexRule) {
        String expression;
        switch (segmentIndexRule) {
            case QUARTER: {
                expression = "^".concat(indexName).concat(String.format("_(\\d{4}_\\d{1}_%s)$", SegmentIndexRule.QUARTER.getSegmentRuleName()));
                break;
            }
            default: {
                expression = "^".concat(indexName).concat(String.format("_(\\d{4}_%s)$", SegmentIndexRule.YEAR.getSegmentRuleName()));
            }
        }
        return expression;
    }

    @Override
    public List<String> getEntityClassMappingIndexs(String profile, IEntityClass iEntityClass) {
        ArrayList<String> indexs = new ArrayList<String>();
        if (BocpMetabaseCacheUtils.getBocpConfig(profile = this.getProfile(profile)) != null && BocpMetabaseCacheUtils.getBocpConfig(profile).get(iEntityClass.id()) != null) {
            if (BocpMetabaseCacheUtils.getIndexMapping(profile) != null && BocpMetabaseCacheUtils.getIndexMapping(profile).get(iEntityClass.id()) != null) {
                Map<String, String> segmentIndexs = BocpMetabaseCacheUtils.getIndexMapping(profile).get(iEntityClass.id());
                indexs = new ArrayList<String>(segmentIndexs.values());
            }
        } else {
            indexs.add(this.getIndexName(profile, iEntityClass));
        }
        return indexs;
    }

    @Override
    public boolean checkPassage(String profile, IEntityClass iEntityClass) {
        this.loadFinish();
        String targetProfile = this.getProfile(profile);
        Map<Long, BocpElasticConfigPo> bocpConfig = BocpMetabaseCacheUtils.getBocpConfig(targetProfile);
        if (bocpConfig != null) {
            Map<Long, BocpElasticConfigPo> defaultConfig;
            BocpElasticConfigPo targetConfig = bocpConfig.get(iEntityClass.id());
            if (targetConfig == null && !"default".equalsIgnoreCase(targetProfile) && (defaultConfig = BocpMetabaseCacheUtils.getBocpConfig("default")) != null) {
                targetConfig = defaultConfig.get(iEntityClass.id());
            }
            return targetConfig != null;
        }
        return false;
    }

    private boolean loadFinish() {
        while (!this.loadFinish) {
            TimeWaitUtils.wakeupAfter((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        return this.loadFinish;
    }

    private SegmentFieldType getSegmentFieldType(String segmentFiledType, String dateFormat) {
        SegmentFieldType fieldType;
        if (StringUtils.isEmpty((String)segmentFiledType)) {
            return null;
        }
        if (StringUtils.isEmpty((String)segmentFiledType) && StringUtils.isNotEmpty((String)dateFormat)) {
            fieldType = SegmentFieldType.STRING;
        } else {
            switch (segmentFiledType) {
                case "string": {
                    fieldType = SegmentFieldType.STRING;
                    break;
                }
                default: {
                    fieldType = SegmentFieldType.BIGINT;
                }
            }
        }
        return fieldType;
    }

    private SegmentIndexRule getSegmentIndexRule(String segmentRule) {
        SegmentIndexRule indexRule;
        switch (segmentRule) {
            case "quarter": {
                indexRule = SegmentIndexRule.QUARTER;
                break;
            }
            default: {
                indexRule = SegmentIndexRule.YEAR;
            }
        }
        return indexRule;
    }

    @Override
    public void buildRedundantFields(String profile, IEntityClass iEntityClass, String indexName, List<Tuple2<String, String>> errors) {
        HashSet<String> relations = new HashSet<String>();
        iEntityClass.relations().forEach(iRelation -> {
            IEntityClass relationEntityClass = (IEntityClass)this.entityClassEngine.load(String.valueOf(iRelation.getEntityClassId()), profile).get();
            if (!StringUtils.equalsIgnoreCase((String)iEntityClass.code(), (String)relationEntityClass.code())) {
                String prefixName = iRelation.getName();
                Collection appendFields = this.entityClassEngine.describe(relationEntityClass, profile).getAllFields();
                if (this.engineAdapterService.indexExists(indexName, profile)) {
                    this.logInfo(this.engineAdapterService.putMapping(indexName, appendFields, prefixName, profile), iEntityClass, errors, "related code error");
                    relations.add(iRelation.getName());
                }
            }
        });
        if (relations.size() > 0 || relations.size() > 0) {
            this.logInfo(this.engineAdapterService.joinMapping(indexName, relations, iEntityClass.code(), profile), iEntityClass, errors, "relations is not well build");
        }
    }

    @Override
    public void createOrUpdateIndexMapping(List<Tuple2<String, String>> errors, IEntityClass iEntityClass, String profile, String indexName) {
        try {
            Collection allFields = this.entityClassEngine.describe(iEntityClass, profile).getAllFields();
            boolean indexAndCreateMapping = this.engineAdapterService.indexExists(indexName, profile) ? this.engineAdapterService.putMapping(indexName, allFields, null, profile) : this.engineAdapterService.createIndexAndCreateMapping(indexName, allFields, profile);
            if (!indexAndCreateMapping) {
                errors.add((Tuple2<String, String>)new Tuple2((Object)iEntityClass.code(), (Object)String.format("elasticsearch execute createOrUpdateIndexMapping method exception,index:%s", indexName)));
            }
            this.buildRedundantFields(profile, iEntityClass, indexName, errors);
        }
        catch (Throwable e) {
            this.logInfo(false, iEntityClass, errors, e.getMessage());
        }
    }

    @Override
    public String getWriteSegmentIndex(String profile, IEntityClass iEntityClass, Map<String, Object> attribute) {
        this.loadFinish();
        try {
            profile = this.getProfile(profile);
            if (BocpMetabaseCacheUtils.getBocpConfig(profile) != null) {
                Map<Long, BocpElasticConfigPo> targetConfig;
                BocpElasticConfigPo bocpElasticConfigPo = BocpMetabaseCacheUtils.getBocpConfig(profile).get(iEntityClass.id());
                if (bocpElasticConfigPo == null && !"default".equalsIgnoreCase(profile) && (targetConfig = BocpMetabaseCacheUtils.getBocpConfig("default")) != null) {
                    bocpElasticConfigPo = targetConfig.get(iEntityClass.id());
                }
                Map existeSegmentIndexs = Optional.ofNullable(this.getSegmentIndexMapping(profile, iEntityClass)).orElseGet(HashMap::new);
                if (bocpElasticConfigPo.isEnableSegment()) {
                    SegmentIndexRule segmentRule = bocpElasticConfigPo.getSegmentRule();
                    Object segmentFiledValue = attribute.get(bocpElasticConfigPo.getSegmentFieldName());
                    SegmentFieldType segmentFieldType = bocpElasticConfigPo.getSegmentFieldType();
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(this.dateFormat(bocpElasticConfigPo, segmentFiledValue, segmentFieldType));
                    String suffixDataFormat = this.indexSuffixMatch(segmentRule, calendar);
                    if (existeSegmentIndexs.keySet().contains(suffixDataFormat)) {
                        return (String)existeSegmentIndexs.get(suffixDataFormat);
                    }
                    return this.createSegmentIndex(profile, iEntityClass, existeSegmentIndexs, suffixDataFormat);
                }
                if (!bocpElasticConfigPo.isEnableSegment() && existeSegmentIndexs.size() == 1) {
                    return (String)existeSegmentIndexs.values().stream().findFirst().get();
                }
                this.createSegmentIndex(profile, iEntityClass, existeSegmentIndexs, null);
            }
            return this.getIndexName(profile, iEntityClass);
        }
        catch (Exception e) {
            log.info(e.getMessage());
            throw e;
        }
    }

    @NotNull
    private String createSegmentIndex(String profile, IEntityClass iEntityClass, Map<String, String> existeSegmentIndexs, String suffixDataFormat) {
        ArrayList<Tuple2<String, String>> errors = new ArrayList<Tuple2<String, String>>();
        String indexName = this.getIndexName(profile, iEntityClass);
        if (StringUtils.isNotEmpty((String)suffixDataFormat)) {
            indexName = indexName.concat("_").concat(suffixDataFormat);
        }
        this.createOrUpdateIndexMapping(errors, iEntityClass, profile, indexName);
        if (errors.size() == 0) {
            Map<String, String> cacheIndexMapping;
            if (StringUtils.isEmpty((String)suffixDataFormat)) {
                suffixDataFormat = indexName;
            }
            existeSegmentIndexs.put(suffixDataFormat, indexName);
            Map<Long, Map<String, String>> indexMapping = BocpMetabaseCacheUtils.getIndexMapping(profile);
            if (indexMapping == null) {
                indexMapping = new HashMap<Long, Map<String, String>>();
                BocpMetabaseCacheUtils.putIndexMapping(profile, indexMapping);
            }
            if ((cacheIndexMapping = indexMapping.get(iEntityClass.id())) != null) {
                existeSegmentIndexs.entrySet().forEach(entry -> {
                    String cfr_ignored_0 = (String)cacheIndexMapping.put((String)entry.getKey(), (String)entry.getValue());
                });
            } else {
                indexMapping.put(iEntityClass.id(), existeSegmentIndexs);
            }
            return indexName;
        }
        String printErrors = this.errorsBuild(errors).toString();
        log.error("FAILURE:cdc sync elstic execute getSegmentIndex mehtod failed,cause by:", (Object)printErrors);
        throw new RuntimeException(printErrors);
    }

    @NotNull
    private String indexSuffixMatch(SegmentIndexRule segmentRule, Calendar calendar) {
        String suffixDataFormat;
        switch (segmentRule) {
            case QUARTER: {
                suffixDataFormat = String.valueOf(calendar.get(1)).concat("_").concat(String.valueOf((calendar.get(2) + 2) / 3)).concat("_").concat(SegmentIndexRule.QUARTER.getSegmentRuleName());
                break;
            }
            default: {
                suffixDataFormat = String.valueOf(calendar.get(1)).concat("_").concat(SegmentIndexRule.YEAR.getSegmentRuleName());
            }
        }
        return suffixDataFormat;
    }

    @Override
    public Tuple2<String, String> getSearchSegmentIndex(String profile, String entityClassCode) {
        String indexName;
        IEntityClass iEntityClass = (IEntityClass)this.entityClassEngine.loadByCode(entityClassCode, profile).get();
        Map<Long, BocpElasticConfigPo> bocpConfig = BocpMetabaseCacheUtils.getBocpConfig(this.getProfile(profile));
        String segmentIndex = indexName = this.getIndexName(profile, iEntityClass);
        Map<Long, Map<String, String>> indexMapping = BocpMetabaseCacheUtils.getIndexMapping(this.getProfile(profile));
        if (bocpConfig != null) {
            Map<Long, BocpElasticConfigPo> defaultBOCPConfig;
            BocpElasticConfigPo targetPo = bocpConfig.get(iEntityClass.id());
            if (targetPo == null && !"default".equalsIgnoreCase(profile) && (defaultBOCPConfig = BocpMetabaseCacheUtils.getBocpConfig("default")) != null) {
                targetPo = defaultBOCPConfig.get(iEntityClass.id());
            }
            if (targetPo == null) {
                throw new RuntimeException("The synchronization information of the index is not configured in the bocp configuration. Therefore, the query is not supported");
            }
            HashMap<String, String> emptyMap = new HashMap<String, String>();
            if (targetPo.isEnableSegment()) {
                SegmentIndexRule segmentRule = targetPo.getSegmentRule();
                String suffixDataFormat = this.indexSuffixMatch(segmentRule, Calendar.getInstance());
                if (indexMapping == null || indexMapping.get(iEntityClass.id()) == null) {
                    segmentIndex = this.createSegmentIndex(profile, iEntityClass, emptyMap, suffixDataFormat);
                } else {
                    Optional<String> segmentIndexOp = indexMapping.get(iEntityClass.id()).values().stream().findFirst();
                    if (segmentIndexOp.isPresent()) {
                        segmentIndex = segmentIndexOp.get();
                    } else {
                        return new Tuple2((Object)indexName, (Object)"$TEMP$");
                    }
                }
                switch (segmentRule) {
                    case YEAR: {
                        indexName = indexName.concat("*_").concat(SegmentIndexRule.YEAR.getSegmentRuleName());
                        break;
                    }
                    case QUARTER: {
                        indexName = indexName.concat("*_").concat(SegmentIndexRule.QUARTER.getSegmentRuleName());
                    }
                }
            } else {
                Map<String, String> segmentIndexMapping = indexMapping.get(iEntityClass.id());
                segmentIndex = segmentIndexMapping != null ? segmentIndexMapping.get(indexName) : this.createSegmentIndex(profile, iEntityClass, emptyMap, null);
            }
        } else {
            throw new RuntimeException("The synchronization information of the index is not configured in the bocp configuration. Therefore, the query is not supported");
        }
        return new Tuple2((Object)indexName, (Object)segmentIndex);
    }

    @Override
    public String getIndexPrefix(String profile, String appCode) {
        return DynamicConfigUtils.insulateTenant(this.dynamicConfig, profile, appCode);
    }

    @NotNull
    private String getProfile(String profile) {
        if (StringUtils.isEmpty((String)profile)) {
            profile = "default";
        }
        return profile;
    }

    private Map<String, String> getSegmentIndexMapping(String profile, IEntityClass iEntityClass) {
        if (BocpMetabaseCacheUtils.getIndexMapping(profile) != null) {
            return BocpMetabaseCacheUtils.getIndexMapping(profile).get(iEntityClass.id());
        }
        return null;
    }

    private Date dateFormat(BocpElasticConfigPo bocpElasticConfigPo, Object segmentFiledValue, SegmentFieldType segmentFieldType) {
        switch (segmentFieldType) {
            case BIGINT: {
                Long date = Long.valueOf(String.valueOf(segmentFiledValue));
                return new Date(date);
            }
            case STRING: {
                String dateStr = String.valueOf(segmentFiledValue);
                String dateFormat = this.verifyDateFormate(bocpElasticConfigPo);
                SimpleDateFormat formatter = new SimpleDateFormat(StringUtils.trim((String)dateFormat));
                try {
                    return formatter.parse(dateStr);
                }
                catch (ParseException e) {
                    log.error("FAILURE:bocp config parse exception,tenantCode:{},tenantCode:{},dataStr:{} formatter:{},cause by:{}", new Object[]{bocpElasticConfigPo.getTenantCode(), bocpElasticConfigPo.getEntityClassCode(), dateStr, formatter, e.getMessage()});
                    throw new RuntimeException(e.getMessage());
                }
            }
        }
        String error = String.format("FAILURE:bocp config parse exception,segmentFieldType:{%s} fileds not match bigint or string.", new Object[]{bocpElasticConfigPo.getSegmentFieldType()});
        log.error(error);
        throw new RuntimeException(error);
    }

    @NotNull
    private String verifyDateFormate(BocpElasticConfigPo bocpElasticConfigPo) {
        String dateFormat = "yyyy-mm-dd hh:mm:ss";
        switch (bocpElasticConfigPo.getSegmentDateFormat().toLowerCase()) {
            case "yyyy-mm-dd": {
                dateFormat = "yyyy-MM-dd";
                break;
            }
            case "yyyy-mm-dd hh:mm:ss": {
                dateFormat = "yyyy-MM-dd HH:mm:ss";
                break;
            }
            case "yyyy-mm-dd hh:mm:ss.sss": {
                dateFormat = "yyyy-MM-dd HH:mm:ss.SSS";
                break;
            }
            case "yyyymmdd": {
                dateFormat = "yyyyMMdd";
            }
        }
        return dateFormat;
    }

    public void logInfo(boolean status, IEntityClass iEntityClass, List<Tuple2<String, String>> errors, String message) {
        if (!status) {
            errors.add((Tuple2<String, String>)Tuple.of((Object)iEntityClass.code(), (Object)Optional.ofNullable(message).orElse("NullPoint Exception")));
        }
    }

    public void printErrors(List<Tuple2<String, String>> errors) {
        if (!errors.isEmpty()) {
            StringBuilder sb = this.errorsBuild(errors);
            log.error("FATAL --- elasticsearch index mapping modification or creation failure. {}{}", (Object)System.lineSeparator(), (Object)sb);
            int exitCode = SpringApplication.exit((ApplicationContext)this.applicationContext, (ExitCodeGenerator[])new ExitCodeGenerator[]{() -> 0});
            System.exit(exitCode);
        }
    }

    @NotNull
    private StringBuilder errorsBuild(List<Tuple2<String, String>> errors) {
        StringBuilder builder = new StringBuilder();
        errors.stream().forEach(x -> {
            String entityCode = (String)x._1;
            String reason = (String)x._2;
            builder.append(entityCode).append(":").append(reason).append("|").append(System.lineSeparator());
        });
        return builder;
    }

    @Override
    public void setLoadFinish(boolean loadFinish) {
        this.loadFinish = loadFinish;
    }

    @Override
    public boolean getLoadFinish() {
        return this.loadFinish();
    }

    @Override
    public void initSync() {
        Source.tick((Duration)Duration.ZERO, (Duration)Duration.ofSeconds(30L), (Object)TICK).runForeach((Procedure & Serializable)i -> {
            try {
                this.sync();
            }
            catch (Throwable throwable) {
                log.error("{}", throwable);
            }
        }, (Materializer)this.mat);
    }

    private void sync() {
        if (this.loadFinish) {
            log.debug("Start to Sync elasticsearch indics");
            List<String> bocpConfigAllKey = BocpMetabaseCacheUtils.getBocpConfigAllKey();
            HashMap searchMapping = new HashMap();
            bocpConfigAllKey.forEach(k -> {
                Map<Long, BocpElasticConfigPo> bocpConfig = BocpMetabaseCacheUtils.getBocpConfig(k);
                Set expectedIndics = bocpConfig.entrySet().stream().map(x -> {
                    Long key = (Long)x.getKey();
                    Optional targetOp = this.entityClassEngine.load(key.toString(), null);
                    if (targetOp.isPresent()) {
                        IEntityClass entityClass = (IEntityClass)targetOp.get();
                        boolean enableSegment = ((BocpElasticConfigPo)x.getValue()).isEnableSegment();
                        if (!enableSegment) {
                            Tuple2<String, String> searchSegmentIndex = this.getSearchSegmentIndex((String)k, entityClass.code());
                            searchMapping.put(searchSegmentIndex._1, Tuple.of((Object)k, (Object)entityClass));
                            return (String)searchSegmentIndex._1;
                        }
                    }
                    return null;
                }).filter(Objects::nonNull).collect(Collectors.toSet());
                Set<String> allIndic = this.indexOperation.getAllIndex((String)k);
                Sets.difference(expectedIndics, allIndic).forEach(x -> {
                    Tuple2 tuple = (Tuple2)searchMapping.get(x);
                    if (tuple != null) {
                        this.createSegmentIndex((String)tuple._1, (IEntityClass)tuple._2, new HashMap<String, String>(), null);
                    }
                });
            });
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.initSync();
    }
}

