/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.adapter.elasticsearch.service.utils;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.xforceplus.ultraman.adapter.elasticsearch.query.po.BocpElasticConfigPo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BocpMetabaseCacheUtils {
    private static final Logger log = LoggerFactory.getLogger(BocpMetabaseCacheUtils.class);
    private static final long GUAVA_CACHE_DAY = 15L;
    private static LoadingCache<String, Map<Long, Map<String, String>>> INDEX_MAPPING_CACHE = null;
    private static LoadingCache<String, Map<Long, BocpElasticConfigPo>> BOCP_CONFIG_CACHE = null;

    private static LoadingCache<String, Map<Long, Map<String, String>>> loadIndexMappingCache(CacheLoader<String, Map<Long, Map<String, String>>> cacheLoader) {
        LoadingCache cache = CacheBuilder.newBuilder().recordStats().build(cacheLoader);
        return cache;
    }

    private static LoadingCache<String, Map<Long, BocpElasticConfigPo>> loadBocpConfigCache(CacheLoader<String, Map<Long, BocpElasticConfigPo>> cacheLoader) {
        LoadingCache cache = CacheBuilder.newBuilder().recordStats().build(cacheLoader);
        return cache;
    }

    public static void putIndexMapping(String key, Map<Long, Map<String, String>> value) {
        try {
            INDEX_MAPPING_CACHE.put((Object)key, value);
        }
        catch (Exception e) {
            log.warn("\u8bbe\u7f6e\u7f13\u5b58\u503c\u51fa\u9519", (Throwable)e);
        }
    }

    public static void putBocpConfig(String key, Map<Long, BocpElasticConfigPo> value) {
        try {
            BOCP_CONFIG_CACHE.put((Object)key, value);
        }
        catch (Exception e) {
            log.warn("\u8bbe\u7f6e\u7f13\u5b58\u503c\u51fa\u9519", (Throwable)e);
        }
    }

    public static Map<Long, Map<String, String>> getIndexMapping(String key) {
        Map token = null;
        try {
            token = (Map)INDEX_MAPPING_CACHE.get((Object)key);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (token == null && !"default".equalsIgnoreCase(key)) {
            try {
                token = (Map)INDEX_MAPPING_CACHE.get((Object)"default");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return token;
    }

    public static Map<Long, Map<String, String>> getExactlyIndexMapping(String key) {
        Map token = null;
        try {
            token = (Map)INDEX_MAPPING_CACHE.get((Object)key);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return token;
    }

    public static Map<Long, BocpElasticConfigPo> getExactlyBocpConfig(String key) {
        Map token = null;
        try {
            token = (Map)BOCP_CONFIG_CACHE.get((Object)key);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return token;
    }

    public static Map<Long, BocpElasticConfigPo> getBocpConfig(String key) {
        Map token = null;
        try {
            token = (Map)BOCP_CONFIG_CACHE.get((Object)key);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (token == null && !"default".equalsIgnoreCase(key)) {
            try {
                token = (Map)BOCP_CONFIG_CACHE.get((Object)"default");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return token;
    }

    public static List<String> getIndexMappingAllKey() {
        try {
            return new ArrayList<String>(INDEX_MAPPING_CACHE.asMap().keySet());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static List<String> getBocpConfigAllKey() {
        try {
            return new ArrayList<String>(BOCP_CONFIG_CACHE.asMap().keySet());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void removeIndexMapping(String key) {
        try {
            INDEX_MAPPING_CACHE.invalidate((Object)key);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void removeBocpConfig(String key) {
        try {
            BOCP_CONFIG_CACHE.invalidate((Object)key);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void removeAllIndexMapping(Iterable<String> keys) {
        try {
            INDEX_MAPPING_CACHE.invalidateAll(keys);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void removeAllBocpConfig(Iterable<String> keys) {
        try {
            BOCP_CONFIG_CACHE.invalidateAll(keys);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void removeAllIndexMapping() {
        try {
            INDEX_MAPPING_CACHE.invalidateAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void removeAllBocpConfig() {
        try {
            BOCP_CONFIG_CACHE.invalidateAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static long indexMappngSize() {
        long size = 0L;
        try {
            size = INDEX_MAPPING_CACHE.size();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return size;
    }

    public static long bocpConfigSize() {
        long size = 0L;
        try {
            size = BOCP_CONFIG_CACHE.size();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return size;
    }

    static {
        try {
            INDEX_MAPPING_CACHE = BocpMetabaseCacheUtils.loadIndexMappingCache(new CacheLoader<String, Map<Long, Map<String, String>>>(){

                public Map<Long, Map<String, String>> load(String key) {
                    return null;
                }
            });
            BOCP_CONFIG_CACHE = BocpMetabaseCacheUtils.loadBocpConfigCache(new CacheLoader<String, Map<Long, BocpElasticConfigPo>>(){

                public Map<Long, BocpElasticConfigPo> load(String key) {
                    return null;
                }
            });
        }
        catch (Exception e) {
            log.error("\u521d\u59cb\u5316Guava Cache\u51fa\u9519", (Throwable)e);
        }
    }
}

