/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.adapter.elasticsearch.service.utils;

import com.xforceplus.ultraman.adapter.elasticsearch.service.constant.FieldMappingType;
import com.xforceplus.ultraman.adapter.elasticsearch.service.entity.FieldMapping;
import com.xforceplus.ultraman.metadata.entity.FieldConfig;
import com.xforceplus.ultraman.metadata.entity.FieldType;
import com.xforceplus.ultraman.metadata.entity.IEntityField;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.commons.lang.StringUtils;

public class ElasticSearchMappingBuildUtils {
    public static List<FieldMapping> getFieldInfos(final Collection<IEntityField> allFields) {
        List uniquify = SqlValidatorUtil.uniquify((List)new AbstractList<String>(){

            @Override
            public String get(int index) {
                return ((IEntityField)new ArrayList(allFields).get(index)).name().trim();
            }

            @Override
            public int size() {
                return new ArrayList(allFields).size();
            }
        }, (boolean)true);
        AtomicInteger index = new AtomicInteger(0);
        return allFields.stream().map(fieldInfo -> {
            String fieldName = (String)uniquify.get(index.get());
            FieldMapping build = fieldInfo.type().getJavaType().getSuperclass() == Number.class || fieldInfo.type().getJavaType() == Boolean.class ? FieldMapping.builder().field(fieldName).type(ElasticSearchMappingBuildUtils.getType(null, fieldInfo.type())).build() : FieldMapping.builder().field(fieldName).type(ElasticSearchMappingBuildUtils.getType(fieldInfo.config().getFuzzyType(), fieldInfo.type())).analyzer(FieldMappingType.SETANALYZER_IK_SMART.getType()).build();
            build.setOriginField((IEntityField)fieldInfo);
            index.getAndIncrement();
            return build;
        }).collect(Collectors.toList());
    }

    private static String getType(FieldConfig.FuzzyType fuzzyType, FieldType fieldType) {
        switch (fieldType) {
            case ENUM: 
            case STRING: {
                return ElasticSearchMappingBuildUtils.getStringType(fuzzyType, fieldType);
            }
            case BOOLEAN: {
                return FieldMappingType.BOOLEAN.getType();
            }
            case LONG: 
            case DATETIME: {
                return FieldMappingType.LONG.getType();
            }
            case DECIMAL: {
                return FieldMappingType.DOUBLE.getType();
            }
        }
        return FieldMappingType.KEYWORD.getType();
    }

    private static String getStringType(FieldConfig.FuzzyType fuzzyType, FieldType fieldType) {
        if (!Objects.isNull(fuzzyType)) {
            switch (fuzzyType) {
                case NOT: 
                case UNKNOWN: 
                case WILDCARD: {
                    if (StringUtils.equalsIgnoreCase((String)fieldType.getType(), (String)FieldType.STRING.getType())) {
                        return FieldMappingType.KEYWORD.getType();
                    }
                }
                case SEGMENTATION: {
                    if (!StringUtils.equalsIgnoreCase((String)fieldType.getType(), (String)FieldType.STRING.getType())) break;
                    return FieldMappingType.TEXT.getType();
                }
            }
            return FieldMappingType.KEYWORD.getType();
        }
        return FieldMappingType.KEYWORD.getType();
    }
}

