/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.adapter.elasticsearch.strategy;

import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.metadata.engine.EntityClassGroup;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.sdk.core.calcite.oqs.DataQueryProvider;
import com.xforceplus.ultraman.sdk.core.calcite.oqs.strategy.QueryProviderSelectStrategy;
import com.xforceplus.ultraman.sdk.core.config.CdcConfig;
import io.vavr.Tuple2;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.calcite.DataContext;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.StructKind;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.Pair;

public class ESQueryStrategy
implements QueryProviderSelectStrategy {
    private ContextService contextService;
    private CdcConfig cdcConfig;
    private EntityClassEngine engine;

    public ESQueryStrategy(ContextService contextService, EntityClassEngine engine, CdcConfig cdcConfig) {
        this.contextService = contextService;
        this.cdcConfig = cdcConfig;
        this.engine = engine;
    }

    public String name() {
        return "elasticsearch";
    }

    public Map<DataQueryProvider, Double> score(String s, IEntityClass iEntityClass, String s1, RelDataType relDataType, List<RexNode> list, List<Map.Entry<String, Tuple2<StructKind, Class>>> list1, List<Pair<RexNode, String>> list2, List<Map.Entry<String, RelFieldCollation.Direction>> list3, Long aLong, Long aLong1, List<String> list4, List<AggregateCall> list5, List<RelHint> list6, RelNode relNode, DataContext dataContext, List<DataQueryProvider> dataQueryProviders) {
        HashMap<DataQueryProvider, Double> map = new HashMap<DataQueryProvider, Double>();
        Object page = this.contextService.getAll().get("PAGE");
        EntityClassGroup group = this.engine.describe(iEntityClass, "");
        dataQueryProviders.stream().filter(x -> x.type() == DataQueryProvider.QueryProviderType.INDEX).forEach(x -> {
            if (!this.cdcConfig.getInclude().isEmpty()) {
                List includeList = this.cdcConfig.getInclude();
                if (includeList.stream().anyMatch(code -> this.isAccept(group, (String)code))) {
                    map.put((DataQueryProvider)x, 10.0);
                } else {
                    map.put((DataQueryProvider)x, -10.0);
                }
            } else if (!this.cdcConfig.getExclude().isEmpty()) {
                List excludeList = this.cdcConfig.getExclude();
                if (excludeList.stream().anyMatch(code -> this.isAccept(group, (String)code))) {
                    map.put((DataQueryProvider)x, -10.0);
                } else {
                    map.put((DataQueryProvider)x, 10.0);
                }
            } else if (page != null) {
                map.put((DataQueryProvider)x, 1.0);
            }
        });
        return map;
    }

    private boolean isAccept(EntityClassGroup group, String code) {
        Set fatherCodes = group.getFatherEntityClass().stream().map(IEntityClass::code).collect(Collectors.toSet());
        return group.getEntityClass().code().equalsIgnoreCase(code) || fatherCodes.contains(code);
    }
}

