/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.adapter.elasticsearch.transport;

import com.typesafe.config.Config;
import com.xforceplus.ultraman.sdk.core.datasource.PackageInternal;
import com.xforceplus.ultraman.sdk.core.datasource.SupportClientType;
import com.xforceplus.ultraman.sdk.core.datasource.resolver.DataConfigResolver;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;

public class ElasticIndexResolver
implements DataConfigResolver {
    private static PackageInternal buildRestHighLevelClient(List<Config> configs, boolean showSql) {
        RestHighLevelClient first = null;
        String name = SupportClientType.INDEX_DB.getName() + "-" + 0;
        LinkedHashMap<String, RestHighLevelClient> ds = new LinkedHashMap<String, RestHighLevelClient>(configs.size());
        for (int i = 0; i < configs.size(); ++i) {
            String dsName = SupportClientType.INDEX_DB.getName() + "-" + i;
            RestHighLevelClient restHighLevelClient = ElasticIndexResolver.buildRestHighLevelClient(configs.get(i));
            if (i == 0) {
                first = restHighLevelClient;
            }
            ds.put(dsName, restHighLevelClient);
        }
        return new PackageInternal(name, first, ds);
    }

    private static RestHighLevelClient buildRestHighLevelClient(Config config) {
        RestClientBuilder restClientBuilder = RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(config.getString("host"), config.getInt("port"))}).setRequestConfigCallback(requestConfigBuilder -> requestConfigBuilder.setConnectTimeout(config.getInt("connectTimeout")).setSocketTimeout(config.getInt("socketTimeout"))).setHttpClientConfigCallback(httpAsyncClientBuilder -> httpAsyncClientBuilder);
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        String userName = config.getString("username");
        String password = config.getString("password");
        if (null != userName && !userName.isEmpty() && null != password && !password.isEmpty()) {
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(config.getString("username"), config.getString("password")));
        }
        restClientBuilder.setHttpClientConfigCallback(arg_0 -> ElasticIndexResolver.lambda$buildRestHighLevelClient$2((CredentialsProvider)credentialsProvider, arg_0));
        return new RestHighLevelClient(restClientBuilder);
    }

    public Tuple2<String, PackageInternal> resolve(Config config) {
        PackageInternal indexPackageInternal = null;
        indexPackageInternal = config.hasPath(SupportClientType.INDEX_DB.getPath()) ? ElasticIndexResolver.buildRestHighLevelClient(config.getConfigList(SupportClientType.INDEX_DB.getPath()), true) : PackageInternal.emptyPackage();
        return Tuple.of((Object)"index", (Object)indexPackageInternal);
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$buildRestHighLevelClient$2(CredentialsProvider credentialsProvider, HttpAsyncClientBuilder httpAsyncClientBuilder) {
        httpAsyncClientBuilder.setMaxConnPerRoute(1000);
        httpAsyncClientBuilder.setMaxConnTotal(10000);
        httpAsyncClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
        return httpAsyncClientBuilder;
    }
}

