/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.adapter.elasticsearch.transport;

import com.xforceplus.ultraman.sdk.core.datasource.DataSourcePackage;
import com.xforceplus.ultraman.sdk.core.datasource.route.TransportExecutor;
import com.xforceplus.ultraman.sdk.core.datasource.route.dynamic.RouteMappingProvider;
import io.vavr.Tuple2;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.client.RestHighLevelClient;

public class ElasticsearchTransportExecutor
implements TransportExecutor<RestHighLevelClient> {
    private DataSourcePackage dataSourcePackage;
    private RouteMappingProvider routeMappingProvider;

    public ElasticsearchTransportExecutor(DataSourcePackage dataSourcePackage, RouteMappingProvider routeMappingProvider) {
        this.dataSourcePackage = dataSourcePackage;
        this.routeMappingProvider = routeMappingProvider;
    }

    public RestHighLevelClient executor(String profile) {
        if (StringUtils.isEmpty((CharSequence)profile)) {
            return (RestHighLevelClient)this.dataSourcePackage.getFirstIndex();
        }
        String routingKey = this.routeMappingProvider.findRoutingKey(profile);
        return null == routingKey ? (RestHighLevelClient)this.dataSourcePackage.getFirstIndex() : (RestHighLevelClient)this.dataSourcePackage.findIndex(routingKey, true);
    }

    public List<Tuple2<String, RestHighLevelClient>> executors(Collection<String> profiles) {
        return null;
    }

    public DataSourcePackage getDataSourcePackage() {
        return this.dataSourcePackage;
    }
}

