/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.adapter.elasticsearch;

import com.xforceplus.ultraman.adapter.elasticsearch.ElasticsearchTable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.util.Pair;

public interface ElasticsearchRel
extends RelNode {
    public static final Convention CONVENTION = new Convention.Impl("ELASTICSEARCH", ElasticsearchRel.class);

    public void implement(Implementor var1);

    public static class Implementor {
        public final List<String> list = new ArrayList<String>();
        public final List<Map.Entry<String, RelFieldCollation.Direction>> sort = new ArrayList<Map.Entry<String, RelFieldCollation.Direction>>();
        public final List<Map.Entry<String, String>> aggregations = new ArrayList<Map.Entry<String, String>>();
        public final List<String> groupBy = new ArrayList<String>();
        public final Map<String, String> expressionItemMap = new LinkedHashMap<String, String>();
        public Long offset;
        public Long fetch;
        public RelOptTable table;
        public ElasticsearchTable elasticsearchTable;

        public void add(String findOp) {
            this.list.add(findOp);
        }

        public void addGroupBy(String field) {
            Objects.requireNonNull(field, "field");
            this.groupBy.add(field);
        }

        public void addSort(String field, RelFieldCollation.Direction direction) {
            Objects.requireNonNull(field, "field");
            this.sort.add((Map.Entry<String, RelFieldCollation.Direction>)new Pair((Object)field, (Object)direction));
        }

        public void addAggregation(String field, String expression) {
            Objects.requireNonNull(field, "field");
            Objects.requireNonNull(expression, "expression");
            this.aggregations.add((Map.Entry<String, String>)new Pair((Object)field, (Object)expression));
        }

        public void addExpressionItemMapping(String expressionId, String item) {
            Objects.requireNonNull(expressionId, "expressionId");
            Objects.requireNonNull(item, "item");
            this.expressionItemMap.put(expressionId, item);
        }

        public void offset(long offset) {
            this.offset = offset;
        }

        public void fetch(long fetch) {
            this.fetch = fetch;
        }

        public void visitChild(int ordinal, RelNode input) {
            assert (ordinal == 0);
            ((ElasticsearchRel)input).implement(this);
        }
    }
}

