/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.adapter.elasticsearch;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.xforceplus.metadata.schema.dsl.metadata.__;
import com.xforceplus.metadata.schema.runtime.MetadataEngine;
import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.ultraman.adapter.elasticsearch.ElasticsearchTable;
import com.xforceplus.ultraman.adapter.elasticsearch.ElasticsearchTransport;
import com.xforceplus.ultraman.adapter.elasticsearch.utils.DynamicConfigUtils;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.sdk.core.calcite.LazySchemaMap;
import com.xforceplus.ultraman.sdk.core.datasource.route.dynamic.config.DynamicConfig;
import com.xforceplus.ultraman.sdk.core.facade.ProfileFetcher;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.elasticsearch.client.RestClient;

public class ElasticsearchSchema
extends AbstractSchema {
    private MetadataEngine metadataEngine;
    private EntityClassEngine classEngine;
    private ContextService contextService;
    private ProfileFetcher fetcher;
    private DynamicConfig dynamicConfig;
    private int fetchSize;
    private RestClient client;
    private ObjectMapper mapper;
    private Map<String, Table> tableMap;
    private String appCode;

    @VisibleForTesting
    ElasticsearchSchema(RestClient client, ObjectMapper mapper, MetadataEngine metadataEngine, ProfileFetcher fetcher, EntityClassEngine entityClassEngine, ContextService contextService, String appCode, DynamicConfig dynamicConfig, int fetchSize) {
        this.client = Objects.requireNonNull(client, "client");
        this.mapper = Objects.requireNonNull(mapper, "mapper");
        this.metadataEngine = metadataEngine;
        Preconditions.checkArgument((fetchSize > 0 ? 1 : 0) != 0, (String)"invalid fetch size. Expected %s > 0", (int)fetchSize);
        this.fetchSize = fetchSize;
        this.fetcher = fetcher;
        this.classEngine = entityClassEngine;
        this.contextService = contextService;
        this.tableMap = this.createTables();
        this.appCode = appCode;
        this.dynamicConfig = dynamicConfig;
    }

    public ElasticsearchSchema(RestClient client, ObjectMapper mapper, MetadataEngine metadataEngine, EntityClassEngine entityClassEngine, ProfileFetcher fetcher, ContextService contextService, String appCode, DynamicConfig dynamicConfig) {
        this(client, mapper, metadataEngine, fetcher, entityClassEngine, contextService, appCode, dynamicConfig, 5196);
    }

    protected Map<String, Table> getTableMap() {
        return this.tableMap;
    }

    private Map<String, Table> createTables() {
        LazySchemaMap schemaMap = new LazySchemaMap(code -> {
            ElasticsearchTransport transport = new ElasticsearchTransport(this.client, this.mapper, DynamicConfigUtils.insulateTenant(this.dynamicConfig, this.fetcher.getProfile(this.contextService.getAll()), code.toLowerCase(Locale.ROOT), this.appCode), this.fetchSize);
            return new ElasticsearchTable(this.classEngine, transport, this.contextService, this.fetcher);
        });
        schemaMap.keySet(() -> {
            List boList = this.metadataEngine.getMulti((GraphTraversal)__.has((String)"nodeLabel", (Object)"Bo"));
            return boList.stream().map(x -> x.get("code").toString().toLowerCase(Locale.ROOT)).collect(Collectors.toSet());
        });
        return schemaMap;
    }
}

