/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.adapter.elasticsearch;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.xforceplus.metadata.schema.dsl.metadata.__;
import com.xforceplus.metadata.schema.runtime.MetadataEngine;
import com.xforceplus.metadata.schema.utils.MetadataEngineHolder;
import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.ultraman.adapter.elasticsearch.ElasticsearchSchema;
import com.xforceplus.ultraman.adapter.elasticsearch.transport.ElasticsearchTransportExecutor;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.sdk.core.datasource.route.TransportExecutor;
import com.xforceplus.ultraman.sdk.core.datasource.route.dynamic.config.DynamicConfig;
import com.xforceplus.ultraman.sdk.core.facade.ProfileFetcher;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaFactory;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.elasticsearch.client.RestClient;

public class ElasticsearchSchemaFactory
implements SchemaFactory {
    private MetadataEngine metadataEngine;
    private EntityClassEngine classEngine;
    private ContextService contextService;
    private ProfileFetcher fetcher;
    private TransportExecutor transportExecutor;
    private DynamicConfig dynamicConfig;

    public ElasticsearchSchemaFactory(MetadataEngine metadataEngin, EntityClassEngine classEngine, ContextService contextService, TransportExecutor elasticsearchTransportExecutor, ProfileFetcher fetcher, DynamicConfig dynamicConfig) {
        this.metadataEngine = metadataEngin;
        this.fetcher = fetcher;
        this.contextService = contextService;
        this.classEngine = classEngine;
        this.transportExecutor = elasticsearchTransportExecutor;
        this.dynamicConfig = dynamicConfig;
    }

    public Schema create(SchemaPlus schemaPlus, String schema, Map<String, Object> map) {
        HashMap mapping = new HashMap();
        List appList = this.metadataEngine.getMulti((GraphTraversal)__.has((String)"nodeLabel", (Object)"App"));
        String profile = this.fetcher.getProfile(this.contextService.getAll());
        RestClient executor = ((ElasticsearchTransportExecutor)this.transportExecutor).executor(profile).getLowLevelClient();
        appList.forEach(x -> {
            String code = (String)x.get("code");
            ElasticsearchSchema elasticsearchSchema = new ElasticsearchSchema(executor, new ObjectMapper(), MetadataEngineHolder.get(), this.classEngine, this.fetcher, this.contextService, code, this.dynamicConfig);
            schemaPlus.add(code, (Schema)elasticsearchSchema);
            mapping.put(code, elasticsearchSchema);
        });
        return (Schema)mapping.values().stream().findFirst().orElseThrow(() -> new RuntimeException("No Schema Involved"));
    }
}

