/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.adapter.elasticsearch;

import com.google.common.collect.ImmutableList;
import com.xforceplus.ultraman.adapter.elasticsearch.ElasticsearchRel;
import com.xforceplus.ultraman.adapter.elasticsearch.ElasticsearchRules;
import com.xforceplus.ultraman.adapter.elasticsearch.ElasticsearchTable;
import com.xforceplus.ultraman.adapter.elasticsearch.ElasticsearchToEnumerableConverterRule;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.rules.CoreRules;
import org.apache.calcite.rel.type.RelDataType;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ElasticsearchTableScan
extends TableScan
implements ElasticsearchRel {
    private final ElasticsearchTable elasticsearchTable;
    private final RelDataType projectRowType;

    ElasticsearchTableScan(RelOptCluster cluster, RelTraitSet traitSet, RelOptTable table, ElasticsearchTable elasticsearchTable, RelDataType projectRowType) {
        super(cluster, traitSet, (List)ImmutableList.of(), table);
        this.elasticsearchTable = Objects.requireNonNull(elasticsearchTable, "elasticsearchTable");
        this.projectRowType = projectRowType;
        assert (this.getConvention() == ElasticsearchRel.CONVENTION);
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        assert (inputs.isEmpty());
        return this;
    }

    public RelDataType deriveRowType() {
        return this.projectRowType != null ? this.projectRowType : super.deriveRowType();
    }

    public @Nullable RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        float f = this.projectRowType == null ? 1.0f : (float)this.projectRowType.getFieldCount() / 100.0f;
        return super.computeSelfCost(planner, mq).multiplyBy(0.1 * (double)f);
    }

    public void register(RelOptPlanner planner) {
        planner.addRule((RelOptRule)ElasticsearchToEnumerableConverterRule.INSTANCE);
        for (RelOptRule rule : ElasticsearchRules.RULES) {
            planner.addRule(rule);
        }
        planner.removeRule((RelOptRule)CoreRules.AGGREGATE_EXPAND_DISTINCT_AGGREGATES);
    }

    @Override
    public void implement(ElasticsearchRel.Implementor implementor) {
        implementor.elasticsearchTable = this.elasticsearchTable;
        implementor.table = this.table;
    }
}

