/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.adapter.elasticsearch;

import com.xforceplus.ultraman.adapter.elasticsearch.ElasticsearchMethod;
import com.xforceplus.ultraman.adapter.elasticsearch.ElasticsearchRel;
import com.xforceplus.ultraman.adapter.elasticsearch.ElasticsearchRules;
import com.xforceplus.ultraman.adapter.elasticsearch.ElasticsearchTable;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.AbstractList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.calcite.adapter.enumerable.JavaRowFormat;
import org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.MethodCallExpression;
import org.apache.calcite.linq4j.tree.Statement;
import org.apache.calcite.plan.ConventionTraitDef;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterImpl;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.Pair;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ElasticsearchToEnumerableConverter
extends ConverterImpl
implements EnumerableRel {
    ElasticsearchToEnumerableConverter(RelOptCluster cluster, RelTraitSet traits, RelNode input) {
        super(cluster, (RelTraitDef)ConventionTraitDef.INSTANCE, traits, input);
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new ElasticsearchToEnumerableConverter(this.getCluster(), traitSet, (RelNode)ElasticsearchToEnumerableConverter.sole(inputs));
    }

    public @Nullable RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return super.computeSelfCost(planner, mq).multiplyBy(0.1);
    }

    public EnumerableRel.Result implement(EnumerableRelImplementor relImplementor, EnumerableRel.Prefer prefer) {
        BlockBuilder block = new BlockBuilder();
        ElasticsearchRel.Implementor implementor = new ElasticsearchRel.Implementor();
        implementor.visitChild(0, this.getInput());
        final RelDataType rowType = this.getRowType();
        final PhysType physType = PhysTypeImpl.of((JavaTypeFactory)relImplementor.getTypeFactory(), (RelDataType)rowType, (JavaRowFormat)prefer.prefer(JavaRowFormat.ARRAY));
        Expression fields = block.append("fields", (Expression)ElasticsearchToEnumerableConverter.constantArrayList(Pair.zip(ElasticsearchRules.elasticsearchFieldNames(rowType), (List)new AbstractList<Class>(){

            @Override
            public Class get(int index) {
                return physType.fieldClass(index);
            }

            @Override
            public int size() {
                return rowType.getFieldCount();
            }
        }), Pair.class));
        Expression table = block.append("table", implementor.table.getExpression(ElasticsearchTable.ElasticsearchQueryable.class));
        Expression ops = block.append("ops", (Expression)Expressions.constant(implementor.list));
        Expression sort = block.append("sort", (Expression)ElasticsearchToEnumerableConverter.constantArrayList(implementor.sort, Pair.class));
        Expression groupBy = block.append("groupBy", (Expression)Expressions.constant(implementor.groupBy));
        Expression aggregations = block.append("aggregations", (Expression)ElasticsearchToEnumerableConverter.constantArrayList(implementor.aggregations, Pair.class));
        Expression mappings = block.append("mappings", (Expression)Expressions.constant(implementor.expressionItemMap));
        Expression offset = block.append("offset", (Expression)Expressions.constant((Object)implementor.offset));
        Expression fetch = block.append("fetch", (Expression)Expressions.constant((Object)implementor.fetch));
        Expression enumerable = block.append("enumerable", (Expression)Expressions.call((Expression)table, (Method)ElasticsearchMethod.ELASTICSEARCH_QUERYABLE_FIND.method, (Expression[])new Expression[]{ops, fields, sort, groupBy, aggregations, mappings, offset, fetch}));
        block.add((Statement)Expressions.return_(null, (Expression)enumerable));
        return relImplementor.result(physType, block.toBlock());
    }

    private static <T> MethodCallExpression constantArrayList(List<T> values, Class clazz) {
        return Expressions.call((Method)BuiltInMethod.ARRAYS_AS_LIST.method, (Expression[])new Expression[]{Expressions.newArrayInit((Type)clazz, ElasticsearchToEnumerableConverter.constantList(values))});
    }

    private static <T> List<Expression> constantList(List<T> values) {
        return values.stream().map(Expressions::constant).collect(Collectors.toList());
    }
}

