/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.adapter.elasticsearch;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class QueryBuilders {
    private QueryBuilders() {
    }

    static TermQueryBuilder termQuery(String name, String value) {
        return new TermQueryBuilder(name, value);
    }

    static TermQueryBuilder termQuery(String name, int value) {
        return new TermQueryBuilder(name, value);
    }

    static TermQueryBuilder termQuery(String name, char value) {
        return new TermQueryBuilder(name, Character.valueOf(value));
    }

    static TermQueryBuilder termQuery(String name, long value) {
        return new TermQueryBuilder(name, value);
    }

    static TermQueryBuilder termQuery(String name, float value) {
        return new TermQueryBuilder(name, Float.valueOf(value));
    }

    static TermQueryBuilder termQuery(String name, double value) {
        return new TermQueryBuilder(name, value);
    }

    static TermQueryBuilder termQuery(String name, boolean value) {
        return new TermQueryBuilder(name, value);
    }

    static TermQueryBuilder termQuery(String name, Object value) {
        return new TermQueryBuilder(name, value);
    }

    static MatchesQueryBuilder matchesQuery(String name, Iterable<?> values) {
        return new MatchesQueryBuilder(name, values);
    }

    static MatchQueryBuilder matchQuery(String name, Object value) {
        return new MatchQueryBuilder(name, value);
    }

    static TermsQueryBuilder termsQuery(String name, Iterable<?> values) {
        return new TermsQueryBuilder(name, values);
    }

    static RangeQueryBuilder rangeQuery(String name) {
        return new RangeQueryBuilder(name);
    }

    static RegexpQueryBuilder regexpQuery(String name, String regexp) {
        return new RegexpQueryBuilder(name, regexp);
    }

    static BoolQueryBuilder boolQuery() {
        return new BoolQueryBuilder();
    }

    public static ConstantScoreQueryBuilder constantScoreQuery(QueryBuilder queryBuilder) {
        return new ConstantScoreQueryBuilder(queryBuilder);
    }

    public static DisMaxQueryBuilder disMaxQueryBuilder(QueryBuilder queryBuilder) {
        return new DisMaxQueryBuilder(queryBuilder);
    }

    static ExistsQueryBuilder existsQuery(String name) {
        return new ExistsQueryBuilder(name);
    }

    static MatchAllQueryBuilder matchAll() {
        return new MatchAllQueryBuilder();
    }

    private static void writeObject(JsonGenerator generator, Object value) throws IOException {
        generator.writeObject(value);
    }

    static class MatchAllQueryBuilder
    extends QueryBuilder {
        private MatchAllQueryBuilder() {
        }

        @Override
        void writeJson(JsonGenerator generator) throws IOException {
            generator.writeStartObject();
            generator.writeFieldName("match_all");
            generator.writeStartObject();
            generator.writeEndObject();
            generator.writeEndObject();
        }
    }

    public static class DisMaxQueryBuilder
    extends QueryBuilder {
        private final QueryBuilder builder;

        private DisMaxQueryBuilder(QueryBuilder builder) {
            this.builder = Objects.requireNonNull(builder, "builder");
        }

        @Override
        public void writeJson(JsonGenerator generator) throws IOException {
            generator.writeStartObject();
            generator.writeFieldName("dis_max");
            generator.writeStartObject();
            generator.writeFieldName("queries");
            generator.writeStartArray();
            this.builder.writeJson(generator);
            generator.writeEndArray();
            generator.writeEndObject();
            generator.writeEndObject();
        }
    }

    public static class ConstantScoreQueryBuilder
    extends QueryBuilder {
        private final QueryBuilder builder;

        private ConstantScoreQueryBuilder(QueryBuilder builder) {
            this.builder = Objects.requireNonNull(builder, "builder");
        }

        @Override
        public void writeJson(JsonGenerator generator) throws IOException {
            generator.writeStartObject();
            generator.writeFieldName("constant_score");
            generator.writeStartObject();
            generator.writeFieldName("filter");
            this.builder.writeJson(generator);
            generator.writeEndObject();
            generator.writeEndObject();
        }
    }

    static class ExistsQueryBuilder
    extends QueryBuilder {
        private final String fieldName;

        ExistsQueryBuilder(String fieldName) {
            this.fieldName = Objects.requireNonNull(fieldName, "fieldName");
        }

        @Override
        void writeJson(JsonGenerator generator) throws IOException {
            generator.writeStartObject();
            generator.writeFieldName("exists");
            generator.writeStartObject();
            generator.writeStringField("field", this.fieldName);
            generator.writeEndObject();
            generator.writeEndObject();
        }
    }

    static class RegexpQueryBuilder
    extends QueryBuilder {
        private final String fieldName;
        private final String value;

        RegexpQueryBuilder(String fieldName, String value) {
            this.fieldName = fieldName;
            this.value = value;
        }

        @Override
        void writeJson(JsonGenerator generator) throws IOException {
            generator.writeStartObject();
            generator.writeFieldName("wildcard");
            generator.writeStartObject();
            generator.writeFieldName(this.fieldName);
            QueryBuilders.writeObject(generator, this.value.replaceAll("%", "*").replaceAll("_", "."));
            generator.writeEndObject();
            generator.writeEndObject();
        }
    }

    static class RangeQueryBuilder
    extends QueryBuilder {
        private final String fieldName;
        private Object lt;
        private boolean lte;
        private Object gt;
        private boolean gte;
        private String format;

        private RangeQueryBuilder(String fieldName) {
            this.fieldName = Objects.requireNonNull(fieldName, "fieldName");
        }

        private RangeQueryBuilder to(Object value, boolean lte) {
            this.lt = Objects.requireNonNull(value, "value");
            this.lte = lte;
            return this;
        }

        private RangeQueryBuilder from(Object value, boolean gte) {
            this.gt = Objects.requireNonNull(value, "value");
            this.gte = gte;
            return this;
        }

        RangeQueryBuilder lt(Object value) {
            return this.to(value, false);
        }

        RangeQueryBuilder lte(Object value) {
            return this.to(value, true);
        }

        RangeQueryBuilder gt(Object value) {
            return this.from(value, false);
        }

        RangeQueryBuilder gte(Object value) {
            return this.from(value, true);
        }

        RangeQueryBuilder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        void writeJson(JsonGenerator generator) throws IOException {
            String op;
            if (this.lt == null && this.gt == null) {
                throw new IllegalStateException("Either lower or upper bound should be provided");
            }
            generator.writeStartObject();
            generator.writeFieldName("range");
            generator.writeStartObject();
            generator.writeFieldName(this.fieldName);
            generator.writeStartObject();
            if (this.gt != null) {
                op = this.gte ? "gte" : "gt";
                generator.writeFieldName(op);
                QueryBuilders.writeObject(generator, this.gt);
            }
            if (this.lt != null) {
                op = this.lte ? "lte" : "lt";
                generator.writeFieldName(op);
                QueryBuilders.writeObject(generator, this.lt);
            }
            if (this.format != null) {
                generator.writeStringField("format", this.format);
            }
            generator.writeEndObject();
            generator.writeEndObject();
            generator.writeEndObject();
        }
    }

    private static class MatchesQueryBuilder
    extends QueryBuilder {
        private final String fieldName;
        private final Iterable<?> values;

        private MatchesQueryBuilder(String fieldName, Iterable<?> values) {
            this.fieldName = Objects.requireNonNull(fieldName, "fieldName");
            this.values = Objects.requireNonNull(values, "values");
        }

        @Override
        void writeJson(JsonGenerator generator) throws IOException {
            generator.writeStartObject();
            generator.writeFieldName("match");
            generator.writeStartObject();
            generator.writeFieldName(this.fieldName);
            generator.writeStartArray();
            for (Object value : this.values) {
                QueryBuilders.writeObject(generator, value);
            }
            generator.writeEndArray();
            generator.writeEndObject();
            generator.writeEndObject();
        }
    }

    static class MatchQueryBuilder
    extends QueryBuilder {
        private final String fieldName;
        private final Object value;

        private MatchQueryBuilder(String fieldName, Object value) {
            this.fieldName = Objects.requireNonNull(fieldName, "fieldName");
            this.value = Objects.requireNonNull(value, "value");
        }

        @Override
        void writeJson(JsonGenerator generator) throws IOException {
            generator.writeStartObject();
            generator.writeFieldName("match");
            generator.writeStartObject();
            generator.writeFieldName(this.fieldName);
            QueryBuilders.writeObject(generator, this.value);
            generator.writeEndObject();
            generator.writeEndObject();
        }
    }

    private static class TermsQueryBuilder
    extends QueryBuilder {
        private final String fieldName;
        private final Iterable<?> values;

        private TermsQueryBuilder(String fieldName, Iterable<?> values) {
            this.fieldName = Objects.requireNonNull(fieldName, "fieldName");
            this.values = Objects.requireNonNull(values, "values");
        }

        @Override
        void writeJson(JsonGenerator generator) throws IOException {
            generator.writeStartObject();
            generator.writeFieldName("terms");
            generator.writeStartObject();
            generator.writeFieldName(this.fieldName);
            generator.writeStartArray();
            for (Object value : this.values) {
                QueryBuilders.writeObject(generator, value);
            }
            generator.writeEndArray();
            generator.writeEndObject();
            generator.writeEndObject();
        }
    }

    static class TermQueryBuilder
    extends QueryBuilder {
        private final String fieldName;
        private final Object value;

        private TermQueryBuilder(String fieldName, Object value) {
            this.fieldName = Objects.requireNonNull(fieldName, "fieldName");
            this.value = Objects.requireNonNull(value, "value");
        }

        @Override
        void writeJson(JsonGenerator generator) throws IOException {
            generator.writeStartObject();
            generator.writeFieldName("term");
            generator.writeStartObject();
            generator.writeFieldName(this.fieldName);
            QueryBuilders.writeObject(generator, this.value);
            generator.writeEndObject();
            generator.writeEndObject();
        }
    }

    static class BoolQueryBuilder
    extends QueryBuilder {
        private final List<QueryBuilder> mustClauses = new ArrayList<QueryBuilder>();
        private final List<QueryBuilder> mustNotClauses = new ArrayList<QueryBuilder>();
        private final List<QueryBuilder> filterClauses = new ArrayList<QueryBuilder>();
        private final List<QueryBuilder> shouldClauses = new ArrayList<QueryBuilder>();

        BoolQueryBuilder() {
        }

        BoolQueryBuilder must(QueryBuilder queryBuilder) {
            Objects.requireNonNull(queryBuilder, "queryBuilder");
            this.mustClauses.add(queryBuilder);
            return this;
        }

        BoolQueryBuilder filter(QueryBuilder queryBuilder) {
            Objects.requireNonNull(queryBuilder, "queryBuilder");
            this.filterClauses.add(queryBuilder);
            return this;
        }

        BoolQueryBuilder mustNot(QueryBuilder queryBuilder) {
            Objects.requireNonNull(queryBuilder, "queryBuilder");
            this.mustNotClauses.add(queryBuilder);
            return this;
        }

        BoolQueryBuilder should(QueryBuilder queryBuilder) {
            Objects.requireNonNull(queryBuilder, "queryBuilder");
            this.shouldClauses.add(queryBuilder);
            return this;
        }

        @Override
        protected void writeJson(JsonGenerator gen) throws IOException {
            gen.writeStartObject();
            gen.writeFieldName("bool");
            gen.writeStartObject();
            BoolQueryBuilder.writeJsonArray("must", this.mustClauses, gen);
            BoolQueryBuilder.writeJsonArray("filter", this.filterClauses, gen);
            BoolQueryBuilder.writeJsonArray("must_not", this.mustNotClauses, gen);
            BoolQueryBuilder.writeJsonArray("should", this.shouldClauses, gen);
            gen.writeEndObject();
            gen.writeEndObject();
        }

        private static void writeJsonArray(String field, List<QueryBuilder> clauses, JsonGenerator gen) throws IOException {
            if (clauses.isEmpty()) {
                return;
            }
            if (clauses.size() == 1) {
                gen.writeFieldName(field);
                clauses.get(0).writeJson(gen);
            } else {
                gen.writeArrayFieldStart(field);
                for (QueryBuilder clause : clauses) {
                    clause.writeJson(gen);
                }
                gen.writeEndArray();
            }
        }
    }

    static abstract class QueryBuilder {
        QueryBuilder() {
        }

        abstract void writeJson(JsonGenerator var1) throws IOException;
    }
}

