/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.adapter.elasticsearch.config;

import com.xforceplus.metadata.schema.runtime.MetadataEngine;
import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.ultraman.adapter.elasticsearch.ElasticsearchSchemaFactory;
import com.xforceplus.ultraman.adapter.elasticsearch.listener.SdkMetadataListener;
import com.xforceplus.ultraman.adapter.elasticsearch.query.ElasticSearchQueryProvider;
import com.xforceplus.ultraman.adapter.elasticsearch.query.SimpleElasticSearchQueryStrategy;
import com.xforceplus.ultraman.adapter.elasticsearch.service.EngineAdapterService;
import com.xforceplus.ultraman.adapter.elasticsearch.service.impl.ElasticSearchServiceImpl;
import com.xforceplus.ultraman.adapter.elasticsearch.transport.ElasticIndexResolver;
import com.xforceplus.ultraman.adapter.elasticsearch.transport.ElasticsearchTransportExecutor;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.sdk.core.calcite.oqs.DataQueryProvider;
import com.xforceplus.ultraman.sdk.core.calcite.oqs.strategy.QueryProviderSelectStrategy;
import com.xforceplus.ultraman.sdk.core.datasource.DataSourceFactory;
import com.xforceplus.ultraman.sdk.core.datasource.DataSourcePackage;
import com.xforceplus.ultraman.sdk.core.datasource.route.TransportExecutor;
import com.xforceplus.ultraman.sdk.core.datasource.route.dynamic.DynamicRouteMappingProvider;
import com.xforceplus.ultraman.sdk.core.datasource.route.dynamic.RouteMappingProvider;
import com.xforceplus.ultraman.sdk.core.datasource.route.dynamic.config.DynamicConfig;
import com.xforceplus.ultraman.sdk.core.datasource.route.index.IndexConfig;
import com.xforceplus.ultraman.sdk.core.facade.ProfileFetcher;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Properties;
import org.apache.calcite.jdbc.CalciteConnection;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.elasticsearch.client.RestHighLevelClient;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.env.Environment;

@ConditionalOnProperty(value={"xplat.elasticsearch.enabled"}, matchIfMissing=true)
public class UltramanESAutoConfiguration {
    @Lazy
    @Bean
    public DataQueryProvider elasticSearchQueryProvider(RestHighLevelClient restHighLevelClient, MetadataEngine metadataEngine, EntityClassEngine engine, ContextService contextService, ProfileFetcher fetcher) throws SQLException, IllegalAccessException {
        return new ElasticSearchQueryProvider();
    }

    @Bean
    public QueryProviderSelectStrategy SimpleElasticSearchQueryStrategy() {
        return new SimpleElasticSearchQueryStrategy();
    }

    @ConditionalOnMissingBean(value={TransportExecutor.class})
    @Bean
    public TransportExecutor transportExecutor(DynamicConfig dynamicConfig, Environment env) {
        ElasticIndexResolver resolver = new ElasticIndexResolver();
        DataSourcePackage dataSourcePackage = DataSourceFactory.build((boolean)false, (boolean)false, Collections.singletonList(resolver), (String[])env.getActiveProfiles());
        DynamicRouteMappingProvider routeMappingProvider = new DynamicRouteMappingProvider(dynamicConfig.getIndexRouting());
        return new ElasticsearchTransportExecutor(dataSourcePackage, (RouteMappingProvider)routeMappingProvider);
    }

    @Bean
    public SdkMetadataListener esListener() {
        return new SdkMetadataListener();
    }

    @Bean
    public EngineAdapterService adapterService(IndexConfig indexConfig) {
        return new ElasticSearchServiceImpl(indexConfig.getShards(), indexConfig.getReplicas());
    }

    @Lazy
    @Bean(value={"esConnection"})
    public Connection esConnection(TransportExecutor transportExecutor, MetadataEngine metadataEngine, EntityClassEngine engine, ContextService contextService, ProfileFetcher fetcher, DynamicConfig dynamicConfi) throws SQLException {
        Properties info = new Properties();
        info.setProperty("caseSensitive", "false");
        info.setProperty("lex", "MYSQL");
        info.setProperty("conformance", "MYSQL_5");
        Connection connection = DriverManager.getConnection("jdbc:calcite:", info);
        CalciteConnection calciteConn = connection.unwrap(CalciteConnection.class);
        SchemaPlus rootSchema = calciteConn.getRootSchema();
        ElasticsearchSchemaFactory elasticSearchSchemaFactory = new ElasticsearchSchemaFactory(metadataEngine, engine, contextService, transportExecutor, fetcher, dynamicConfi);
        Schema schema = elasticSearchSchemaFactory.create(rootSchema, "", Collections.emptyMap());
        rootSchema.add("", schema);
        return connection;
    }
}

