/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.adapter.elasticsearch.listener;

import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.ultraman.adapter.elasticsearch.service.EngineAdapterService;
import com.xforceplus.ultraman.adapter.elasticsearch.utils.DynamicConfigUtils;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.sdk.core.datasource.route.dynamic.config.DynamicConfig;
import com.xforceplus.ultraman.sdk.core.facade.ProfileFetcher;
import com.xforceplus.ultraman.sdk.infra.Refreshable;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SdkMetadataListener
implements Refreshable {
    private static final Logger log = LoggerFactory.getLogger(SdkMetadataListener.class);
    @Autowired
    private EntityClassEngine entityClassEngine;
    @Autowired
    private EngineAdapterService engineAdapterService;
    @Autowired
    private ProfileFetcher fetcher;
    @Autowired
    private ContextService contextService;
    @Autowired
    private DynamicConfig dynamicConfig;

    public void onRefresh(Object payload) {
        String profile = this.fetcher.getProfile(this.contextService.getAll());
        List allEntities = this.entityClassEngine.findAllEntities(profile);
        allEntities.forEach(iEntityClass -> {
            try {
                Collection allFields = this.entityClassEngine.describe(iEntityClass, profile).getAllFields();
                String indexName = DynamicConfigUtils.insulateTenant(this.dynamicConfig, profile, iEntityClass.code().toLowerCase(Locale.ROOT), iEntityClass.ref().getAppCode().toLowerCase());
                boolean status = this.engineAdapterService.indexExist(indexName, profile) ? this.engineAdapterService.putMapping(indexName, allFields, profile) : this.engineAdapterService.createIndexAndCreateMapping(indexName, allFields, profile);
                if (!status) {
                    log.error(String.format("elasticsearch %s index mapping modification or creation failure.", iEntityClass.code()));
                }
            }
            catch (Exception e) {
                log.error(String.format("elasticsearch %s index mapping modification or creation failure.cause:%s", iEntityClass.code(), e.getMessage()));
            }
        });
    }
}

