/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.adapter.elasticsearch.query;

import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.plus.master.mysql.MysqlSqlDialectEx;
import com.xforceplus.ultraman.oqsengine.plus.storage.pojo.dto.select.SelectConfig;
import com.xforceplus.ultraman.sdk.core.calcite.oqs.DataQueryProvider;
import com.xforceplus.ultraman.sdk.core.utils.MasterStorageHelper;
import com.xforceplus.ultraman.sdk.infra.base.ExecutionConfig;
import io.vavr.Tuple2;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.calcite.DataContext;
import org.apache.calcite.config.Lex;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.rel2sql.RelToSqlConverter;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.StructKind;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlAsOperator;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOrderBy;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.dialect.MysqlSqlDialect;
import org.apache.calcite.sql.fun.SqlCountAggFunction;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;

public class ElasticSearchQueryProvider
implements DataQueryProvider {
    @Lazy
    @Qualifier(value="esConnection")
    @Autowired
    private Connection esConnection;
    @Autowired
    private ContextService contextService;
    @Lazy
    @Autowired
    private ExecutionConfig executionConfig;

    public DataQueryProvider.QueryProviderType type() {
        return DataQueryProvider.QueryProviderType.INDEX;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Object> query(String app, IEntityClass entityClass, String profile, RelDataType type, List<RexNode> ops, List<Map.Entry<String, Tuple2<StructKind, Class>>> fields, List<Pair<RexNode, String>> projects, List<Map.Entry<String, RelFieldCollation.Direction>> sort, Long offset, Long fetch, List<String> groupBy, List<AggregateCall> aggs, List<RelHint> hints, RelNode rawTree, DataContext dataContext) {
        HashMap context = new HashMap();
        SelectConfig selectConfig = new SelectConfig();
        selectConfig.setRexNodes(ops);
        selectConfig.setFields(fields);
        selectConfig.setRelDataType(type);
        selectConfig.setSorts(sort);
        selectConfig.setOffset(Optional.ofNullable(offset).map(Long::intValue).orElse(0).intValue());
        selectConfig.setFetch(Optional.ofNullable(fetch).map(Long::intValue).orElse(20).intValue());
        selectConfig.setProjects(projects);
        selectConfig.setAggs(aggs);
        selectConfig.setGroupBy(groupBy);
        selectConfig.setHints(hints);
        selectConfig.setContext(context);
        selectConfig.setRawTree(rawTree);
        selectConfig.setProfile(profile);
        selectConfig.setDataContext(dataContext);
        try (Statement statement = this.esConnection.createStatement();){
            SqlNode sqlNode = new RelToSqlConverter(MysqlSqlDialect.DEFAULT).visitRoot(rawTree).asStatement();
            String sql = Util.toLinux((String)sqlNode.toSqlString(MysqlSqlDialect.DEFAULT).getSql()).replaceAll("\n", " ");
            ResultSet resultSet = statement.executeQuery(sql);
            ArrayList<Object> retList = new ArrayList<Object>();
            while (resultSet.next()) {
                ArrayList row = new ArrayList();
                fields.forEach(f -> {
                    Object rs = MasterStorageHelper.getRs((ResultSet)resultSet, (String)((String)f.getKey()), (Class)((Class)((Tuple2)f.getValue())._2));
                    row.add(rs);
                });
                retList.add(row.toArray());
            }
            this.executeQueryCount(statement, selectConfig, sql);
            ArrayList<Object> arrayList = retList;
            return arrayList;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void executeQueryCount(Statement statement, SelectConfig selectConfig, String sql) {
        try {
            SqlParser parser = SqlParser.create((String)sql, (SqlParser.Config)SqlParser.config().withLex(Lex.MYSQL));
            SqlNode sqlNode = parser.parseStmt();
            if (this.hasCount(selectConfig)) {
                SqlSelect query;
                if (sqlNode instanceof SqlSelect) {
                    query = (SqlSelect)sqlNode;
                } else if (sqlNode instanceof SqlOrderBy) {
                    query = (SqlSelect)((SqlOrderBy)sqlNode).query;
                } else {
                    throw new UnsupportedOperationException("The select query is type of " + sqlNode.getClass() + " which is not supported here");
                }
                String countSql = Util.toLinux((String)this.buildCountSql(query).toSqlString(MysqlSqlDialectEx.DEFAULT).getSql()).replaceAll("\n", " ");
                ResultSet resultSet = statement.executeQuery(countSql);
                if (resultSet.next()) {
                    long count = resultSet.getLong("c");
                    this.contextService.getAll().put("show_count", count);
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (SqlParseException e) {
            e.printStackTrace();
        }
    }

    private boolean hasCount(SelectConfig selectConfig) {
        return selectConfig.getHints().stream().anyMatch(x -> x.hintName.equalsIgnoreCase("show_count"));
    }

    private SqlSelect buildCountSql(SqlSelect query) {
        query.setFetch(null);
        query.setOffset(null);
        query.setFetch(null);
        SqlNodeList selectList = query.getSelectList();
        selectList.clear();
        SqlAsOperator sqlAsOperator = new SqlAsOperator();
        SqlBasicCall countSqlBasic = new SqlBasicCall((SqlOperator)new SqlCountAggFunction("COUNT"), (List)selectList, SqlParserPos.ZERO);
        selectList.add((SqlNode)countSqlBasic);
        SqlCharStringLiteral aliasName = SqlLiteral.createCharString((String)"c", (SqlParserPos)SqlParserPos.ZERO);
        selectList.add((SqlNode)aliasName);
        SqlBasicCall sqlBasicCall = new SqlBasicCall((SqlOperator)sqlAsOperator, (List)selectList, SqlParserPos.ZERO);
        selectList.clear();
        selectList.add((SqlNode)sqlBasicCall);
        query.setSelectList(selectList);
        return query;
    }
}

