/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.adapter.elasticsearch.service.impl;

import com.xforceplus.ultraman.adapter.elasticsearch.service.EngineAdapterService;
import com.xforceplus.ultraman.adapter.elasticsearch.service.constant.FieldMappingType;
import com.xforceplus.ultraman.adapter.elasticsearch.service.entity.FieldMapping;
import com.xforceplus.ultraman.adapter.elasticsearch.service.utils.ElasticSearchMappingBuildUtils;
import com.xforceplus.ultraman.adapter.elasticsearch.service.utils.ThreadPoolExecutorUtils;
import com.xforceplus.ultraman.adapter.elasticsearch.transport.ElasticsearchTransportExecutor;
import com.xforceplus.ultraman.adapter.elasticsearch.utils.DynamicConfigUtils;
import com.xforceplus.ultraman.metadata.cdc.OqsEngineEntity;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.metadata.entity.IEntityField;
import com.xforceplus.ultraman.sdk.core.datasource.route.TransportExecutor;
import com.xforceplus.ultraman.sdk.core.datasource.route.dynamic.config.DynamicConfig;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.CreateIndexResponse;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.client.indices.GetMappingsRequest;
import org.elasticsearch.client.indices.GetMappingsResponse;
import org.elasticsearch.client.indices.PutMappingRequest;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ElasticSearchServiceImpl
implements EngineAdapterService {
    private static final Logger log = LoggerFactory.getLogger(ElasticSearchServiceImpl.class);
    @Autowired
    public EntityClassEngine entityClassEngine;
    @Autowired
    private DynamicConfig dynamicConfig;
    private final String defaultEmptyProfile = "default";
    private long writeTimeOut = 5L;
    private int shards;
    private int replicas;
    @Autowired
    private TransportExecutor elasticsearchTransportExecutor;
    private ThreadPoolExecutor executor = ThreadPoolExecutorUtils.executor;

    public void setElasticsearchTransportExecutor(TransportExecutor transportExecutor) {
        this.elasticsearchTransportExecutor = transportExecutor;
    }

    public ElasticSearchServiceImpl(int shards, int replicas) {
        this.shards = shards;
        this.replicas = replicas;
    }

    public void setEntityClassEngine(EntityClassEngine entityClassEngine) {
        this.entityClassEngine = entityClassEngine;
    }

    @Override
    public boolean createIndexAndCreateMapping(String idxName, Collection<IEntityField> allFields, String profile) {
        return this.createIndexAndCreateMapping(idxName.toLowerCase(), allFields, this.shards, this.replicas, profile);
    }

    @Override
    public boolean createIndexAndCreateMapping(String idxName, Collection<IEntityField> allFields, int number_of_shards, int number_of_replicas, String profile) {
        try {
            if (this.indexExist(idxName, profile)) {
                log.warn(" idxName={} \u5df2\u7ecf\u5b58\u5728", (Object)idxName);
                return false;
            }
            CreateIndexRequest request = new CreateIndexRequest(idxName);
            ElasticSearchServiceImpl.buildSetting(request, number_of_shards, number_of_replicas);
            request.mapping(this.getxContentBuilder(allFields));
            RestHighLevelClient executor = ((ElasticsearchTransportExecutor)this.elasticsearchTransportExecutor).executor(profile);
            CreateIndexResponse res = executor.indices().create(request, RequestOptions.DEFAULT);
            return res.isAcknowledged();
        }
        catch (IOException ex) {
            log.error(ex.getMessage());
            throw new RuntimeException(ex.getCause());
        }
    }

    private XContentBuilder getxContentBuilder(Collection<IEntityField> allFields) throws IOException {
        XContentBuilder properties = XContentFactory.jsonBuilder().startObject().field("dynamic", "false").field("properties").startObject();
        for (FieldMapping filed : ElasticSearchMappingBuildUtils.getFieldInfos(allFields)) {
            String filedName;
            String string = filedName = filed.getField().contains(".") ? filed.getField().replace(".", "_") : filed.getField();
            if (StringUtils.equalsIgnoreCase((String)filed.getType(), (String)FieldMappingType.TEXT.getType())) {
                properties = properties.startObject(filedName).field("type", FieldMappingType.TEXT.getType()).field("analyzer", filed.getAnalyzer()).field("fielddata", "true").endObject();
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)filed.getType(), (String)FieldMappingType.KEYWORD.getType())) {
                properties = properties.startObject(filedName).field("type", FieldMappingType.KEYWORD.getType()).endObject();
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)filed.getType(), (String)FieldMappingType.LONG.getType())) {
                properties = properties.startObject(filedName).field("type", FieldMappingType.LONG.getType()).endObject();
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)filed.getType(), (String)FieldMappingType.DOUBLE.getType())) {
                properties = properties.startObject(filedName).field("type", FieldMappingType.DOUBLE.getType()).endObject();
                continue;
            }
            if (!StringUtils.equalsIgnoreCase((String)filed.getType(), (String)FieldMappingType.BOOLEAN.getType())) continue;
            properties = properties.startObject(filedName).field("type", FieldMappingType.BOOLEAN.getType()).endObject();
        }
        properties.endObject();
        properties.endObject();
        return properties;
    }

    @Override
    public boolean putMapping(String idxName, Collection<IEntityField> appendFields, String profile) {
        try {
            Map<String, String> mappings = this.getMappings(idxName, profile);
            ArrayList<IEntityField> addFields = new ArrayList<IEntityField>();
            appendFields.stream().forEach(iEntityField -> {
                if (!mappings.containsKey(iEntityField.name().toLowerCase(Locale.ROOT).replace(".", "_"))) {
                    addFields.add((IEntityField)iEntityField);
                }
            });
            if (addFields.size() > 0) {
                PutMappingRequest putMappingRequest = new PutMappingRequest(new String[]{idxName});
                AcknowledgedResponse acknowledgedResponse = ((ElasticsearchTransportExecutor)this.elasticsearchTransportExecutor).executor(profile).indices().putMapping(putMappingRequest.source(this.getxContentBuilder(addFields)), RequestOptions.DEFAULT);
                return acknowledgedResponse.isAcknowledged();
            }
        }
        catch (IOException ex) {
            log.error(ex.getMessage());
            throw new RuntimeException(ex.getCause());
        }
        return true;
    }

    public Map<String, String> getMappings(String idxName, String profile) throws IOException {
        HashMap<String, String> fieldTypes = new HashMap<String, String>();
        GetMappingsRequest getMappings = new GetMappingsRequest().indices(new String[]{idxName});
        GetMappingsResponse getMappingResponse = ((ElasticsearchTransportExecutor)this.elasticsearchTransportExecutor).executor(profile).indices().getMapping(getMappings, RequestOptions.DEFAULT);
        Map mappings = getMappingResponse.mappings();
        Map indexFields = ((MappingMetadata)mappings.get(idxName)).sourceAsMap();
        indexFields.entrySet().stream().filter(x -> "properties".equalsIgnoreCase((String)x.getKey())).forEach(entry -> {
            Map fieldProperties = (Map)entry.getValue();
            fieldProperties.entrySet().stream().forEach(field -> fieldTypes.put((String)field.getKey(), (String)((Map)field.getValue()).get("type")));
        });
        return fieldTypes;
    }

    @Override
    public boolean indexExist(String idxName, String profile) {
        try {
            GetIndexRequest request = new GetIndexRequest(new String[]{idxName.toLowerCase(Locale.ROOT)});
            boolean exists = ((ElasticsearchTransportExecutor)this.elasticsearchTransportExecutor).executor(profile).indices().exists(request, RequestOptions.DEFAULT);
            return exists;
        }
        catch (IOException ex) {
            log.error(ex.getMessage());
            throw new RuntimeException(ex.getCause());
        }
    }

    public static void buildSetting(CreateIndexRequest request, int number_of_shards, int number_of_replicas) {
        request.settings(Settings.builder().put("index.number_of_shards", number_of_shards).put("index.number_of_replicas", number_of_replicas).put("index.max_script_fields", 1000));
    }

    @Override
    public boolean deleteIndex(String idxName, String profile) {
        try {
            if (!this.indexExist(idxName, profile)) {
                log.error(" idxName={} \u5df2\u7ecf\u5b58\u5728", (Object)idxName);
                return true;
            }
            AcknowledgedResponse delete = ((ElasticsearchTransportExecutor)this.elasticsearchTransportExecutor).executor(profile).indices().delete(new DeleteIndexRequest(idxName), RequestOptions.DEFAULT);
            return delete.isAcknowledged();
        }
        catch (Exception ex) {
            log.error(ex.getMessage());
            throw new RuntimeException(ex);
        }
    }

    @Override
    public boolean batchUpsertOperation(List<OqsEngineEntity> oqsEngineEntitys) {
        ArrayList<OqsEngineEntity> deleteOqsEngineEntities = new ArrayList<OqsEngineEntity>();
        ArrayList<OqsEngineEntity> updateUpserts = new ArrayList<OqsEngineEntity>();
        oqsEngineEntitys.stream().forEach(oqsEngineEntity -> {
            if (oqsEngineEntity.isDeleted()) {
                deleteOqsEngineEntities.add((OqsEngineEntity)oqsEngineEntity);
            } else {
                updateUpserts.add((OqsEngineEntity)oqsEngineEntity);
            }
        });
        try {
            if (updateUpserts.size() > 0 && !this.saveOrUpdate(updateUpserts)) {
                return false;
            }
            if (deleteOqsEngineEntities.size() > 0 && !this.deleteBatch(deleteOqsEngineEntities).booleanValue()) {
                return false;
            }
        }
        catch (IOException ex) {
            log.error(ex.getMessage());
            throw new RuntimeException(ex);
        }
        return true;
    }

    public boolean saveOrUpdate(List<OqsEngineEntity> oqsEngineEntitys) throws IOException {
        HashMap<String, List<BulkRequest>> tenantBulkRequests = new HashMap<String, List<BulkRequest>>();
        this.handleTenantsBatchRows(oqsEngineEntitys).entrySet().stream().forEach(tenantEngineEntitys -> {
            ArrayList bulkRequests = new ArrayList();
            ((Map)tenantEngineEntitys.getValue()).entrySet().stream().forEach(oqsEngineEntities -> {
                BulkRequest bulkRequest = new BulkRequest();
                ((List)oqsEngineEntities.getValue()).forEach(oqsEngineEntity -> {
                    UpdateRequest updateRequest = new UpdateRequest((String)oqsEngineEntities.getKey(), String.valueOf(oqsEngineEntity.getId()));
                    IndexRequest indexRequest = new IndexRequest((String)oqsEngineEntities.getKey()).source(oqsEngineEntity.getAttributes(), XContentType.JSON);
                    indexRequest.id(String.valueOf(oqsEngineEntity.getId()));
                    updateRequest.doc(indexRequest);
                    updateRequest.docAsUpsert(true);
                    bulkRequest.add(updateRequest);
                });
                bulkRequests.add(bulkRequest);
            });
            tenantBulkRequests.put((String)tenantEngineEntitys.getKey(), bulkRequests);
        });
        return this.sumbitBulk(tenantBulkRequests);
    }

    private boolean sumbitBulk(Map<String, List<BulkRequest>> tenantBulkRequests) {
        ArrayList<Future<Boolean>> futures = new ArrayList<Future<Boolean>>();
        for (Map.Entry<String, List<BulkRequest>> entry : tenantBulkRequests.entrySet()) {
            for (BulkRequest bulkRequest : entry.getValue()) {
                String profile = StringUtils.equalsIgnoreCase((String)entry.getKey(), (String)"default") ? null : entry.getKey();
                bulkRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                Future<Boolean> future = this.executor.submit(() -> {
                    BulkResponse bulk = ((ElasticsearchTransportExecutor)this.elasticsearchTransportExecutor).executor(profile).bulk(bulkRequest, RequestOptions.DEFAULT);
                    if (bulk.hasFailures()) {
                        log.error(bulk.buildFailureMessage());
                        return false;
                    }
                    return true;
                });
                futures.add(future);
            }
        }
        for (Future future : futures) {
            try {
                if (((Boolean)future.get(this.writeTimeOut, TimeUnit.SECONDS)).booleanValue()) continue;
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public Map<String, Map<String, List<OqsEngineEntity>>> handleTenantsBatchRows(List<OqsEngineEntity> oqsEngineEntitys) {
        ConcurrentHashMap<String, Map<String, List<OqsEngineEntity>>> batchRows = new ConcurrentHashMap<String, Map<String, List<OqsEngineEntity>>>();
        oqsEngineEntitys.stream().forEach(oqsEngineEntity -> {
            Optional iEntityClass = this.entityClassEngine.load(String.valueOf(oqsEngineEntity.getEntityClassRef().getId()), oqsEngineEntity.getEntityClassRef().getProfile());
            iEntityClass.ifPresent(iEntity -> {
                Map tenantEngineEntities;
                HashMap orDefault = new HashMap();
                String profile = oqsEngineEntity.getEntityClassRef().getProfile();
                String prefixEntitysKey = "default";
                if (!StringUtils.isEmpty((String)profile)) {
                    prefixEntitysKey = profile;
                }
                tenantEngineEntities = (tenantEngineEntities = (Map)batchRows.putIfAbsent(prefixEntitysKey, orDefault)) == null ? orDefault : tenantEngineEntities;
                ArrayList defaultTenantEntities = new ArrayList();
                List<OqsEngineEntity> oqsEngineEntities = tenantEngineEntities.putIfAbsent(DynamicConfigUtils.insulateTenant(this.dynamicConfig, profile, iEntity.code(), iEntity.ref().getAppCode()), defaultTenantEntities);
                oqsEngineEntities = oqsEngineEntities == null ? defaultTenantEntities : oqsEngineEntities;
                oqsEngineEntities.add((OqsEngineEntity)oqsEngineEntity);
                ArrayList defaultFatherEntities = new ArrayList();
                Optional fatherEntities = this.entityClassEngine.load(String.valueOf(oqsEngineEntity.getFather()), oqsEngineEntity.getEntityClassRef().getProfile());
                Map finalTenantEngineEntities = tenantEngineEntities;
                fatherEntities.ifPresent(fatherEntityClass -> {
                    HashMap<String, Long> fatherAttributes = new HashMap<String, Long>();
                    for (IEntityField field : fatherEntityClass.fields()) {
                        String fieldName = field.name().replace(".", "_");
                        if (StringUtils.equalsIgnoreCase((String)fieldName, (String)"id")) {
                            fatherAttributes.put(fieldName, oqsEngineEntity.getId());
                            continue;
                        }
                        fatherAttributes.put(fieldName, (Long)oqsEngineEntity.getAttributes().get(fieldName));
                        oqsEngineEntity.getAttributes().remove(fieldName);
                    }
                    List fatherOqsEngineEntities = finalTenantEngineEntities.putIfAbsent(DynamicConfigUtils.insulateTenant(this.dynamicConfig, profile, iEntity.code(), iEntity.ref().getAppCode()), defaultFatherEntities);
                    fatherOqsEngineEntities = fatherOqsEngineEntities == null ? defaultFatherEntities : fatherOqsEngineEntities;
                    OqsEngineEntity fatherOqsEngineEntity = new OqsEngineEntity();
                    fatherOqsEngineEntity.setId(oqsEngineEntity.getId());
                    fatherOqsEngineEntity.setAttributes(fatherAttributes);
                    fatherOqsEngineEntities.add(fatherOqsEngineEntity);
                });
            });
        });
        return batchRows;
    }

    public Boolean deleteBatch(List<OqsEngineEntity> oqsEngineEntitys) throws IOException {
        HashMap<String, List<BulkRequest>> tenantBulkRequests = new HashMap<String, List<BulkRequest>>();
        this.handleTenantsBatchRows(oqsEngineEntitys).entrySet().stream().forEach(tenantEngineEntitys -> {
            ArrayList bulkRequests = new ArrayList();
            ((Map)tenantEngineEntitys.getValue()).entrySet().stream().forEach(oqsEngineEntities -> {
                BulkRequest bulkRequest = new BulkRequest();
                ((List)oqsEngineEntities.getValue()).forEach(oqsEngineEntity -> {
                    DeleteRequest deleteRequest = new DeleteRequest((String)oqsEngineEntities.getKey()).id(String.valueOf(oqsEngineEntity.getId()));
                    bulkRequest.add(deleteRequest);
                });
                bulkRequests.add(bulkRequest);
            });
            tenantBulkRequests.put((String)tenantEngineEntitys.getKey(), bulkRequests);
        });
        return this.sumbitBulk(tenantBulkRequests);
    }
}

