/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.adapter.elasticsearch.service.utils;

import com.xforceplus.ultraman.adapter.elasticsearch.service.constant.FieldMappingType;
import com.xforceplus.ultraman.adapter.elasticsearch.service.entity.FieldMapping;
import com.xforceplus.ultraman.metadata.entity.FieldConfig;
import com.xforceplus.ultraman.metadata.entity.FieldType;
import com.xforceplus.ultraman.metadata.entity.IEntityField;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class ElasticSearchMappingBuildUtils {
    public static List<FieldMapping> getFieldInfos(Collection<IEntityField> allFields) {
        return allFields.stream().map(fieldInfo -> {
            FieldMapping build = fieldInfo.type().getJavaType().getSuperclass() == Number.class || fieldInfo.type().getJavaType() == Boolean.class ? FieldMapping.builder().field(fieldInfo.name()).type(ElasticSearchMappingBuildUtils.getType(null, fieldInfo.type())).build() : FieldMapping.builder().field(fieldInfo.name()).type(ElasticSearchMappingBuildUtils.getType(fieldInfo.config().getFuzzyType(), fieldInfo.type())).analyzer(FieldMappingType.SETANALYZER_IK_SMART.getType()).build();
            return build;
        }).collect(Collectors.toList());
    }

    private static String getType(FieldConfig.FuzzyType fuzzyType, FieldType fieldType) {
        switch (fieldType) {
            case ENUM: 
            case STRING: {
                return ElasticSearchMappingBuildUtils.getStringType(fuzzyType, fieldType);
            }
            case BOOLEAN: {
                return FieldMappingType.BOOLEAN.getType();
            }
            case LONG: 
            case DATETIME: {
                return FieldMappingType.LONG.getType();
            }
            case DECIMAL: {
                return FieldMappingType.DOUBLE.getType();
            }
        }
        return FieldMappingType.KEYWORD.getType();
    }

    private static String getStringType(FieldConfig.FuzzyType fuzzyType, FieldType fieldType) {
        if (!Objects.isNull(fuzzyType)) {
            switch (fuzzyType) {
                case NOT: 
                case UNKNOWN: 
                case WILDCARD: {
                    if (StringUtils.equalsIgnoreCase((String)fieldType.getType(), (String)FieldType.STRING.getType())) {
                        return FieldMappingType.KEYWORD.getType();
                    }
                }
                case SEGMENTATION: {
                    if (!StringUtils.equalsIgnoreCase((String)fieldType.getType(), (String)FieldType.STRING.getType())) break;
                    return FieldMappingType.TEXT.getType();
                }
            }
            return FieldMappingType.KEYWORD.getType();
        }
        return FieldMappingType.KEYWORD.getType();
    }
}

