package com.xforceplus.ultraman.extensions.alarm.config;


import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;

@Data
@EnableConfigurationProperties
@ConfigurationProperties(prefix = "xplat.oqsengine.sdk.cdc.alarm")
public class AlarmProperties {
    
    private Boolean enabled = false;
    
    private String ddToken;
    
    private String ddEnv = "dev";
    
    private String ddAuth;
    
    private String ddAction;
    
    private String ddSign;
    
    private String ddUrl;
    
    private String ddReceivers;
    
    private int alarmGroupSize = 100;
    
    private int alarmGroupTime = 5;
}
