package com.xforceplus.ultraman.extensions.alarm.config;

import akka.stream.ActorMaterializer;
import com.xforceplus.apollo.config.Config;
import com.xforceplus.apollo.config.EmailConfig;
import com.xforceplus.ultraman.extensions.alarm.AlarmService;
import com.xforceplus.ultraman.extensions.alarm.impl.AlarmServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.lang.reflect.Field;
import java.util.Properties;

@ConditionalOnProperty("xplat.oqsengine.sdk.alarm.enabled")
@EnableConfigurationProperties(AlarmProperties.class)
@Configuration
@Slf4j
public class AlarmAutoConfiguration {
    
    private void initEmail() {
        EmailConfig config = EmailConfig.getConfig();
        try {
            Field properties = Config.class.getDeclaredField("properties");
            properties.setAccessible(true);
            properties.set(config, new Properties());
            EmailConfig.getConfig().setProperties("isDDEnable", "true");
        } catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
    
    /**
     * 
     * @return
     */
    @Bean
    public EmailConfig emailConfig(AlarmProperties alarmProperties) {
        initEmail();
        if("dev".equalsIgnoreCase(alarmProperties.getDdEnv())) {
            devAlarm();
        } else if("prod".equalsIgnoreCase(alarmProperties.getDdEnv())) {
            prodAlarm();
        }
        
        //override 
        if(alarmProperties.getDdUrl() != null) {
            EmailConfig.getConfig().setProperties("ddUrl", alarmProperties.getDdUrl());
        }

        if(alarmProperties.getDdAuth() != null) {
            EmailConfig.getConfig().setProperties("ddAuthentication", alarmProperties.getDdAuth());
        }

        if(alarmProperties.getDdAction() != null) {
            EmailConfig.getConfig().setProperties("ddAction", alarmProperties.getDdAction());
        }

        if(alarmProperties.getDdSign() != null) {
            EmailConfig.getConfig().setProperties("ddUiaSign", alarmProperties.getDdSign());
        }


        if(alarmProperties.getDdToken() != null) {
            EmailConfig.getConfig().setProperties("ddToken", alarmProperties.getDdToken() );
        }

        if(alarmProperties.getDdReceivers() != null) {
            EmailConfig.getConfig().setProperties("ddReceivers", alarmProperties.getDdReceivers() );
        }
        
        return EmailConfig.getConfig();
    }
    
    
    private void devAlarm() {
        EmailConfig.getConfig().setProperties("ddUrl", "https://janus-inte.xforceplus.com");
        EmailConfig.getConfig().setProperties("ddAuthentication", "2019121617283613203277TN266291299");
        EmailConfig.getConfig().setProperties("ddAction", "F271C9FD3A0E6E4F11846E489FFE95C2");
        EmailConfig.getConfig().setProperties("ddUiaSign", "20d1ae3d4eac58b1ae8b6f779dd189b0");
    }

    private void prodAlarm() {
        EmailConfig.getConfig().setProperties("ddUrl", "https://janus.xforceplus.com");
        EmailConfig.getConfig().setProperties("ddAuthentication", "201907231445251368125TN266291299");
        EmailConfig.getConfig().setProperties("ddAction", "F271C9FD3A0E6E4F11846E489FFE95C2");
        EmailConfig.getConfig().setProperties("ddUiaSign", "dedb7b52315d8d02baf2ae5ffc0ae1c9");
    }
    
    @ConditionalOnBean(EmailConfig.class)
    @Bean
    public AlarmService alarmService(ActorMaterializer materializer) {
        return new AlarmServiceImpl(materializer);
    }
    
}
