package com.xforceplus.ultraman.extensions.alarm.impl;

import akka.stream.ActorAttributes;
import akka.stream.ActorMaterializer;
import akka.stream.OverflowStrategy;
import akka.stream.Supervision;
import akka.stream.javadsl.Sink;
import akka.stream.javadsl.Source;
import akka.stream.javadsl.SourceQueueWithComplete;
import com.xforceplus.apollo.logger.ApolloDdingFactory;
import com.xforceplus.ultraman.extensions.alarm.AlarmService;
import lombok.extern.slf4j.Slf4j;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * send message service
 */
@Slf4j
public class AlarmServiceImpl implements AlarmService {
    
    private Map<String, SourceQueueWithComplete> mapping = new ConcurrentHashMap<>();

    private ActorMaterializer materializer;

    public AlarmServiceImpl(ActorMaterializer materializer) {
        this.materializer = materializer;
    }

    @Override
    public <T> SourceQueueWithComplete<T> initQueue(String token, int bufferSize, int groupSize, int groupTimeInSec
            , Function<T, String> groupKey
            , BiFunction<String, List<T>, String> messageConverter) {
        SourceQueueWithComplete<T> queue = Source.<T>queue(bufferSize, OverflowStrategy.backpressure()).groupedWithin(
                groupSize
                , Duration.ofSeconds(groupTimeInSec)).map(x -> {
            try {
                Map<String, List<T>> groupBy = x.stream()
                        .collect(Collectors.groupingBy(groupKey));
                groupBy.forEach((g, l) -> {
                    ApolloDdingFactory.getFactory().sendDdingNotice(messageConverter.apply(g, l));
                });
            } catch (Throwable throwable) {
                log.error("", throwable);
            }

            return 1;
        }).to(Sink.ignore()).withAttributes(ActorAttributes.withSupervisionStrategy(x -> Supervision.resume())).run(materializer);

        mapping.put(token, queue);
        return queue;
    }
}
