package com.xforceplus.ultraman.extensions.auth.ultraman;

import com.xforceplus.ultraman.datarule.core.provider.IDataRuleProvider;
import com.xforceplus.ultraman.datarule.domain.dto.RuleNodeDTO;
import com.xforceplus.ultraman.extensions.auth.utils.ExpFactoryEx;
import com.xforceplus.ultraman.sdk.core.auth.AuthBuilder;
import com.xforceplus.ultraman.sdk.core.pipeline.TransformerPipeline;
import com.xforceplus.ultraman.sdk.core.rel.legacy.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.*;

@Slf4j
public class UltramanAuth implements AuthBuilder {

    @Autowired
    private IDataRuleProvider dataRuleProvider;

    @Autowired
    private TransformerPipeline transformerPipeline;

    @Override
    public ExpRel getPermissionTreeCondition(Map<Long
            , Set<String>> involvedIdsMapping
            , ExpContext expContext, String profile) {
        try {
            Map<Long, List<RuleNodeDTO>> rules = new HashMap<>();
            rules = Optional.ofNullable(dataRuleProvider.currentUserDataRules(new ArrayList<>(involvedIdsMapping.keySet()))).orElseGet(Collections::emptyMap);

            List<ExpNode> conditions = new ArrayList<>();
            //main query
            rules.forEach((k, v) -> {

                if(expContext.getSchema().getEntityClass().id() == k) {
                    ExpCondition condition = ExpFactoryEx.createFromRuleNodeDTO(v, null);
                    conditions.add(condition);
                } else {
                    Set<String> relationCodes = involvedIdsMapping.get(k);
                    relationCodes.stream().forEach(x -> {
                        ExpCondition condition = ExpFactoryEx.createFromRuleNodeDTO(v, x);
                        conditions.add(condition);
                    });
                }
            });

            if(conditions.isEmpty()) {
                return null;
            }

            ExpQuery expQuery = new ExpQuery().filters(conditions);
            /**
             * will skip calcite and range restrict
             */
            ExpRel permissionExpRel = transformerPipeline.querySideHandleValue(expQuery
                    , expContext, Collections.singleton("calcite"), Collections.singleton("range"));
//
            return permissionExpRel;
        } catch (Exception ex) {
            log.error("permission process error {}", ex);
            //throw ex;
            return null;
        }
    }
}
