/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.extensions.auth.utils;

import com.xforceplus.tenant.data.auth.dto.SqlFieldConditionDTO;
import com.xforceplus.tenant.data.domain.rule.RuleConditionOperation;
import com.xforceplus.tenant.data.domain.rule.RuleConditionValueType;
import com.xforceplus.ultraman.datarule.domain.dto.FieldCondDTO;
import com.xforceplus.ultraman.datarule.domain.dto.RuleNodeDTO;
import com.xforceplus.ultraman.extensions.auth.usercenter.tree.ConditionSQLNode;
import com.xforceplus.ultraman.metadata.domain.vo.dto.ConditionOp;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpCondition;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpField;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpNode;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpOperator;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpValue;
import com.xforceplus.ultraman.sdk.core.rel.tree.BinaryTreeNode;
import com.xforceplus.ultraman.sdk.core.rel.tree.dsl.ConditionNode;
import com.xforceplus.ultraman.sdk.core.rel.tree.dsl.OperationNode;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.apache.commons.lang3.StringUtils;

public class ExpFactoryEx {
    public static ExpCondition createFromRuleNodeDTO(List<RuleNodeDTO> rules, String relation) {
        if (null != rules && !rules.isEmpty()) {
            RuleNodeDTO ruleNodeDTO = rules.get(0);
            String nextRelation = ruleNodeDTO.getNextRelation();
            ExpCondition expCondition = ruleNodeDTO.getIsLeaf() != false ? ExpFactoryEx.createFromFieldConDTO(ruleNodeDTO.getConds(), relation) : ExpFactoryEx.createFromRuleNodeDTO(ruleNodeDTO.getNodes(), relation);
            if (nextRelation != null) {
                ExpOperator nextOp = ExpOperator.valueOf((String)nextRelation);
                return ExpCondition.call((ExpOperator)nextOp, (ExpNode[])new ExpNode[]{expCondition, ExpFactoryEx.createFromRuleNodeDTO(rules.subList(1, rules.size()), relation)});
            }
            return expCondition;
        }
        return ExpCondition.alwaysTrue();
    }

    public static ExpCondition createFromFieldConDTO(List<FieldCondDTO> conds, String relation) {
        if (!conds.isEmpty()) {
            FieldCondDTO fieldCondDTO = conds.get(0);
            String fieldCode = fieldCondDTO.getFieldCode();
            if (!StringUtils.isEmpty((CharSequence)relation)) {
                fieldCode = "_".concat(relation).concat(".").concat(fieldCode);
            }
            String operator = fieldCondDTO.getOperator();
            ExpOperator expOperator = ExpOperator.from((ConditionOp)ConditionOp.valueOf((String)operator));
            List valueList = fieldCondDTO.getValue();
            if (valueList.isEmpty() && expOperator != ExpOperator.IS_NULL && expOperator != ExpOperator.IS_NOT_NULL) {
                return ExpCondition.alwaysFalse();
            }
            ExpCondition condition = ExpCondition.call((ExpOperator)expOperator, (ExpNode)ExpField.field((String)fieldCode), (List)ExpValue.from((Object)valueList));
            String nextRelation = fieldCondDTO.getNextRelation();
            if (nextRelation != null) {
                ExpOperator nextOp = ExpOperator.valueOf((String)nextRelation);
                return ExpCondition.call((ExpOperator)nextOp, (ExpNode[])new ExpNode[]{condition, ExpFactoryEx.createFromFieldConDTO(conds.subList(1, conds.size()), relation)});
            }
            return condition;
        }
        return ExpCondition.alwaysTrue();
    }

    public static ExpCondition createFrom(BinaryTreeNode<ConditionNode> binaryTreeNode) {
        TransformerVisitor transformerVisitor = new TransformerVisitor();
        binaryTreeNode.traversePostorder((BinaryTreeNode.Visitor)transformerVisitor);
        return transformerVisitor.getExpCondition();
    }

    private static ExpOperator toOperator(RuleConditionOperation operation) {
        if (operation == null) {
            return ExpOperator.EQUALS;
        }
        switch (operation) {
            case GREATER: {
                return ExpOperator.GREATER_THAN;
            }
            case LESS: {
                return ExpOperator.LESS_THAN;
            }
            case EQUAL: {
                return ExpOperator.EQUALS;
            }
            case NOT_EQUAL: {
                return ExpOperator.NOT_EQUALS;
            }
            case GREATER_EQUAL: {
                return ExpOperator.GREATER_EQUALS;
            }
            case LESS_EQUAL: {
                return ExpOperator.LESS_EQUALS;
            }
            case AFTER: 
            case CONTAINS: 
            case BEFORE: {
                return ExpOperator.LIKE;
            }
            case LIST: {
                return ExpOperator.IN;
            }
        }
        throw new RuntimeException("InValid operation");
    }

    private static ExpCondition toCondition(String fieldName, SqlFieldConditionDTO sql) {
        RuleConditionOperation operation = sql.getDataOperation();
        ExpOperator operator = ExpFactoryEx.toOperator(operation);
        RuleConditionValueType type = sql.getDataType();
        String value = sql.getTargetValue();
        return ExpCondition.call((ExpOperator)operator, (ExpNode[])new ExpNode[]{ExpField.field((String)fieldName), ExpValue.literal((String)value)});
    }

    static class TransformerVisitor
    implements BinaryTreeNode.Visitor<ConditionNode> {
        private ExpCondition expCondition;
        private Stack<ExpCondition> subConditions = new Stack();

        TransformerVisitor() {
        }

        public void visit(BinaryTreeNode<ConditionNode> node) {
            if (node != null) {
                ConditionNode data = (ConditionNode)node.getData();
                ConditionNode.NodeType nodeType = data.getNodeType();
                if (nodeType == ConditionNode.NodeType.SQL) {
                    String fieldName = ((ConditionSQLNode)data).getFieldName();
                    SqlFieldConditionDTO value = (SqlFieldConditionDTO)data.value();
                    ExpCondition expCondition = ExpFactoryEx.toCondition(fieldName, value);
                    this.subConditions.push(expCondition);
                } else if (nodeType == ConditionNode.NodeType.OP) {
                    OperationNode.OP op = (OperationNode.OP)data.value();
                    LinkedList<ExpCondition> expConditions = new LinkedList<ExpCondition>();
                    while (!this.subConditions.empty()) {
                        expConditions.add(this.subConditions.pop());
                    }
                    if (op == OperationNode.OP.AND) {
                        this.subConditions.push(ExpCondition.call((ExpOperator)ExpOperator.AND, expConditions));
                    } else if (op == OperationNode.OP.OR) {
                        this.subConditions.push(ExpCondition.call((ExpOperator)ExpOperator.OR, expConditions));
                    }
                }
            }
        }

        public ExpCondition getExpCondition() {
            if (this.expCondition == null && !this.subConditions.isEmpty()) {
                this.expCondition = this.subConditions.pop();
            }
            return this.expCondition;
        }
    }
}

