/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.extensions.auth.ultraman;

import com.xforceplus.ultraman.datarule.core.provider.IDataRuleProvider;
import com.xforceplus.ultraman.extensions.auth.utils.ExpFactoryEx;
import com.xforceplus.ultraman.sdk.core.auth.AuthBuilder;
import com.xforceplus.ultraman.sdk.core.pipeline.TransformerPipeline;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpCondition;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpContext;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpQuery;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpRel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class UltramanAuth
implements AuthBuilder {
    private static final Logger log = LoggerFactory.getLogger(UltramanAuth.class);
    @Autowired
    private IDataRuleProvider dataRuleProvider;
    @Autowired
    private TransformerPipeline transformerPipeline;

    public ExpRel getPermissionTreeCondition(Map<Long, Set<String>> involvedIdsMapping, ExpContext expContext, String profile) {
        try {
            Map<Long, List> rules = new HashMap();
            rules = Optional.ofNullable(this.dataRuleProvider.currentUserDataRules(new ArrayList<Long>(involvedIdsMapping.keySet()))).orElseGet(Collections::emptyMap);
            ArrayList conditions = new ArrayList();
            rules.forEach((k, v) -> {
                if (expContext.getSchema().getEntityClass().id() == k.longValue()) {
                    ExpCondition condition = ExpFactoryEx.createFromRuleNodeDTO(v, null);
                    conditions.add(condition);
                } else {
                    Set relationCodes = (Set)involvedIdsMapping.get(k);
                    relationCodes.stream().forEach(x -> {
                        ExpCondition condition = ExpFactoryEx.createFromRuleNodeDTO(v, x);
                        conditions.add(condition);
                    });
                }
            });
            if (conditions.isEmpty()) {
                return null;
            }
            ExpQuery expQuery = new ExpQuery().filters(conditions);
            ExpRel permissionExpRel = this.transformerPipeline.querySideHandleValue((ExpRel)expQuery, expContext, Collections.singleton("calcite"), Collections.singleton("range"));
            return permissionExpRel;
        }
        catch (Exception ex) {
            log.error("permission process error {}", (Throwable)ex);
            return null;
        }
    }
}

