/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.extensions.auth.usercenter;

import com.xforceplus.tenant.data.auth.dto.Category;
import com.xforceplus.tenant.data.auth.dto.RuleDTO;
import com.xforceplus.tenant.data.auth.dto.Status;
import com.xforceplus.tenant.data.auth.exception.ClientRuleException;
import com.xforceplus.tenant.data.auth.store.ClientDataRuleProvider;
import com.xforceplus.ultraman.extensions.auth.utils.ExpFactoryEx;
import com.xforceplus.ultraman.sdk.core.auth.AuthBuilder;
import com.xforceplus.ultraman.sdk.core.exception.PermissionFatalException;
import com.xforceplus.ultraman.sdk.core.pipeline.TransformerPipeline;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpCondition;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpContext;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpNode;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpOperator;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpQuery;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpRel;
import com.xforceplus.ultraman.sdk.core.rel.tree.BinaryTreeNode;
import com.xforceplus.ultraman.sdk.core.rel.tree.builder.TreeBuilder;
import com.xforceplus.ultraman.sdk.core.rel.tree.dsl.ConditionNode;
import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryConfig;
import io.vavr.Tuple;
import java.io.IOException;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class TenantLegacyAuth
implements AuthBuilder {
    private static final Logger log = LoggerFactory.getLogger(TenantLegacyAuth.class);
    private ClientDataRuleProvider clientDataRuleProvider;
    @Value(value="${xplat.oqsengine.sdk.tenant.failOnEx:false}")
    private boolean failOnEx = false;
    @Value(value="${xplat.oqsengine.sdk.tenant.failOnIOEx:false}")
    private boolean failOnIOEx = false;
    @Value(value="${xplat.oqsengine.sdk.tenant.retry:10}")
    private int maxAttempts = 10;
    private RetryConfig permissionRetryConfig = RetryConfig.custom().maxAttempts(this.maxAttempts).waitDuration(Duration.ofMillis(500L)).retryOnException(x -> x != null && x.getCause() instanceof IOException).build();
    @Autowired
    private TreeBuilder treeBuilder;
    @Autowired
    private TransformerPipeline transformerPipeline;

    public ExpRel getPermissionTreeCondition(Map<Long, Set<String>> involvedIdsMapping, ExpContext expContext, String profile) {
        try {
            List rules = Collections.emptyList();
            try {
                rules = Optional.ofNullable(this.clientDataRuleProvider.currentUserDataRules()).orElseGet(Collections::emptyList);
            }
            catch (Throwable throwable) {
                if (this.failOnEx) {
                    log.warn("fast fail on permission error");
                    throw new PermissionFatalException();
                }
                if (throwable instanceof ClientRuleException) {
                    if (throwable.getCause() != null) {
                        if (throwable.getCause() instanceof IOException) {
                            if (this.failOnIOEx) {
                                log.warn("fast fail on permission IO error");
                                throw new PermissionFatalException();
                            }
                            log.error("permission process error got IO exception try to retry");
                            Retry permission = Retry.of((String)"permission", (RetryConfig)this.permissionRetryConfig);
                            rules = (List)permission.executeSupplier(() -> this.clientDataRuleProvider.currentUserDataRules());
                        }
                        throw throwable;
                    }
                    throw throwable;
                }
                throw throwable;
            }
            Set filteredRules = rules.stream().flatMap(x -> {
                if (x.getStatus() == Status.VALID && involvedIdsMapping.containsKey(x.getMetaDataId()) && x.getCategory() == Category.SQL) {
                    Set related = Optional.ofNullable(involvedIdsMapping.get(x.getMetaDataId())).orElseGet(Collections::emptySet);
                    return related.stream().map(r -> Tuple.of((Object)r, (Object)x));
                }
                return null;
            }).filter(Objects::nonNull).collect(Collectors.toSet());
            List conditions = filteredRules.stream().map(x -> {
                BinaryTreeNode nodeTree = this.treeBuilder.build(((RuleDTO)x._2).getRuleConditions(), (String)x._1());
                ExpCondition condition = ExpFactoryEx.createFrom((BinaryTreeNode<ConditionNode>)nodeTree);
                return condition;
            }).collect(Collectors.toList());
            ExpCondition condition = ExpCondition.call((ExpOperator)ExpOperator.AND, conditions);
            ExpQuery expQuery = new ExpQuery().filters((ExpNode)condition);
            ExpRel permissionExpRel = this.transformerPipeline.querySideHandleValue((ExpRel)expQuery, expContext, Collections.singleton("calcite"), Collections.singleton("range"));
            return permissionExpRel;
        }
        catch (Exception ex) {
            log.error("permission process error {}", (Throwable)ex);
            if (ex instanceof PermissionFatalException) {
                throw ex;
            }
            return null;
        }
    }
}

