/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.extensions.auth.ultraman;

import com.xforceplus.ultraman.datarule.core.provider.IDataRuleProvider;
import com.xforceplus.ultraman.datarule.domain.dto.v2.EntityActionRuleDetailDTO;
import com.xforceplus.ultraman.datarule.domain.enums.EntityActionType;
import com.xforceplus.ultraman.extensions.auth.ultraman.ExternalRuleTransformer;
import com.xforceplus.ultraman.sdk.core.auth.AuthBuilder;
import com.xforceplus.ultraman.sdk.core.pipeline.OperationType;
import com.xforceplus.ultraman.sdk.core.pipeline.TransformerPipeline;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpContext;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpNode;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpQuery;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpRel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class UltramanAuth
implements AuthBuilder {
    private static final Logger log = LoggerFactory.getLogger(UltramanAuth.class);
    @Autowired
    private IDataRuleProvider dataRuleProvider;
    @Autowired
    private TransformerPipeline transformerPipeline;
    @Autowired
    private ExternalRuleTransformer externalRuleTransformer;

    private EntityActionType toType(OperationType type) {
        switch (type) {
            case REPLACE: 
            case UPDATE: {
                return EntityActionType.UPDATE;
            }
            case DELETE: {
                return EntityActionType.DELETE;
            }
            case CREATE: {
                return EntityActionType.CREATE;
            }
        }
        return EntityActionType.READ;
    }

    public ExpRel getPermissionTreeCondition(Map<Long, Set<String>> involvedIdsMapping, ExpContext expContext, String profile, OperationType type) {
        try {
            HashMap<Long, EntityActionRuleDetailDTO> rules = new HashMap();
            rules = Optional.ofNullable(this.dataRuleProvider.currentUserDataRules(new ArrayList<Long>(involvedIdsMapping.keySet()), this.toType(type))).orElseGet(Collections::emptyMap);
            List<ExpNode> conditions = this.externalRuleTransformer.transform(expContext, rules, involvedIdsMapping);
            if (conditions.isEmpty()) {
                return null;
            }
            ExpQuery expQuery = new ExpQuery().filters(conditions);
            ExpRel permissionExpRel = this.transformerPipeline.querySideHandleValue((ExpRel)expQuery, expContext, Collections.singleton("calcite"), Collections.singleton("range"));
            return permissionExpRel;
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

