package com.xforceplus.ultraman.extensions.auth.config;

import com.xforceplus.tenant.data.auth.store.ClientDataRuleProvider;
import com.xforceplus.ultraman.datarule.core.provider.IDataRuleProvider;
import com.xforceplus.ultraman.extensions.auth.ultraman.UltramanAuth;
import com.xforceplus.ultraman.extensions.auth.usercenter.TenantLegacyAuth;
import com.xforceplus.ultraman.extensions.auth.usercenter.tree.DefaultTreeBuilder;
import com.xforceplus.ultraman.sdk.core.auth.AuthBuilder;
import com.xforceplus.ultraman.sdk.core.rel.tree.builder.TreeBuilder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;

@ConditionalOnClass(name = "com.xforceplus.tenant.data.auth.store.ClientDataRuleProvider")
@Configuration
public class TenantLegacyDataAuthConfiguration {

    @ConditionalOnBean(ClientDataRuleProvider.class)
    @Bean
    public TreeBuilder treeBuilder() {
        return new DefaultTreeBuilder();
    }
    
    @ConditionalOnBean(ClientDataRuleProvider.class)
    @DependsOn("treeBuilder")
    @Bean
    public AuthBuilder tenantUltramanAuth() {
        return new TenantLegacyAuth();
    }
}
