package com.xforceplus.ultraman.extensions.auth.plus;

/**
 * cp from seller 
 * init tenant
 */
public interface ClearAndInitDataService {

    /**
     * 初始化租户下全部组织信息，供组织补全场景使用
     *
     * @param tenantId 租户id
     */
    void initTenantAllOrgDataCache(Long tenantId);

    /**
     * 清除并重新初始化租户下全部组织信息，供组织补全场景使用
     *
     * @param tenantId 租户id
     */
    void clearAndReInitTenantAllOrgDataCache(Long tenantId);

    
    void clearTenantOrgDataCache(Long tenantId, Long orgId, boolean reInit);

    /**
     * 清除用户组织缓存
     *
     * @param tenantId 租户id
     * @param userId   用户id
     */
    void clearUserOrgCache(Long tenantId, Long userId);
}
