package com.xforceplus.ultraman.extensions.auth.plus.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Collections;
import java.util.List;

@Data
public class RestUserData {
    @ApiModelProperty("用户id")
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private Long id;

    @ApiModelProperty("用户名称")
    private String userName = "";

    @ApiModelProperty("用户代码")
    private String userCode = "";

    @ApiModelProperty("用户电话")
    private String mobile = "";

    @ApiModelProperty("用户邮箱")
    private String email = "";

    @ApiModelProperty("域账号名")
    private String username = "";

    @ApiModelProperty("用户编号")
    private String userNumber = "";

    @ApiModelProperty("租户id")
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private Long tenantId = 0L;

    @ApiModelProperty("租户名称")
    private String tenantName = "";

    @ApiModelProperty("租户代码")
    private String tenantCode = "";

    @ApiModelProperty("组织列表")
    private List<OrgData> currentOrgs = Collections.emptyList();

    @ApiModelProperty("公司集合")
    private List<OrgData> parentCompanies = Collections.emptyList();

    @ApiModelProperty("开票终端集合")
    private String ticketOpeningTerminal = "";

    @ApiModelProperty("打印设备集合")
    private String printingEquipment = "";

    @ApiModelProperty("扩展字段权限")
    private String businessExtensionAttribute = "";

    @ApiModelProperty("发票类型")
    private String invoiceType = "";

    private List<OrgData> hostCompanies;
    private List<OrgData> relatedCompanies;
}

